/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.gui.common.BooleanComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.ParcelBlockType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Holder;

public class ParcelInclusionExclusionPane
extends JPanel {
    private static final long serialVersionUID = -1544133497126886714L;
    private JRadioButton[] inclusionButtons;
    private JRadioButton[] exclusionButtons;
    private BooleanComboBox[] booleanComboBoxes;
    private JLabel[] labels;
    private JComponent[] widgets;
    private JCheckBox[] activeButtons;
    private List<ParcelAttributeValueDescriptorModel> descriptors;

    public ParcelInclusionExclusionPane(ModelEnviroment modelEnviroment) {
        this(ParcelInclusionExclusionPane.getDescriptors(modelEnviroment));
    }

    public ParcelInclusionExclusionPane(Collection<ParcelAttributeValueDescriptorModel> descriptors) {
        super(new SpringLayout());
        this.descriptors = new ArrayList<ParcelAttributeValueDescriptorModel>(descriptors);
        this.buildLayout();
    }

    private static Collection<ParcelAttributeValueDescriptorModel> getDescriptors(ModelEnviroment modelEnviroment) {
        Collection<ParcelAttributeValueDescriptorModel> attributeValueDescriptors = modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        LinkedList<ParcelAttributeValueDescriptorModel> filtered = new LinkedList<ParcelAttributeValueDescriptorModel>();
        for (ParcelAttributeValueDescriptorModel descriptor : attributeValueDescriptors) {
            if (descriptor.getAttributeValueType() != AttributeValueType.BOOLEAN) continue;
            filtered.add(descriptor);
        }
        Collections.sort(filtered, new Comparator<ParcelAttributeValueDescriptorModel>(){

            @Override
            public int compare(ParcelAttributeValueDescriptorModel o1, ParcelAttributeValueDescriptorModel o2) {
                Integer sortOrder2;
                Integer sortOrder1 = o1.getSortOrder();
                if (sortOrder1 == (sortOrder2 = o2.getSortOrder())) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    return name1.compareTo(name2);
                }
                if (sortOrder1 == null) {
                    return -1;
                }
                if (sortOrder2 == null) {
                    return 1;
                }
                return sortOrder1.compareTo(sortOrder2);
            }
        });
        return filtered;
    }

    private void buildLayout() {
        int size = this.descriptors.size();
        this.inclusionButtons = new JRadioButton[size];
        this.exclusionButtons = new JRadioButton[size];
        this.booleanComboBoxes = new BooleanComboBox[size];
        this.labels = new JLabel[size];
        this.widgets = new JComponent[size];
        this.activeButtons = new JCheckBox[size];
        int i = 0;
        for (ParcelAttributeValueDescriptorModel descriptor : this.descriptors) {
            JCheckBox activeButton;
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(descriptor.getName());
            panel.add((Component)label, "West");
            this.labels[i] = label;
            JPanel panel2 = new JPanel(new FlowLayout());
            this.activeButtons[i] = activeButton = new JCheckBox();
            panel2.add(activeButton);
            final ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton inclusionButton = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.inclusion", new Serializable[0]));
            buttonGroup.add(inclusionButton);
            panel2.add(inclusionButton);
            this.inclusionButtons[i] = inclusionButton;
            JRadioButton exclusionButton = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.exclusion", new Serializable[0]));
            buttonGroup.add(exclusionButton);
            panel2.add(exclusionButton);
            this.exclusionButtons[i] = exclusionButton;
            final BooleanComboBox booleanBox = new BooleanComboBox(true);
            panel2.add(booleanBox);
            panel.add((Component)panel2, "East");
            this.booleanComboBoxes[i] = booleanBox;
            this.add(panel);
            final Holder<Boolean> disabled = new Holder<Boolean>(false);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!activeButton.isSelected()) {
                        disabled.setElement(true);
                        buttonGroup.clearSelection();
                        booleanBox.setSelectedIndex(0);
                        disabled.setElement(false);
                    }
                }
            };
            activeButton.addActionListener(actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((Boolean)disabled.getElement()).booleanValue()) {
                        activeButton.setSelected(true);
                    }
                }
            };
            inclusionButton.addActionListener(actionListener);
            exclusionButton.addActionListener(actionListener);
            booleanBox.addActionListener(actionListener);
            this.widgets[i] = panel2;
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, size, 1, 5, 5, 2, 2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JRadioButton jRadioButton : this.inclusionButtons) {
            jRadioButton.setEnabled(enabled);
        }
        for (JRadioButton jRadioButton : this.exclusionButtons) {
            jRadioButton.setEnabled(enabled);
        }
        for (JComponent jComponent : this.booleanComboBoxes) {
            ((JComboBox)jComponent).setEnabled(enabled);
        }
        for (JComponent jComponent : this.activeButtons) {
            ((AbstractButton)jComponent).setEnabled(enabled);
        }
    }

    public Collection<BlockDescriptor> getBlockDescriptors() {
        LinkedList<BlockDescriptor> blocks = new LinkedList<BlockDescriptor>();
        int i = 0;
        for (ParcelAttributeValueDescriptorModel desc : this.descriptors) {
            if (this.activeButtons[i].isSelected()) {
                ParcelBlockType parcelBlockType = null;
                if (this.inclusionButtons[i].isSelected()) {
                    parcelBlockType = ParcelBlockType.INCLUSION;
                } else if (this.exclusionButtons[i].isSelected()) {
                    parcelBlockType = ParcelBlockType.EXCLUSION;
                }
                if (parcelBlockType != null) {
                    blocks.add(new BlockDescriptor(desc, this.booleanComboBoxes[i].getSelectedValue(), parcelBlockType));
                }
            }
            ++i;
        }
        return blocks;
    }

    public JLabel[] getLabels() {
        return this.labels;
    }

    public JComponent[] getWidgets() {
        return this.widgets;
    }

    public void setBlockDescriptors(Collection<BlockDescriptor> blockDescriptors) {
        HashMap<ParcelAttributeValueDescriptorModel, BlockDescriptor> blockDescriptorMap = new HashMap<ParcelAttributeValueDescriptorModel, BlockDescriptor>();
        for (BlockDescriptor blockDescriptor : blockDescriptors) {
            blockDescriptorMap.put(blockDescriptor.getParcelAttributeValueDescriptorModel(), blockDescriptor);
        }
        int i = 0;
        for (ParcelAttributeValueDescriptorModel desc : this.descriptors) {
            BlockDescriptor blockDescriptor = (BlockDescriptor)blockDescriptorMap.get(desc);
            if (blockDescriptor == null) {
                this.activeButtons[i].setSelected(false);
                this.inclusionButtons[i].setSelected(true);
                this.exclusionButtons[i].setSelected(false);
                this.booleanComboBoxes[i].setSelectedIndex(0);
            } else {
                ParcelBlockType parcelBlockType = blockDescriptor.getParcelBlockType();
                if (parcelBlockType == null) {
                    this.activeButtons[i].setSelected(false);
                    this.inclusionButtons[i].setSelected(true);
                    this.exclusionButtons[i].setSelected(false);
                    this.booleanComboBoxes[i].setSelectedIndex(0);
                } else {
                    this.activeButtons[i].setSelected(true);
                    switch (parcelBlockType) {
                        case INCLUSION: {
                            this.inclusionButtons[i].setSelected(true);
                            this.exclusionButtons[i].setSelected(false);
                            break;
                        }
                        case EXCLUSION: {
                            this.inclusionButtons[i].setSelected(false);
                            this.exclusionButtons[i].setSelected(true);
                        }
                    }
                    this.booleanComboBoxes[i].setSelectedValue(blockDescriptor.getValue());
                }
            }
            ++i;
        }
    }
}

