/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.filter.ParcelFilterModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.filter.parcel.ParcelFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.CyclingIterator;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.KeyStroke;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;

public abstract class ParcelFilterableMarkerRenderer
extends AbstractFilterableMarkerNavigatorRenderer<ParcelModel, ParcelLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties, ParcelFilterModel> {
    private static final long serialVersionUID = -3156666177979266692L;
    private ModelEnviroment modelEnviroment;
    private AreaPointRenderer areaPointRenderer;
    private AreaLayerModel sourceAreaLayerModel;
    private Map<AreaObjectModel, Color> colorMap;
    private CyclingIterator<Color> cyclingColorIterator;
    private boolean updateCoordinates;
    private ParcelFilterPatternSetupRendererSelektor parcelFilterPatternSetupSelektor;
    private Map<Long, Long> areaObjectIdToLayerIdMap = new HashMap<Long, Long>();

    public ParcelFilterableMarkerRenderer(String name, NavigatorPanel navigatorPanel, Double maxUpp, GeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel sourceAreaLayerModel, boolean updateCoordinates, ModelEnviroment modelEnviroment) {
        this(name, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.markParcels", new Serializable[0]), navigatorPanel, maxUpp, bucketsModel, sourceAreaLayerModel, updateCoordinates, KeyStroke.getKeyStroke(122, 192), modelEnviroment);
    }

    public ParcelFilterableMarkerRenderer(String name, String title, NavigatorPanel navigatorPanel, Double maxUpp, GeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel sourceAreaLayerModel, boolean updateCoordinates, KeyStroke keyStroke, ModelEnviroment modelEnviroment) {
        super(name, title, navigatorPanel, null, null, new DummyPointRenderer(), maxUpp, bucketsModel, false);
        this.modelEnviroment = modelEnviroment;
        ((DummyPointRenderer)this.getPointRenderer()).setParcelRenderer(this);
        super.setMarkerMode(MarkerMode.RECTANGLE_WITHIN);
        this.putValue("AcceleratorKey", keyStroke);
        this.sourceAreaLayerModel = sourceAreaLayerModel;
        this.colorMap = new HashMap<AreaObjectModel, Color>();
        this.cyclingColorIterator = new CyclingIterator<Color>(PaintUtil.RANDOM_COLORS);
        this.updateCoordinates = updateCoordinates;
    }

    @Override
    public void showMarked(Collection<ParcelLocationObject> markedObjects) {
        if (markedObjects == null) {
            return;
        }
        Collection<ParcelModel> parcels = this.createParcelCollection(markedObjects);
        CollectionUtil.transform(markedObjects, parcels, new Transformer<ParcelLocationObject, ParcelModel>(){

            @Override
            public ParcelModel transform(ParcelLocationObject t) {
                return (ParcelModel)t.getModel();
            }
        });
        this.updatePanelAfterMark(this.getRenderObjectType(), parcels);
    }

    protected Collection<ParcelModel> createParcelCollection(Collection<ParcelLocationObject> markedObjects) {
        return new HashSet<ParcelModel>(markedObjects.size());
    }

    protected abstract void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType var1, Collection<ParcelModel> var2);

    @Override
    protected void showClicked(Collection<ParcelLocationObject> clickedObjects) {
        if (clickedObjects == null || clickedObjects.isEmpty()) {
            return;
        }
        ArrayList<ParcelModel> parcels = new ArrayList<ParcelModel>(clickedObjects.size());
        CollectionUtil.transform(clickedObjects, parcels, new Transformer<ParcelLocationObject, ParcelModel>(){

            @Override
            public ParcelModel transform(ParcelLocationObject t) {
                return (ParcelModel)t.getModel();
            }
        });
        ParcelDialog parcelDialog = this.createParcelDialog(parcels);
        parcelDialog.setInternalFrame(this.getInternalFrame());
        parcelDialog.setVisible(true);
    }

    protected PausableInternalFrame getInternalFrame() {
        return null;
    }

    protected ParcelDialog createParcelDialog(Collection<ParcelModel> parcels) {
        return new ParcelDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), parcels.iterator().next(), Dialog.ModalityType.APPLICATION_MODAL, this.modelEnviroment, false, this.updateCoordinates);
    }

    @Override
    protected AbstractFilterPatternSetupRendererSelektor<?, ParcelModel, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor() {
        return this.parcelFilterPatternSetupSelektor;
    }

    @Override
    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    protected void drawHover(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, Collection<ParcelLocationObject> hovers, double upp) {
    }

    @Override
    protected void paintOnto(double upp, Graphics2D g2da, Collection<ParcelLocationObject> objects) {
        if (!objects.isEmpty()) {
            HashSet<Long> areaObjectIds = new HashSet<Long>();
            for (ParcelLocationObject parcelLocationObject : objects) {
                ParcelModel parcel = (ParcelModel)parcelLocationObject.getModel();
                for (AreaObjectParcelRelModel areaObjectParcelRelModel : parcel.iterableAreaObjectParcelRel()) {
                    Long areaObjectId = areaObjectParcelRelModel.getAreaObject().getId();
                    if (this.areaObjectIdToLayerIdMap.containsKey(areaObjectId)) continue;
                    areaObjectIds.add(areaObjectId);
                }
            }
            if (!areaObjectIds.isEmpty()) {
                Collection<Tupel<Long, Long>> idTupels = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchLayerIdsForAreaObjectIds(areaObjectIds);
                areaObjectIds = null;
                for (Tupel<Long, Long> tupel : idTupels) {
                    this.areaObjectIdToLayerIdMap.put(tupel.getElement1(), tupel.getElement2());
                }
            }
        }
        super.paintOnto(upp, g2da, objects);
    }

    @Override
    protected boolean isToDrawObject(ParcelLocationObject s) {
        return true;
    }

    public void setParcelFilterPatternSetup(ParcelFilterPatternSetupModel parcelFilterPatternSetupModel, ModelEnviroment modelEnviroment) {
        this.clearRendererCache();
        ParcelFilterPatternSetupRendererSelektor parcelFilterPatternSetupRendererSelektor = this.parcelFilterPatternSetupSelektor = parcelFilterPatternSetupModel == null ? null : new ParcelFilterPatternSetupRendererSelektor(parcelFilterPatternSetupModel, modelEnviroment);
        if (this.parcelFilterPatternSetupSelektor == null) {
            this.setRendererChecker(null);
        } else {
            this.setRendererChecker(new RendererChecker<ParcelLocationObject>(){

                @Override
                public boolean isToBeRendered(ParcelLocationObject w) {
                    return ParcelFilterableMarkerRenderer.this.parcelFilterPatternSetupSelektor.isToBeRendered(w.getModel());
                }
            });
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    public AbstractFilterableMarkerNavigatorRenderer.RenderObjectType getRenderObjectType() {
        return AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELRENDERER;
    }

    public void removeMarkedParcels(Collection<ParcelModel> parcels) {
        HashSet<ParcelModel> set = new HashSet<ParcelModel>(parcels);
        Collection markedObjects = this.getMarkedObjects();
        ArrayList<ParcelLocationObject> list = new ArrayList<ParcelLocationObject>(parcels.size());
        for (ParcelLocationObject parcelLocationObject : markedObjects) {
            if (!set.contains(parcelLocationObject.getModel())) continue;
            list.add(parcelLocationObject);
        }
        this.removeMarkedObjects(list);
    }

    @Override
    protected Iterable<? extends Model> getChangeListeningModels(ParcelLocationObject s) {
        Iterable<ParcelAttributeValueModel> iterableParcelAttributeValues = ((ParcelModel)s.getModel()).iterableParcelAttributeValues();
        return iterableParcelAttributeValues;
    }

    public AreaPointRenderer getAreaPointRenderer() {
        return this.areaPointRenderer;
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected boolean isUpdateCoordinates() {
        return this.updateCoordinates;
    }

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<ParcelFilterModel> event) {
        super.defaultSelectionChanged(event);
        if (this.parcelFilterPatternSetupSelektor != null) {
            this.parcelFilterPatternSetupSelektor.setShowFilterDefault(event.isSelected());
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<ParcelFilterModel> event) {
        super.filterSelectionChanged(event);
        if (this.parcelFilterPatternSetupSelektor != null) {
            this.parcelFilterPatternSetupSelektor.turnFilter(event.getObjectFilter(), event.isSelected());
        }
        this.getNavigatorPanel().repaint(10L);
    }

    protected static class DummyPointRenderer
    extends AbstractRenderer<DefaultRendererProperties, ImmutablePoint, ParcelLocationObject>
    implements PointRenderer<DefaultRendererProperties, ParcelLocationObject> {
        protected ParcelFilterableMarkerRenderer renderer;

        protected DummyPointRenderer() {
        }

        @Override
        public DefaultRendererProperties createRendererProperties(ParcelLocationObject u) {
            return new DefaultRendererProperties();
        }

        @Override
        public void render(Graphics2D g2d, ParcelLocationObject object, ImmutablePoint geom, DefaultRendererProperties rendererProperties) {
            ParcelModel model = (ParcelModel)object.getModel();
            if (!ParcelModelUtil.checkGeomOfParcel(model)) {
                return;
            }
            double upp = rendererProperties.getUpp();
            double margin = 10.0 * Math.pow(upp, -0.2) * upp;
            this.renderer.areaPointRenderer = new AreaPointRenderer(g2d, upp, geom.getCoordinateFactory());
            ImmutablePoint point = model.getGeom();
            point = (ImmutablePoint)point.getTransformed(this.renderer.getNavigatorPanel().getCoordinateFactory());
            Color colorOfParcel = new Color(Color.WHITE.getRed(), Color.WHITE.getGreen(), Color.WHITE.getBlue(), 150);
            Color backColor = Color.BLACK;
            StreetModel street = model.getStreet();
            if (street == null) {
                colorOfParcel = Color.RED;
            } else if (this.renderer.getMarkedObjects().contains(object)) {
                colorOfParcel = ObjectMarkerNavigatorRenderer.MARK_COLOR;
            } else if (this.renderer.sourceAreaLayerModel != null) {
                boolean found = false;
                for (AreaObjectParcelRelModel areaObjectParcelRelModel : model.iterableAreaObjectParcelRel()) {
                    try {
                        AreaObjectModel areaObject = areaObjectParcelRelModel.getAreaObject();
                        if (areaObject == null) continue;
                        Long areaLayerId = (Long)this.renderer.areaObjectIdToLayerIdMap.get(areaObject.getId());
                        if (areaLayerId == null) {
                            AreaLayerModel areaLayer = areaObject.getAreaLayer();
                            areaLayerId = areaLayer.getId();
                        }
                        if (areaLayerId == null || !areaLayerId.equals(this.renderer.sourceAreaLayerModel.getId())) continue;
                        if (found) {
                            backColor = Color.RED;
                            break;
                        }
                        found = true;
                        colorOfParcel = (Color)this.renderer.colorMap.get(areaObject);
                        if (colorOfParcel != null) continue;
                        colorOfParcel = (Color)this.renderer.cyclingColorIterator.next();
                        this.renderer.colorMap.put(areaObject, colorOfParcel);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            RendererNode node = this.createRendererNode(object, margin, point, colorOfParcel, backColor);
            this.renderer.areaPointRenderer.drawBuilding(node, false);
        }

        protected RendererNode createRendererNode(ParcelLocationObject object, double margin, ImmutablePoint point, Color colorOfParcel, Color backColor) {
            return new RendererNode(this.getStringDisplay(((ParcelModel)object.getModel()).getHouseNumber()) + this.getStringDisplay(((ParcelModel)object.getModel()).getHouseNumberExtension()), point.getCoordinate(), backColor, colorOfParcel, margin);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Dimension getOptimalPreviewDimension() {
            return new Dimension(10, 10);
        }

        public void setParcelRenderer(ParcelFilterableMarkerRenderer parcelRenderer) {
            this.renderer = parcelRenderer;
        }

        @Override
        public void render(Graphics2D g2d, ParcelLocationObject u, Collection<ImmutablePoint> geom, DefaultRendererProperties rendererProperties) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }

        private String getStringDisplay(String string) {
            if (string == null) {
                return "";
            }
            return string;
        }
    }
}

