/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.parcel.arearelation.AreaRelationTableModel2;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ParcelAreaRelationPane
extends JPanel {
    private static final long serialVersionUID = -8508273803242850696L;
    private ParcelModel parcelModel;
    private AreaLayerModel areaLayerModelSelected;
    private Collection<AreaLayerModel> layerExclusions = new ArrayList<AreaLayerModel>();
    private ParcelDialog parcelDialogObject;
    private ModelEnviroment modelEnviroment;
    private JTable table;

    public ParcelAreaRelationPane(ParcelModel parcel, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.parcelModel = parcel;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        this.table = new JTable(new AreaRelationTableModel2(this.parcelModel));
        this.table.getSelectionModel().setSelectionMode(0);
        this.add((Component)new JScrollPane(this.table), "Center");
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER)) {
            JPanel buttonPane = new JPanel(new BorderLayout());
            JButton delete = new JButton(new DeleteAreaRelAction());
            buttonPane.add((Component)delete, "West");
            JButton add = new JButton(new AddAreaRelAction());
            buttonPane.add((Component)add, "East");
            this.add((Component)buttonPane, "South");
        }
    }

    private class AddAreaRelAction
    extends AbstractAction {
        private static final long serialVersionUID = -8697408377385908816L;

        public AddAreaRelAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AreaObjectParcelRelModel areaObjectParcelRelModel : ParcelAreaRelationPane.this.parcelModel.iterableAreaObjectParcelRel()) {
                AreaObjectModel area1 = areaObjectParcelRelModel.getAreaObject();
                ParcelAreaRelationPane.this.layerExclusions.add(area1.getAreaLayer());
            }
            AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(ParcelAreaRelationPane.this.modelEnviroment, false, AreaObjectGenInfoDiscriminator.values(), false, false, ParcelAreaRelationPane.this.layerExclusions);
            ParcelAreaRelationPane.this.areaLayerModelSelected = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
            AreaObjectComboBox areaObjectComboBox = new AreaObjectComboBox(true);
            if (ParcelAreaRelationPane.this.modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObjectsByAreaLayer(ParcelAreaRelationPane.this.areaLayerModelSelected, false) != null) {
                areaLayerComboBox.addActionListener(areaObjectComboBox.createLayerChangeListener(areaLayerComboBox));
            }
            Object[] comboBoxes = new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.chooseAreaLayer", new Serializable[0]), areaLayerComboBox, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.chooseArea", new Serializable[0]), areaObjectComboBox};
            int d = JOptionPane.showConfirmDialog(ParcelAreaRelationPane.this.parcelDialogObject, comboBoxes, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 2);
            switch (d) {
                case 0: {
                    AreaObjectModel selectedItem = (AreaObjectModel)areaObjectComboBox.getSelectedItem();
                    if (selectedItem == null) break;
                    AreaObjectParcelRelModelImpl areaObjectParcelRelModel = new AreaObjectParcelRelModelImpl();
                    areaObjectParcelRelModel.setAreaObject(selectedItem);
                    areaObjectParcelRelModel.setParcel(ParcelAreaRelationPane.this.parcelModel);
                    ((AreaRelationTableModel2)ParcelAreaRelationPane.this.table.getModel()).addAreaObjectParcelRelModel(areaObjectParcelRelModel);
                    break;
                }
            }
        }
    }

    private class DeleteAreaRelAction
    extends AbstractAction {
        private static final long serialVersionUID = -2103924914988322768L;

        public DeleteAreaRelAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = ParcelAreaRelationPane.this.table.getSelectedRow();
            if (selectedRow != -1) {
                AreaRelationTableModel2 relTableObj = (AreaRelationTableModel2)ParcelAreaRelationPane.this.table.getModel();
                String msg = ModelEnviroment.getMessageResolver().resolveMessage("area.parcel.relation.confirmDeletion", (Serializable)relTableObj.getValueAt(selectedRow, 0), (Serializable)relTableObj.getValueAt(selectedRow, 1), (Serializable)relTableObj.getValueAt(selectedRow, 2));
                int d1 = JOptionPane.showConfirmDialog(ParcelAreaRelationPane.this.parcelDialogObject, msg, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 2);
                switch (d1) {
                    case 0: {
                        AreaObjectParcelRelModel areaObjectParcelRelModel = relTableObj.removeAreaObjectParcelObjectAt(selectedRow);
                        areaObjectParcelRelModel.setAreaObject(null);
                        areaObjectParcelRelModel.setParcel(null);
                        areaObjectParcelRelModel.delete();
                        break;
                    }
                }
            } else {
                String msg = ModelEnviroment.getMessageResolver().resolveMessage("area.parcel.relation.notSelectedForDeletion", new Serializable[0]);
                JOptionPane.showMessageDialog(ParcelAreaRelationPane.this.parcelDialogObject, msg);
            }
        }
    }
}

