/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.CityComboBox;
import de.datomino.peppergis.client.gui.map.DistrictComboBox;
import de.datomino.peppergis.client.gui.map.PostcodeComboBox;
import de.datomino.peppergis.client.gui.map.StreetComboBox;
import de.datomino.peppergis.client.gui.navigator.DefaultNavigatorPanel;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class ParcelAddressPane
extends JPanel {
    private static final long serialVersionUID = 7236247239321994383L;
    protected ParcelModel parcel;
    private CountryComboBox country;
    private PostcodeComboBox postcode;
    private DistrictComboBox district;
    private CityComboBox city;
    protected StreetComboBox street;
    private JTextField housenumber;
    private JTextField housenumberExtension;
    private JTextField geomXCoordinate;
    private JTextField geomYCoordinate;
    private ModelEnviroment modelEnviroment;
    private boolean basicEnabled;
    private boolean parcelAttachedElementsOnly;
    private DefaultNavigatorPanel navigatorPanel;
    private DefaultSimplePointRenderer defaultSimplePointRenderer;
    private boolean showImportKey;
    private GeoClientHelper geoClientHelper;

    public ParcelAddressPane(ParcelModel parcel, ModelEnviroment modelEnviroment, boolean basicEnabled, boolean parcelAttachedElementsOnly) {
        this(parcel, modelEnviroment, basicEnabled, parcelAttachedElementsOnly, true);
    }

    public ParcelAddressPane(ParcelModel parcel, ModelEnviroment modelEnviroment, boolean basicEnabled, boolean parcelAttachedElementsOnly, boolean showImportKey) {
        super(new BorderLayout());
        this.parcel = parcel;
        this.modelEnviroment = modelEnviroment;
        this.basicEnabled = basicEnabled;
        this.parcelAttachedElementsOnly = parcelAttachedElementsOnly;
        this.showImportKey = showImportKey;
        this.geoClientHelper = new GeoClientHelper(modelEnviroment);
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        Coordinate geomCoordinate;
        StreetModel streetModel = this.parcel.getStreet();
        PostcodeDistrictRelationModel postcodeDistrictRelationModel = streetModel == null ? null : streetModel.getPostcodeDistrictRelation();
        PostcodeModel postcodeModel = postcodeDistrictRelationModel == null ? null : postcodeDistrictRelationModel.getPostcode();
        DistrictModel districtModel = postcodeDistrictRelationModel == null ? null : postcodeDistrictRelationModel.getDistrict();
        CityModel cityModel = districtModel == null ? null : districtModel.getCity();
        ImmutablePoint geom = this.parcel.getGeom();
        if (geom == null) {
            geomCoordinate = Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0);
        } else {
            geomCoordinate = geom.getCoordinate();
            geomCoordinate = Wgs84Factory.INSTANCE.createCoordinate(geomCoordinate);
        }
        if (this.basicEnabled) {
            this.postcode.setCountry(this.country.getSelectedItem());
            this.city.setPostcode(postcodeModel);
            this.district.setCity(cityModel);
            this.street.setDistrict(districtModel, postcodeModel);
        } else {
            this.postcode.addItem(postcodeModel);
            this.district.addItem(districtModel);
            this.city.addItem(cityModel);
            this.street.addItem(streetModel);
        }
        this.postcode.setSelectedItem(postcodeModel);
        this.district.setSelectedItem(districtModel);
        this.street.setSelectedItem(streetModel);
        this.city.setSelectedItem(cityModel);
        this.housenumber.setText(this.parcel.getHouseNumber());
        this.housenumberExtension.setText(this.parcel.getHouseNumberExtension());
        DecimalFormat df = new DecimalFormat("###.######");
        this.geomXCoordinate.setText(df.format(geomCoordinate.getX()));
        this.geomYCoordinate.setText(df.format(geomCoordinate.getY()));
        if (this.basicEnabled) {
            ParcelActionListener parcelActionListener = new ParcelActionListener();
            this.country.addActionListener(parcelActionListener);
            this.postcode.addActionListener(parcelActionListener);
            this.district.addActionListener(parcelActionListener);
            this.city.addActionListener(parcelActionListener);
        }
        this.defaultSimplePointRenderer.setPoint(ImmutableGeoObjectFactory.createImmutablePoint(geomCoordinate));
        final Coordinate fGeomCoordinate = geomCoordinate;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParcelAddressPane.this.navigatorPanel.center(fGeomCoordinate);
            }
        });
    }

    public void centerCoord() {
        Collection points = this.defaultSimplePointRenderer.getPoint();
        if (points != null && !points.isEmpty()) {
            if (points.size() == 1) {
                this.navigatorPanel.center(((ImmutablePoint)points.iterator().next()).getCoordinate());
            } else {
                ArrayList<Coordinate> coords = new ArrayList<Coordinate>(points.size());
                for (ImmutablePoint point : points) {
                    coords.add(point.getCoordinate());
                }
                this.navigatorPanel.center(coords, 5);
            }
        }
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        if (this.showImportKey) {
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.key", new Serializable[0])));
            JTextField parcelKey = new JTextField(StringUtil.nullToEmpty(this.parcel.getImportKey()));
            parcelKey.setEditable(false);
            panel.add(parcelKey);
        }
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.country", new Serializable[0])));
        this.country = new CountryComboBox(false, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        panel.add(this.country);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.postcode", new Serializable[0])));
        this.postcode = new PostcodeComboBox(this.modelEnviroment, false, this.parcelAttachedElementsOnly);
        this.postcode.setEditable(false);
        panel.add(this.postcode);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0])));
        this.city = new CityComboBox(false, this.parcelAttachedElementsOnly);
        this.city.setEditable(false);
        panel.add(this.city);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0])));
        this.district = new DistrictComboBox(false, this.parcelAttachedElementsOnly);
        this.district.setEditable(false);
        panel.add(this.district);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0])));
        this.street = new StreetComboBox(false, this.parcelAttachedElementsOnly);
        this.street.setEditable(false);
        panel.add(this.street);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumber", new Serializable[0])));
        this.housenumber = new JTextField(3);
        panel.add(this.housenumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0])));
        this.housenumberExtension = new JTextField(3);
        panel.add(this.housenumberExtension);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.longitude", new Serializable[0])));
        this.geomXCoordinate = new JTextField(10);
        panel.add(this.geomXCoordinate);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.latitude", new Serializable[0])));
        this.geomYCoordinate = new JTextField(10);
        panel.add(this.geomYCoordinate);
        SpringUtilities.makeCompactGrid(panel, 9 + (this.showImportKey ? 1 : 0), 2, 5, 5, 2, 2);
        this.add((Component)panel, "North");
        this.navigatorPanel = new DefaultNavigatorPanel(panel);
        this.defaultSimplePointRenderer = new DefaultSimplePointRenderer(Color.GREEN);
        this.navigatorPanel.addRenderer(this.defaultSimplePointRenderer);
        this.add((Component)this.navigatorPanel, "Center");
        this.setEnabled(this.basicEnabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.country.setEnabled(enabled);
        this.postcode.setEnabled(enabled);
        this.district.setEnabled(enabled);
        this.street.setEnabled(enabled);
        this.city.setEnabled(enabled);
        this.housenumber.setEditable(enabled);
        this.housenumberExtension.setEditable(enabled);
        this.geomXCoordinate.setEditable(enabled);
        this.geomYCoordinate.setEditable(enabled);
    }

    public void adaptValuesToModel(boolean updateCoords) throws Exception {
        if (updateCoords) {
            String xString = this.geomXCoordinate.getText().replace(',', '.');
            String yString = this.geomYCoordinate.getText().replace(',', '.');
            double x = Double.parseDouble(xString);
            double y = Double.parseDouble(yString);
            GeomEditorResult result = new GeomEditorResult(Wgs84Factory.INSTANCE.createCoordinate(x, y), null, null, null, false, false, false);
            ParcelModelUtil.setGeomResult(this.parcel, result, this.geoClientHelper);
        }
        this.parcel.setStreet(this.street.getSelectedItem());
        this.parcel.setHouseNumber(this.housenumber.getText());
        this.parcel.setHouseNumberExtension(this.housenumberExtension.getText());
    }

    public void setParcel(ParcelModel parcelModel) {
        this.parcel = parcelModel;
        this.fillValues();
    }

    private class ParcelActionListener
    implements ActionListener {
        private ParcelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ParcelAddressPane.this.basicEnabled) {
                Object source = e.getSource();
                System.out.println(source);
                if (source == ParcelAddressPane.this.country) {
                    ParcelAddressPane.this.postcode.setCountry(ParcelAddressPane.this.country.getSelectedItem());
                } else if (source == ParcelAddressPane.this.postcode) {
                    ParcelAddressPane.this.city.setPostcode(ParcelAddressPane.this.postcode.getSelectedItem());
                } else if (source == ParcelAddressPane.this.district) {
                    ParcelAddressPane.this.street.setDistrict(ParcelAddressPane.this.district.getSelectedItem(), ParcelAddressPane.this.postcode.getSelectedItem());
                } else if (source == ParcelAddressPane.this.city) {
                    ParcelAddressPane.this.district.setCity(ParcelAddressPane.this.city.getSelectedItem());
                }
            }
        }
    }
}

