/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DeleteParcelDialog
extends JDialog {
    private static final long serialVersionUID = -4837787071677233092L;
    private static final int COLUMN_DEL = 3;
    private ParcelModel parcel;
    private ModelEnviroment modelEnviroment;
    private ErrorMessages errorMessages;
    private boolean withTransaction;
    private boolean aborted;
    private AbstractAction deleteAction;

    public DeleteParcelDialog(ParcelModel parcel, ModelEnviroment modelEnviroment, JComponent parent, ErrorMessages errorMessages) {
        this(parcel, modelEnviroment, parent, errorMessages, true);
    }

    public DeleteParcelDialog(ParcelModel parcel, ModelEnviroment modelEnviroment, JComponent parent, ErrorMessages errorMessages, boolean withTransaction) {
        this.parcel = parcel;
        this.modelEnviroment = modelEnviroment;
        this.errorMessages = errorMessages;
        this.withTransaction = withTransaction;
        this.aborted = false;
        this.initialize(SwingUtils.findWindowParent(parent));
    }

    private void initialize(final Window window) {
        try {
            this.setIconImage(ImageIO.read(DeleteParcelDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        super.getContentPane().setLayout(new BorderLayout());
        Label label = new Label(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.related", new Serializable[0]) + ":");
        label.setBounds(new Rectangle(50, 30));
        super.getContentPane().add((Component)label, "North");
        final Label waitLabel = new Label(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]));
        super.getContentPane().add((Component)waitLabel, "Center");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DeleteParcelDialog.this.loadAttached(waitLabel, window);
            }
        });
        t.start();
        super.setTitle(ParcelModelUtil.getDisplayString(this.parcel));
        super.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        super.pack();
        super.setVisible(false);
        SwingUtils.center((Window)this, window);
    }

    private void loadAttached(Label waitLabel, Window window) {
        BaseCaller baseCaller = this.modelEnviroment.getAllCaller().getBaseCaller();
        Collection<LocationModel> locations = baseCaller.getLocationsForParcel(this.parcel);
        final HashMap<LocationModel, Collection<Model>> attachedMap = new HashMap<LocationModel, Collection<Model>>();
        final ArrayList<Model> attachedList = new ArrayList<Model>();
        for (LocationModel location : locations) {
            Collection<Model> attached = baseCaller.getLocationAttached(location);
            for (Model m : attached) {
                if (attachedList.contains(m)) continue;
                attachedList.add(m);
            }
            attachedMap.put(location, attached);
        }
        Collections.sort(attachedList, new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                String class1 = o1.getClass().getSimpleName();
                String class2 = o1.getClass().getSimpleName();
                return class1.compareToIgnoreCase(class2);
            }
        });
        final Object[][] content = this.createTable(attachedList);
        final DefaultTableModel dtm = new DefaultTableModel();
        dtm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (0 < dtm.getRowCount()) {
                    boolean enabled = true;
                    for (int i = 0; i < dtm.getRowCount(); ++i) {
                        if (((Boolean)dtm.getValueAt(i, 3)).booleanValue()) continue;
                        enabled = false;
                        break;
                    }
                    DeleteParcelDialog.this.getDeleteAction().setEnabled(enabled);
                }
            }
        });
        final JTable attachedTable = new JTable(dtm){
            private static final long serialVersionUID = -2100348362891547808L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 3: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        this.deleteAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0])){
            private static final long serialVersionUID = 3365184946501094113L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<Model> deleted = new HashSet<Model>();
                HashSet<Model> updated = new HashSet<Model>();
                for (int i = 0; i < content.length; ++i) {
                    Model m = (Model)attachedList.get(i);
                    Boolean b = (Boolean)attachedTable.getValueAt(i, 3);
                    if (b.booleanValue()) {
                        deleted.add(m);
                        continue;
                    }
                    updated.add(m);
                }
                DeleteParcelDialog.this.delete(deleted, updated, attachedMap);
                DeleteParcelDialog.this.after();
                DeleteParcelDialog.super.dispose();
            }
        };
        dtm.setDataVector(content, this.createHeader());
        attachedTable.setCellSelectionEnabled(false);
        attachedTable.setRowHeight(30);
        attachedTable.setRowMargin(2);
        MultiLineHeaderRenderer hr = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> columns = attachedTable.getColumnModel().getColumns();
        int[] columnWidth = new int[]{30, 200, 50, 30};
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            tableColumn.setHeaderRenderer(hr);
            tableColumn.setPreferredWidth(columnWidth[i]);
            ++i;
        }
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(this.deleteAction));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.skip", new Serializable[0])){
            private static final long serialVersionUID = 1504821113367456634L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteParcelDialog.super.dispose();
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 1504821113367456634L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteParcelDialog.this.setAborted(true);
                DeleteParcelDialog.super.dispose();
            }
        }));
        super.getContentPane().remove(waitLabel);
        super.getContentPane().add((Component)new JScrollPane(attachedTable), "Center");
        super.getContentPane().add((Component)buttonPane, "South");
        super.pack();
        super.setEnabled(true);
        SwingUtils.center((Window)this, window);
    }

    private Object[][] createTable(List<Model> attached) {
        Object[][] content = new Object[attached.size()][4];
        Integer row = 0;
        for (Model m : attached) {
            content[row.intValue()][0] = String.valueOf(row + 1);
            content[row.intValue()][1] = this.getInfo(m);
            content[row.intValue()][2] = this.getType(m);
            content[row.intValue()][3] = false;
            Integer n = row;
            Integer n2 = row = Integer.valueOf(row + 1);
        }
        return content;
    }

    private String getInfo(Model m) {
        String info = "";
        if (m instanceof CustomerModel) {
            CustomerModel cast = (CustomerModel)m;
            info = cast.getCustomerNumber();
        } else if (m instanceof PoiModel) {
            PoiModel cast = (PoiModel)m;
            info = cast.getPoiNumber();
        } else if (m instanceof StopModel) {
            StopModel cast = (StopModel)m;
            info = StopModelUtil.getDisplayString(cast);
        } else if (m instanceof AgencyModel) {
            AgencyModel cast = (AgencyModel)m;
            info = cast.getAgencyNumber();
        } else if (m instanceof LetterModel) {
            LetterModel cast = (LetterModel)m;
            info = LetterModelUtil.getDisplayString(cast);
        } else if (m instanceof BranchModel) {
            BranchModel cast = (BranchModel)m;
            info = cast.getName();
        } else if (m instanceof SubscriptionModel) {
            SubscriptionModel cast = (SubscriptionModel)m;
            info = SubscriptionModelUtil.getDisplayString(cast);
        }
        return info;
    }

    private String getType(Model m) {
        String type = "";
        if (m instanceof CustomerModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.parcelRelation", new Serializable[0]);
        } else if (m instanceof PoiModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0]);
        } else if (m instanceof StopModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]);
        } else if (m instanceof AgencyModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.agency.agency", new Serializable[0]);
        } else if (m instanceof LetterModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.common", new Serializable[0]);
        } else if (m instanceof BranchModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]);
        } else if (m instanceof SubscriptionModel) {
            type = ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscription", new Serializable[0]);
        }
        return type;
    }

    private String[] createHeader() {
        String[] header = new String[]{" \n#\n ", " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0]), " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0])};
        return header;
    }

    private void delete(Collection<Model> deleted, Collection<Model> updated, Map<LocationModel, Collection<Model>> attachedMap) {
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        if (this.withTransaction) {
            undoManager.startTransaction();
        }
        this.handleLocations(deleted, updated, attachedMap);
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : this.parcel.iterableAreaObjectParcelRel()) {
            for (ParcelSortOrderModel order : areaObjectParcelRelModel.iterableSortOrders()) {
                order.delete();
            }
            areaObjectParcelRelModel.delete();
        }
        for (ParcelAttributeValueModel parcelAttributeValueModel : this.parcel.iterableParcelAttributeValues()) {
            parcelAttributeValueModel.delete();
        }
        HashSet<AreaTourModel> toDeletes = new HashSet<AreaTourModel>();
        Collection<AreaStopModel> areaStopModels = this.modelEnviroment.getAllCaller().getTourCaller().fetchAreaStop(this.parcel, null, null, null);
        for (AreaStopModel areaStopModel : areaStopModels) {
            toDeletes.add(areaStopModel.getAreaTourPart().getAreaTour());
        }
        AreaTourModelUtil.deleteAreaTours(toDeletes, this.modelEnviroment);
        this.parcel.setStreet(null);
        this.parcel.delete();
        if (this.withTransaction) {
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.deleted", new Serializable[]{this.parcel.getImportKey() == null ? "?" : this.parcel.getImportKey()}));
        }
    }

    private void handleLocations(Collection<Model> deleted, Collection<Model> updated, Map<LocationModel, Collection<Model>> attachedMap) {
        ImportedLocationModel ipFallback = null;
        for (LocationModel location : attachedMap.keySet()) {
            if (location.getImportedLocation() != null || location.getExternalLocation() != null) {
                location.setParcel(null);
                continue;
            }
            Collection<Model> attached = attachedMap.get(location);
            boolean b = false;
            LinkedList<CustomerModel> customers = new LinkedList<CustomerModel>();
            for (Model m : attached) {
                if (deleted.contains(m)) {
                    if (m instanceof PoiModel) {
                        PoiModel poi = (PoiModel)m;
                        if (PoiModelUtil.deletePoi(poi, this.modelEnviroment, false)) continue;
                        this.errorMessages.addErrorMessage("messages.poi.attached", new Serializable[]{poi.getPoiNumber()});
                        continue;
                    }
                    if (m instanceof LetterModel) {
                        LetterModel letter = (LetterModel)m;
                        LetterModelUtil.deleteLetter(letter, this.modelEnviroment);
                        continue;
                    }
                    if (m instanceof SubscriptionModel) {
                        SubscriptionModel sub = (SubscriptionModel)m;
                        SubscriptionModelUtil.deleteSubscription(sub, this.modelEnviroment);
                        continue;
                    }
                    if (m instanceof StopModel) {
                        StopModel stop = (StopModel)m;
                        StopModelUtil.deleteStop(stop, this.modelEnviroment);
                        continue;
                    }
                    if (m instanceof CustomerModel) {
                        CustomerModel customer = (CustomerModel)m;
                        customers.add(customer);
                        LinkedList<SubscriptionModel> subscriptionsToDelete = new LinkedList<SubscriptionModel>();
                        for (SubscriptionModel subscription : customer.iterableSubscriptions()) {
                            if (!deleted.contains(subscription)) continue;
                            subscriptionsToDelete.add(subscription);
                        }
                        for (SubscriptionModel subscription : subscriptionsToDelete) {
                            customer.removeSubscription(subscription);
                        }
                        continue;
                    }
                    m.delete();
                    continue;
                }
                if (!updated.contains(m)) continue;
                if (ipFallback == null) {
                    ipFallback = this.getImportedLocation();
                }
                location.setImportedLocation(ipFallback);
                if (this.parcel.getBikeSegment() != null) {
                    location.setBikeSegment(this.parcel.getBikeSegment());
                }
                if (this.parcel.getFootSegment() != null) {
                    location.setFootSegment(this.parcel.getFootSegment());
                }
                if (this.parcel.getMotorSegment() != null) {
                    location.setMotorSegment(this.parcel.getMotorSegment());
                }
                b = true;
            }
            if (b) {
                location.setParcel(null);
                if (location.getImportedLocation() != null || location.getExternalLocation() != null) continue;
                if (ipFallback == null) {
                    ipFallback = this.getImportedLocation();
                }
                location.setImportedLocation(ipFallback);
                continue;
            }
            for (CustomerModel customer : customers) {
                customer.setDefaultLocation(null);
            }
            location.delete();
        }
    }

    private ImportedLocationModel getImportedLocation() {
        ImportedLocationModel ipFallback;
        String housenumber = this.parcel.getHouseNumber();
        String housenumberExtension = this.parcel.getHouseNumberExtension();
        StreetModel streetModel = this.parcel.getStreet();
        String street = streetModel.getName();
        PostcodeDistrictRelationModel postcodeDistrictRelationModel = streetModel.getPostcodeDistrictRelation();
        PostcodeModel postcodeModel = postcodeDistrictRelationModel.getPostcode();
        String postcode = postcodeModel.getName();
        Country country = postcodeModel.getCountry();
        DistrictModel districtModel = postcodeDistrictRelationModel.getDistrict();
        String district = districtModel.getName();
        CityModel cityModel = districtModel.getCity();
        String city = cityModel.getName();
        Integer housenumberInt = null;
        try {
            housenumberInt = Integer.valueOf(housenumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collection<ImportedLocationModel> importLocations = this.modelEnviroment.getAllCaller().getStreetNetCaller().findImportLocationsExact(country, postcode, city, district, street, housenumberInt, housenumberExtension, false);
        if (importLocations.isEmpty()) {
            ipFallback = new ImportedLocationModelImpl();
            ipFallback.setCountry(country);
            ipFallback.setPostcode(postcode);
            ipFallback.setCity(city);
            ipFallback.setDistrict(district);
            ipFallback.setStreet(street);
            ipFallback.setHousenumber(housenumberInt);
            ipFallback.setHousenumberExtension(housenumberExtension);
            ipFallback.setGeoLocation(this.parcel.getGeom());
        } else {
            ipFallback = importLocations.iterator().next();
        }
        return ipFallback;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean cancel) {
        this.aborted = cancel;
    }

    public AbstractAction getDeleteAction() {
        return this.deleteAction;
    }

    public void after() {
    }
}

