/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.osm.SimpleOsmTileLoadQueue;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Properties;
import org.ktde.swing.navigator.NavigatorPanel;

public class OsmTileLoadQueue
extends SimpleOsmTileLoadQueue {
    private NavigatorPanel navigatorPanel;
    private boolean doRepaint;
    private MediaTracker tracker;
    private volatile int trackId = 1;

    public OsmTileLoadQueue(Properties properties, NavigatorPanel navigatorPanel, boolean repaint) {
        super(properties);
        this.initialize(navigatorPanel, repaint);
    }

    public OsmTileLoadQueue(Properties properties, NavigatorPanel navigatorPanel, boolean repaint, int parallelThreads, int fetchParents) {
        super(properties, parallelThreads, fetchParents);
        this.initialize(navigatorPanel, repaint);
    }

    private void initialize(NavigatorPanel navigatorPanel, boolean repaint) {
        this.navigatorPanel = navigatorPanel;
        this.doRepaint = repaint;
        this.tracker = new MediaTracker(navigatorPanel);
    }

    @Override
    protected boolean loadImage(Image image) throws InterruptedException {
        this.tracker.addImage(image, this.trackId);
        this.tracker.waitForID(this.trackId);
        boolean imageWasOk = !this.tracker.isErrorID(this.trackId);
        this.tracker.removeImage(image, this.trackId);
        return imageWasOk;
    }

    @Override
    protected void repaint(long tm) {
        if (this.doRepaint) {
            this.navigatorPanel.repaint(tm);
        }
    }
}

