/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.navigator;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutePlannerPane
extends JPanel {
    private static final long serialVersionUID = 497092256831681016L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutePlannerPane.class);
    private final CoordinateFactory coordinateFactory = Wgs84Factory.INSTANCE;
    private NavigatorPanel navigatorPanel;
    private Component parent;
    private ModelEnviroment modelEnviroment;
    private AbstractLayerRenderer renderer;
    private JFormattedTextField startX;
    private JFormattedTextField startY;
    private JFormattedTextField endX;
    private JFormattedTextField endY;
    private EnumComboBox<RouteVehicleType> vehicleType;
    private JTextField distance;
    private JTextField duration;
    private ImmutableLineString lineString = null;

    public RoutePlannerPane(NavigatorPanel navigatorPanel, Component parent, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.navigatorPanel = navigatorPanel;
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.initialize();
    }

    private void initialize() {
        super.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{""})){
            private static final long serialVersionUID = 8824475352941062252L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RoutePlannerPane.this.calculate();
            }
        }), "South");
        JPanel mainPane = new JPanel(new SpringLayout());
        DecimalFormat format = new DecimalFormat("###,###,##0.000000", new DecimalFormatSymbols(Locale.GERMANY));
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0]) + " X"));
        this.startX = new JFormattedTextField(format);
        mainPane.add(this.startX);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0]) + " Y"));
        this.startY = new JFormattedTextField(format);
        mainPane.add(this.startY);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0]) + " X"));
        this.endX = new JFormattedTextField(format);
        mainPane.add(this.endX);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0]) + " Y"));
        this.endY = new JFormattedTextField(format);
        mainPane.add(this.endY);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.logistic.type.RouteVehicleType", new Serializable[0])));
        this.vehicleType = new EnumComboBox<RouteVehicleType>(RouteVehicleType.class, false);
        mainPane.add(this.vehicleType);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.line", new Serializable[0])));
        this.distance = new JTextField();
        this.distance.setEditable(false);
        mainPane.add(this.distance);
        mainPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0])));
        this.duration = new JTextField();
        this.duration.setEditable(false);
        mainPane.add(this.duration);
        SpringUtilities.makeCompactGrid(mainPane, 7, 2, 5, 5, 5, 5);
        super.add((Component)mainPane, "North");
        this.renderer = new AbstractLayerRenderer(false, false, this.parent, this.modelEnviroment){

            @Override
            public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
                if (RoutePlannerPane.this.lineString != null) {
                    SolidLineRenderer lineRenderer = new SolidLineRenderer(upp, true, this.navigatorPanel.getCoordinateFactory());
                    lineRenderer.render(g2d, RoutePlannerPane.this.lineString, Color.BLACK, 1.0f);
                }
                ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory(), null);
                Tupel pointTupel = RoutePlannerPane.this.getPointTupel();
                if (pointTupel.getElement2() != null) {
                    pointRenderer.drawStopWithCircle((ImmutablePoint)pointTupel.getElement2(), "Z", pointRenderer.getPointDensity() * 2.0f);
                }
                if (pointTupel.getElement1() != null) {
                    pointRenderer.drawStopWithCircle((ImmutablePoint)pointTupel.getElement1(), "S", pointRenderer.getPointDensity() * 2.0f);
                }
                return Collections.emptySet();
            }

            @Override
            public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
                if (RoutePlannerPane.this.renderer.isActive() && mouseButton == MouseButton.BUTTON2) {
                    RoutePlannerPane.this.setValue(x, y);
                    this.navigatorPanel.repaint(10L);
                }
                this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public String getName() {
                return "route-planner-renderer";
            }
        };
        this.renderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(this.renderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(this.renderer);
    }

    private void setValue(int x, int y) {
        Point2D.Double point = this.navigatorPanel.getReal(x, y);
        final Coordinate coordinate = this.navigatorPanel.getCoordinateFactory().createCoordinate(point);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0])){
            private static final long serialVersionUID = -2414601902290319456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinate wgs = RoutePlannerPane.this.coordinateFactory.createCoordinate(coordinate);
                RoutePlannerPane.this.startX.setValue(wgs.getX());
                RoutePlannerPane.this.startY.setValue(wgs.getY());
                RoutePlannerPane.this.distance.setText("");
                RoutePlannerPane.this.duration.setText("");
            }
        }));
        popupMenu.add(new JMenuItem(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0])){
            private static final long serialVersionUID = -7350800744786186805L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinate wgs = RoutePlannerPane.this.coordinateFactory.createCoordinate(coordinate);
                RoutePlannerPane.this.endX.setValue(wgs.getX());
                RoutePlannerPane.this.endY.setValue(wgs.getY());
                RoutePlannerPane.this.distance.setText("");
                RoutePlannerPane.this.duration.setText("");
            }
        }));
        popupMenu.pack();
        popupMenu.show(this.navigatorPanel, x, y);
    }

    private void calculate() {
        Tupel<ImmutablePoint, ImmutablePoint> pointTupel = this.getPointTupel();
        if (pointTupel.getElement1() == null || pointTupel.getElement2() == null) {
            return;
        }
        RouteVehicleType vehicle = this.vehicleType.getSelectedValue();
        RouteType routeType = RouteType.FASTEST;
        switch (vehicle) {
            case BIKE: 
            case FOOT: {
                routeType = RouteType.SHORTEST;
                break;
            }
        }
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        GeoDistanceMatrixWrapper result = null;
        try {
            result = tourCaller.getGeoDistance(pointTupel.getElement1(), pointTupel.getElement2(), vehicle, routeType);
        }
        catch (LogisticException e) {
            LOGGER.error("", e);
        }
        if (result == null || result.getLineString() == null) {
            JOptionPane.showMessageDialog(this.navigatorPanel, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.noStringLine", new Serializable[0]), "", 2);
        } else {
            this.lineString = (ImmutableLineString)result.getLineString().getGeoObject();
            this.distance.setText(ClientFormUtil.getNumberString(result.getDistance()));
            this.duration.setText(ClientFormUtil.getSecondTimeString(result.getDuration()));
            List<ImmutablePoint> points = this.lineString.getCoordinates();
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(points.size());
            CollectionUtil.transform(points, coordinates, new Transformer<ImmutablePoint, Coordinate>(){

                @Override
                public Coordinate transform(ImmutablePoint t) {
                    return t.getCoordinate();
                }
            });
            this.navigatorPanel.center(coordinates, 0);
            this.navigatorPanel.repaint(10L);
        }
    }

    private Tupel<ImmutablePoint, ImmutablePoint> getPointTupel() {
        Tupel<Object, Object> pointTupel = new Tupel<Object, Object>(null, null);
        Object startXValue = this.startX.getValue();
        Object startYValue = this.startY.getValue();
        if (startXValue != null && startYValue != null) {
            Coordinate start = this.coordinateFactory.createCoordinate(((Number)startXValue).doubleValue(), ((Number)startYValue).doubleValue());
            pointTupel.setElement1(ImmutableGeoObjectFactory.createImmutablePoint(start));
        }
        Object endXValue = this.endX.getValue();
        Object endYValue = this.endY.getValue();
        if (endXValue != null && endYValue != null) {
            Coordinate end = this.coordinateFactory.createCoordinate(((Number)endXValue).doubleValue(), ((Number)endYValue).doubleValue());
            pointTupel.setElement2(ImmutableGeoObjectFactory.createImmutablePoint(end));
        }
        return pointTupel;
    }

    public void setActive(boolean active) {
        this.renderer.setActive(active);
        if (!active) {
            this.lineString = null;
        }
    }
}

