/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.navigator;

import de.datomino.peppergis.client.gui.common.table.MoveInTableAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class RendererOverviewPane
extends JPanel {
    private static final long serialVersionUID = 2529833965302833508L;
    private JTable renderers;
    private NavigatorPanel navigatorPanel;
    private List<NavigatorRenderer> navigatorRenderers;
    private MoveInTableAction<Object, NavigatorRenderer> moveToTopAction;
    private MoveInTableAction<Object, NavigatorRenderer> moveToBottomAction;
    private MoveInTableAction<Object, NavigatorRenderer> moveUpAction;
    private MoveInTableAction<Object, NavigatorRenderer> moveDownAction;

    public RendererOverviewPane(NavigatorPanel navigatorPanel) {
        super(new BorderLayout());
        this.navigatorPanel = navigatorPanel;
        this.buildLayout(navigatorPanel.getRenderers());
    }

    private void buildLayout(List<NavigatorRenderer> list) {
        this.navigatorRenderers = new ArrayList<NavigatorRenderer>(list);
        RendererOverviewRendererNavigatorActiveListener rendererOverviewRendererNavigatorActiveListener = new RendererOverviewRendererNavigatorActiveListener();
        Object[][] data = new Object[this.navigatorRenderers.size()][2];
        int i = 0;
        for (NavigatorRenderer navigatorRenderer : this.navigatorRenderers) {
            data[i][0] = navigatorRenderer.getName();
            data[i][1] = navigatorRenderer.isActive();
            navigatorRenderer.addNavigatorPanelActiveListener(rendererOverviewRendererNavigatorActiveListener);
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel(data, new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.active", new Serializable[0])});
        this.renderers = new JTable(model);
        this.renderers.getTableHeader().setEnabled(false);
        this.renderers.setSelectionMode(0);
        this.renderers.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.add((Component)new JScrollPane(this.renderers), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel upperButtonPanel = new JPanel(new SpringLayout());
        this.moveToTopAction = new MoveRendererInTableAction("o1", MoveInTableAction.MoveInTableType.HIGHEST, this.renderers, this.navigatorRenderers);
        upperButtonPanel.add(new JButton(this.moveToTopAction));
        this.moveUpAction = new MoveRendererInTableAction("o2", MoveInTableAction.MoveInTableType.UP, this.renderers, this.navigatorRenderers);
        upperButtonPanel.add(new JButton(this.moveUpAction));
        SpringUtilities.makeCompactGrid(upperButtonPanel, 2, 1, 2, 2, 2, 5);
        buttonPanel.add((Component)upperButtonPanel, "North");
        upperButtonPanel = new JPanel(new SpringLayout());
        this.moveDownAction = new MoveRendererInTableAction("o1", MoveInTableAction.MoveInTableType.DOWN, this.renderers, this.navigatorRenderers);
        upperButtonPanel.add(new JButton(this.moveDownAction));
        this.moveToBottomAction = new MoveRendererInTableAction("o2", MoveInTableAction.MoveInTableType.LOWEST, this.renderers, this.navigatorRenderers);
        upperButtonPanel.add(new JButton(this.moveToBottomAction));
        SpringUtilities.makeCompactGrid(upperButtonPanel, 2, 1, 2, 2, 2, 5);
        buttonPanel.add((Component)upperButtonPanel, "South");
        this.add((Component)buttonPanel, "East");
    }

    private void changeRendererOrder() {
        this.navigatorPanel.setRenderers(this.navigatorRenderers);
        this.navigatorPanel.repaint(1L);
    }

    public void reorgWidth() {
    }

    private class RendererOverviewRendererNavigatorActiveListener
    implements NavigatorRendererActiveListener {
        private RendererOverviewRendererNavigatorActiveListener() {
        }

        @Override
        public void valueChanged(NavigatorRendererActivateEvent navigatorPanelActivateEvent) {
            NavigatorRenderer source = navigatorPanelActivateEvent.getSource();
            int index = RendererOverviewPane.this.navigatorRenderers.indexOf(source);
            if (index >= 0) {
                DefaultTableModel dtm = (DefaultTableModel)RendererOverviewPane.this.renderers.getModel();
                dtm.setValueAt(navigatorPanelActivateEvent.isActive(), index, 1);
            }
        }
    }

    private class MoveRendererInTableAction
    extends MoveInTableAction<Object, NavigatorRenderer> {
        private static final long serialVersionUID = -3791034973552715695L;

        public MoveRendererInTableAction(String name, MoveInTableAction.MoveInTableType moveInListType, JTable table, List<NavigatorRenderer> dataList) {
            super(name, moveInListType, table, dataList);
        }

        @Override
        protected void doAfter(Object t) {
            RendererOverviewPane.this.changeRendererOrder();
        }
    }
}

