/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JComboBox;
import org.ktde.util.StringUtil;

public class StreetComboBox
extends JComboBox {
    private static final long serialVersionUID = 3502319834635693496L;
    private boolean withEmpty;
    private boolean parcelAttachedElementsOnly;

    public StreetComboBox(boolean withEmpty, boolean parcelAttachedElementsOnly) {
        this.withEmpty = withEmpty;
        this.parcelAttachedElementsOnly = parcelAttachedElementsOnly;
        this.setRenderer(new AbstractStringListCellRenderer(this.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value == null || value instanceof String) {
                    return (String)value;
                }
                StreetModel streetModel = (StreetModel)value;
                return streetModel.getName();
            }
        });
    }

    public void setDistrict(DistrictModel districtModel, PostcodeModel postcodeModel) {
        this.removeAllItems();
        HashSet<PostcodeDistrictRelationModel> postcodeDistrictRelationModels = new HashSet<PostcodeDistrictRelationModel>();
        if (districtModel == null || postcodeModel == null) {
            return;
        }
        if (districtModel != null) {
            for (PostcodeDistrictRelationModel postcodeDistrictRelationModel : districtModel.iterablePostcodes()) {
                if (!postcodeModel.containsDistrict(postcodeDistrictRelationModel)) continue;
                postcodeDistrictRelationModels.add(postcodeDistrictRelationModel);
            }
        }
        if (postcodeModel != null) {
            for (PostcodeDistrictRelationModel postcodeDistrictRelationModel : postcodeModel.iterableDistricts()) {
                if (!districtModel.containsPostcode(postcodeDistrictRelationModel)) continue;
                postcodeDistrictRelationModels.add(postcodeDistrictRelationModel);
            }
        }
        TreeSet<StreetModel> streets = new TreeSet<StreetModel>(new Comparator<StreetModel>(){

            @Override
            public int compare(StreetModel o1, StreetModel o2) {
                String name1 = StringUtil.nullToEmpty(o1.getName());
                String name2 = StringUtil.nullToEmpty(o2.getName());
                return name1.compareTo(name2);
            }
        });
        for (PostcodeDistrictRelationModel pdr : postcodeDistrictRelationModels) {
            for (StreetModel street : pdr.iterableStreets()) {
                if (this.parcelAttachedElementsOnly && street.isParcelsEmpty()) continue;
                streets.add(street);
            }
        }
        this.removeAllItems();
        if (this.withEmpty) {
            this.addItem("");
        }
        for (StreetModel streetModel : streets) {
            this.addItem(streetModel);
        }
    }

    @Override
    public StreetModel getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o == null || o instanceof String) {
            return null;
        }
        return (StreetModel)o;
    }
}

