/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.AbstractAutoCompleteComboBox;
import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.util.international.country.Country;
import java.util.Collection;

public class PostcodeAutoCompleteComboBox
extends AbstractAutoCompleteComboBox<PostcodeModel> {
    private static final long serialVersionUID = -8314203842049717051L;
    private ModelEnviroment modelEnviroment;
    private boolean withEmpty;
    private boolean parcelAttachedElementsOnly;

    public PostcodeAutoCompleteComboBox(ModelEnviroment modelEnviroment, boolean withEmpty, boolean parcelAttachedElementsOnly) {
        this.modelEnviroment = modelEnviroment;
        this.withEmpty = withEmpty;
        this.parcelAttachedElementsOnly = parcelAttachedElementsOnly;
        this.setRenderer(new AbstractStringListCellRenderer(this.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value == null || value instanceof String) {
                    return (String)value;
                }
                PostcodeModel postcode = (PostcodeModel)value;
                return postcode.getName();
            }
        });
    }

    public void setCountry(Country country) {
        Collection<PostcodeModel> postcodes = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchPostcodesForCountry(country, this.parcelAttachedElementsOnly);
        this.removeAllItems();
        if (this.withEmpty) {
            this.addItem("");
        }
        for (PostcodeModel model : postcodes) {
            this.addItem(model);
        }
    }

    @Override
    public PostcodeModel getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return (PostcodeModel)o;
    }

    @Override
    public String toDisplayString(Object data) {
        if (data == null) {
            return "";
        }
        if (data instanceof PostcodeModel) {
            return ((PostcodeModel)data).getName();
        }
        return data.toString();
    }
}

