/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import org.ktde.util.StringUtil;

public class DistrictComboBox
extends JComboBox {
    private static final long serialVersionUID = -8689228192946899816L;
    private boolean withEmpty;
    private boolean parcelAttachedElementsOnly;

    public DistrictComboBox(boolean withEmpty, boolean parcelAttachedElementsOnly) {
        this.withEmpty = withEmpty;
        this.parcelAttachedElementsOnly = parcelAttachedElementsOnly;
        this.setRenderer(new AbstractStringListCellRenderer(this.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value == null || value instanceof String) {
                    return (String)value;
                }
                DistrictModel districtModel = (DistrictModel)value;
                return districtModel.getName();
            }
        });
    }

    public void setCity(CityModel cityModel) {
        this.removeAllItems();
        if (cityModel == null) {
            return;
        }
        if (this.withEmpty) {
            this.addItem("");
        }
        ArrayList<DistrictModel> districts = new ArrayList<DistrictModel>(cityModel.countDistrict());
        for (DistrictModel district : cityModel.iterableDistrict()) {
            if (!this.parcelAttachedElementsOnly || !this.checkParcelAttached(district)) continue;
            districts.add(district);
        }
        Collections.sort(districts, new Comparator<DistrictModel>(){

            @Override
            public int compare(DistrictModel o1, DistrictModel o2) {
                String name1 = StringUtil.nullToEmpty(o1.getName());
                String name2 = StringUtil.nullToEmpty(o2.getName());
                return name1.compareTo(name2);
            }
        });
        for (DistrictModel district : districts) {
            this.addItem(district);
        }
    }

    private boolean checkParcelAttached(DistrictModel district) {
        for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
            for (StreetModel street : pdr.iterableStreets()) {
                if (street.isParcelsEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DistrictModel getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return (DistrictModel)o;
    }
}

