/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.PostcodeComboBox;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class CountryPostcodePane
extends JPanel {
    private static final long serialVersionUID = -5100497986691739789L;
    private CountryComboBox country;
    private PostcodeComboBox postcode;
    private ModelEnviroment modelEnviroment;

    public CountryPostcodePane(ModelEnviroment modelEnviroment) {
        super(new SpringLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        Country defaultCountry = this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry();
        this.country = new CountryComboBox(false, defaultCountry);
        this.add(this.country);
        this.postcode = new PostcodeComboBox(this.modelEnviroment, false, true);
        this.postcode.setCountry(defaultCountry);
        this.add(this.postcode);
        SpringUtilities.makeCompactGrid(this, 1, 2, 2, 2, 2, 2);
        this.country.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Country country = CountryPostcodePane.this.country.getSelectedItem();
                CountryPostcodePane.this.postcode.setCountry(country);
            }
        });
    }

    public PostcodeModel getSelectedPostcode() {
        return this.postcode.getSelectedItem();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.country.setEnabled(enabled);
        this.postcode.setEnabled(enabled);
    }
}

