/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.JComboBox;
import org.ktde.util.StringUtil;

public class CityComboBox
extends JComboBox {
    private static final long serialVersionUID = -8689228192946899816L;
    private boolean withEmpty;
    private boolean parcelAttchedElementsOnly;

    public CityComboBox(boolean withEmpty, boolean parcelAttachedElementsOnly) {
        this.withEmpty = withEmpty;
        this.parcelAttchedElementsOnly = parcelAttachedElementsOnly;
        this.setRenderer(new AbstractStringListCellRenderer(this.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value == null || value instanceof String) {
                    return (String)value;
                }
                CityModel cityModel = (CityModel)value;
                return cityModel.getName();
            }
        });
    }

    public void setPostcode(PostcodeModel postcodeModel) {
        this.removeAllItems();
        if (postcodeModel == null) {
            return;
        }
        HashSet<CityModel> cities = new HashSet<CityModel>();
        for (PostcodeDistrictRelationModel postcodeDistrictRelation : postcodeModel.iterableDistricts()) {
            boolean found = true;
            if (this.parcelAttchedElementsOnly) {
                found = false;
                for (StreetModel street : postcodeDistrictRelation.iterableStreets()) {
                    if (street.isParcelsEmpty()) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            DistrictModel district = postcodeDistrictRelation.getDistrict();
            CityModel city = district.getCity();
            cities.add(city);
        }
        ArrayList cityList = new ArrayList(cities);
        Collections.sort(cityList, new Comparator<CityModel>(){

            @Override
            public int compare(CityModel o1, CityModel o2) {
                String name1 = StringUtil.nullToEmpty(o1.getName());
                String name2 = StringUtil.nullToEmpty(o2.getName());
                return name1.compareTo(name2);
            }
        });
        if (this.withEmpty) {
            this.addItem("");
        }
        for (CityModel city : cityList) {
            this.addItem(city);
        }
    }

    @Override
    public CityModel getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return (CityModel)o;
    }
}

