/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.main;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.util.DefaultLogisticTourUtil;
import de.datomino.util.geo.swing.FreeHandMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.MessageResolverImpl;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.InternalFrame;
import org.ktde.util.StringUtil;
import org.ktde.util.application.ClientApplicationProperties;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ModelEnviroment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelEnviroment.class);
    private static Object geoServerStubContext;
    private static Properties properties;
    private static MessageResolver messageResolver;
    private static UserInformation userInformation;
    private final UndoManager undoManager;
    private final GeoServerStub geoServerStub;
    private final ModelCache modelCache;
    private final AllCaller allCaller;
    private CoordinateFactory coordinateFactory;
    private static List<Object> clipboard;
    private Hashtable<String, Model> modelMap;
    private PrintProperties printProperties;
    public static boolean printPropertiesDirty;
    private static DesktopClientApplication<? extends InternalFrame> desktopClientApplication;

    public ModelEnviroment(Component parent) {
        this(parent, true);
    }

    public ModelEnviroment(Component parent, boolean showUndoRedoActions) {
        this.geoServerStub = new GeoServerStub(ModelEnviroment.getProperties(), geoServerStubContext);
        this.modelCache = new ModelCache(this.geoServerStub);
        this.allCaller = new AllCaller(this.geoServerStub, this.modelCache);
        this.undoManager = new UndoManager(this.modelCache, parent, showUndoRedoActions);
        this.coordinateFactory = CoordinateFactory.getInstance(ModelEnviroment.getProperties().getProperty("navigator.coordinateFactory"));
    }

    public ModelEnviroment(GeoServerStub geoServerStub, Component parent) {
        this.geoServerStub = geoServerStub;
        this.modelCache = new ModelCache(this.geoServerStub);
        this.allCaller = new AllCaller(this.geoServerStub, this.modelCache);
        this.undoManager = new UndoManager(this.modelCache, parent, true);
    }

    public ModelEnviroment(GeoServerStub geoServerStub, ModelCache modelCache, Component parent) {
        this.geoServerStub = geoServerStub;
        this.modelCache = modelCache;
        this.allCaller = new AllCaller(this.geoServerStub, this.modelCache);
        this.undoManager = new UndoManager(this.modelCache, parent, true);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public GeoServerStub getGeoServerStub() {
        return this.geoServerStub;
    }

    public ModelCache getModelCache() {
        return this.modelCache;
    }

    public AllCaller getAllCaller() {
        return this.allCaller;
    }

    public CoordinateFactory getCoordinateFactory() {
        return this.coordinateFactory;
    }

    public static UserInformation getUserInformation() {
        return userInformation;
    }

    public static Properties getProperties() {
        if (properties == null) {
            try {
                Properties parent = new Properties();
                ClassPathResource resource = new ClassPathResource("/clientapplication.properties");
                if (resource.exists()) {
                    InputStreamReader reader = new InputStreamReader(resource.getInputStream(), "UTF-8");
                    parent.load(reader);
                    ((Reader)reader).close();
                }
                Charset defaultCharset = Charset.defaultCharset();
                String encoding = defaultCharset.toString();
                properties = ClientApplicationProperties.loadProperties("peppergis-client", null, encoding, 2, null, parent);
                ModelEnviroment.doPropertySettings();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public static void setProperties(Properties properties) {
        ModelEnviroment.properties = properties;
        ModelEnviroment.doPropertySettings();
    }

    public static void setUserInformation(UserInformation userInformation) {
        ModelEnviroment.userInformation = userInformation;
    }

    public static void setMessageResolver(MessageResolver messageResolver) {
        ModelEnviroment.messageResolver = messageResolver;
    }

    public static void setDesktopClientApplication(DesktopClientApplication<? extends InternalFrame> desktopClientApplication) {
        ModelEnviroment.desktopClientApplication = desktopClientApplication;
    }

    public static DesktopClientApplication<? extends InternalFrame> getDesktopClientApplication() {
        return desktopClientApplication;
    }

    public static MessageResolver getMessageResolver() {
        if (messageResolver == null) {
            MessageResolverImpl messageResolverImpl = new MessageResolverImpl();
            messageResolverImpl.setLocale("de");
            messageResolverImpl.setLocaleFallback("en");
            messageResolverImpl.setResource(new ClassPathResource("/de/datomino/peppergis/i18n/messages/"));
            messageResolverImpl.setPrefixes(Arrays.asList("messages", "gui", "enums"));
            messageResolver = messageResolverImpl;
        }
        return messageResolver;
    }

    public void close() {
        this.getUndoManager().close();
        this.getModelCache().close();
    }

    private static void doPropertySettings() {
        ModelEnviroment.doMarkColorSetting();
    }

    protected static void doMarkColorSetting() {
        Color extractedColor;
        String markColorString = ModelEnviroment.getProperties().getProperty("areas.markColor");
        String markAlphaString = ModelEnviroment.getProperties().getProperty("areas.markAlpha");
        Color markColor = ObjectMarkerNavigatorRenderer.MARK_COLOR;
        if (markColorString != null && (extractedColor = PaintUtil.extractColor(0, markColorString)) != null) {
            markColor = new Color(extractedColor.getRed(), extractedColor.getGreen(), extractedColor.getBlue(), markColor.getAlpha());
        }
        if (markAlphaString != null) {
            Integer alpha = null;
            try {
                alpha = Integer.valueOf(markAlphaString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alpha != null) {
                markColor = new Color(markColor.getRed(), markColor.getGreen(), markColor.getBlue(), PaintUtil.transform100BaseAlpha(alpha));
            }
        }
        FreeHandMarkerNavigatorRenderer.setMarkColor(markColor);
    }

    public static List<Object> getClipboard() {
        if (clipboard == null) {
            clipboard = new LinkedList<Object>();
        }
        return clipboard;
    }

    public void setParent(Component parent) {
        this.getUndoManager().setParent(parent);
    }

    public static void setGeoServerStubContext(Object geoServerStubContext) {
        ModelEnviroment.geoServerStubContext = geoServerStubContext;
    }

    public static CommonServices getCommonServices() {
        return CommonServices.INSTANCE;
    }

    private void initModelMap() {
        this.modelMap = new Hashtable();
        AreaCaller areaCaller = this.getAllCaller().getAreaCaller();
        Collection<AreaAttributeValueDescriptorModel> descriptors = areaCaller.fetchAllAreaAttributeValueDescriptors();
        for (AreaAttributeValueDescriptorModel descriptor : descriptors) {
            String key = StringUtil.getNotNull(descriptor.getKey());
            if (key.equals("AREA-DIFFICULTYLEVEL-MOTOR")) {
                if (this.modelMap.get("AREA-DIFFICULTYLEVEL-MOTOR") == null) {
                    this.modelMap.put("AREA-DIFFICULTYLEVEL-MOTOR", descriptor);
                    continue;
                }
                LOGGER.error("more than one difficulty level motor descriptor");
                continue;
            }
            if (key.equals("AREA-DIFFICULTYLEVEL-FOOT")) {
                if (this.modelMap.get("AREA-DIFFICULTYLEVEL-FOOT") == null) {
                    this.modelMap.put("AREA-DIFFICULTYLEVEL-FOOT", descriptor);
                    continue;
                }
                LOGGER.error("more than one difficulty level foot descriptor");
                continue;
            }
            if (key.equals("AREA-DIFFICULTYLEVEL-BIKE")) {
                if (this.modelMap.get("AREA-DIFFICULTYLEVEL-BIKE") == null) {
                    this.modelMap.put("AREA-DIFFICULTYLEVEL-BIKE", descriptor);
                    continue;
                }
                LOGGER.error("more than one difficulty level bike descriptor");
                continue;
            }
            if (key.equals("AREA-PARCELLOCATION-BIKE")) {
                if (this.modelMap.get("AREA-PARCELLOCATION-BIKE") == null) {
                    this.modelMap.put("AREA-PARCELLOCATION-BIKE", descriptor);
                    continue;
                }
                LOGGER.error("more than one area parcel location descriptor");
                continue;
            }
            if (key.equals("AREA-PARCELLOCATION-MOTOR")) {
                if (this.modelMap.get("AREA-PARCELLOCATION-MOTOR") == null) {
                    this.modelMap.put("AREA-PARCELLOCATION-MOTOR", descriptor);
                    continue;
                }
                LOGGER.error("more than one area parcel location descriptor");
                continue;
            }
            if (key.equals("AREA-PARCELLOCATION-FOOT")) {
                if (this.modelMap.get("AREA-PARCELLOCATION-FOOT") == null) {
                    this.modelMap.put("AREA-PARCELLOCATION-FOOT", descriptor);
                    continue;
                }
                LOGGER.error("more than one area parcel location descriptor");
                continue;
            }
            if (key.equals("AREA-PICKPOINT-START")) {
                if (this.modelMap.get("AREA-PICKPOINT-START") == null) {
                    this.modelMap.put("AREA-PICKPOINT-START", descriptor);
                    continue;
                }
                LOGGER.error("more than one pick point start descriptor");
                continue;
            }
            if (!key.equals("AREA-PICKPOINT-END")) continue;
            if (this.modelMap.get("AREA-PICKPOINT-END") == null) {
                this.modelMap.put("AREA-PICKPOINT-END", descriptor);
                continue;
            }
            LOGGER.error("more than one pick point end descriptor");
        }
        Collection<ParcelAttributeValueDescriptorModel> parcelDescriptors = this.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        for (ParcelAttributeValueDescriptorModel descriptor : parcelDescriptors) {
            String key = StringUtil.getNotNull(descriptor.getKey());
            if (!key.equals("PARCEL-LOCATION")) continue;
            if (this.modelMap.get("PARCEL-LOCATION") == null) {
                this.modelMap.put("PARCEL-LOCATION", descriptor);
                continue;
            }
            LOGGER.error("more than one parcel location descriptor");
        }
    }

    public Model getModelFromMap(String key) {
        if (this.modelMap == null) {
            this.initModelMap();
        }
        return this.modelMap.get(key);
    }

    public void addModelToMap(String key, Model model) {
        this.modelMap.put(key, model);
    }

    public static Coordinate getStartCoordinate() {
        String startString = ModelEnviroment.getProperties().getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    public PrintProperties getPrintProperties() {
        if (printPropertiesDirty || this.printProperties == null) {
            this.printProperties = this.allCaller.getBaseCaller().fetchPrintProperties();
            printPropertiesDirty = false;
        }
        return this.printProperties;
    }

    public void updateSharedValues() {
        Map<String, Object> map = this.allCaller.getCommonCaller().fetchSharedValues();
        map.forEach((k, v) -> {
            switch (k) {
                case "routing.location.tolerance": {
                    DefaultLogisticTourUtil.LOCATION_TOLERANCE = (Double)v;
                    break;
                }
            }
        });
    }

    static {
        printPropertiesDirty = true;
    }

    public static class CommonServices {
        private static CommonServices INSTANCE = new CommonServices();
    }
}

