/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.AbstractGeomEditorMapPane;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.ktde.math.projection.Coordinate;

public class GeomEditorMapPane
extends AbstractGeomEditorMapPane<AbstractLocationEditorPane> {
    private static final long serialVersionUID = -4901731618303097033L;
    private SegmentModel origMotorSegment;
    private SegmentModel origFootSegment;
    private SegmentModel origBikeSegment;
    protected Integer lastExitValue = -1;
    private String streetName;

    public GeomEditorMapPane(AbstractLocationEditorPane parent, boolean routeSegmentEditable) {
        this(parent, routeSegmentEditable, true);
    }

    public GeomEditorMapPane(AbstractLocationEditorPane parent, boolean routeSegmentEditable, boolean withSearchRendering) {
        super(new BorderLayout());
        this.parent = parent;
        this.routeSegmentEditable = routeSegmentEditable;
        this.geoClientHelper = new GeoClientHelper(parent.getModelEnviroment());
        this.initializedMapPanel();
        this.add((Component)this.navigatorPanel, "Center");
        this.add((Component)this.creatControlPanel(withSearchRendering), "North");
    }

    public JDialog showDialog(String titel, Component component) {
        final JDialog dialog = new JDialog(SwingUtils.findWindowParent(component));
        try {
            dialog.setIconImage(ImageIO.read(GeomEditorMapPane.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setTitle(titel);
        dialog.setPreferredSize(new Dimension(component.getWidth(), component.getHeight()));
        dialog.setLocation(component.getLocationOnScreen().x, component.getLocationOnScreen().y);
        dialog.setResizable(false);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getNavigatorPanel().center(this.getCoordinateEditorLayerRenderer().getCoordinate());
        if (this.getWidth() == 0) {
            this.navigatorPanel.translate(((AbstractLocationEditorPane)this.parent).getWidth() / 2, ((AbstractLocationEditorPane)this.parent).getHeight() / 2);
        }
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (GeomEditorMapPane.this.coordinate == null) {
                    this.close();
                }
                Coordinate selectedCoordinate = GeomEditorMapPane.this.coordinate.getFactory().createCoordinate(GeomEditorMapPane.this.coordinateEditorLayerRenderer.getCoordinate());
                boolean saved = GeomEditorMapPane.this.selectedMotorSegment == null || GeomEditorMapPane.this.selectedMotorSegment.equals(GeomEditorMapPane.this.motorSegment);
                saved &= GeomEditorMapPane.this.selectedFootSegment == null || GeomEditorMapPane.this.selectedFootSegment.equals(GeomEditorMapPane.this.footSegment);
                saved &= GeomEditorMapPane.this.selectedBikeSegment == null || GeomEditorMapPane.this.selectedBikeSegment.equals(GeomEditorMapPane.this.bikeSegment);
                if (saved &= selectedCoordinate == null || selectedCoordinate.equals(GeomEditorMapPane.this.coordinate)) {
                    GeomEditorMapPane.this.lastExitValue = 0;
                    this.close();
                } else {
                    int d = JOptionPane.showConfirmDialog(GeomEditorMapPane.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.save", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 1, 3);
                    switch (d) {
                        case 0: {
                            GeomEditorMapPane.this.coordinate = selectedCoordinate;
                            if (GeomEditorMapPane.this.motorSegment != GeomEditorMapPane.this.origMotorSegment) {
                                GeomEditorMapPane.this.motorSegmentUpdate = true;
                            }
                            if (GeomEditorMapPane.this.footSegment != GeomEditorMapPane.this.origFootSegment) {
                                GeomEditorMapPane.this.footSegmentUpdate = true;
                            }
                            if (GeomEditorMapPane.this.bikeSegment != GeomEditorMapPane.this.origBikeSegment) {
                                GeomEditorMapPane.this.bikeSegmentUpdate = true;
                            }
                            GeomEditorMapPane.this.motorSegment = GeomEditorMapPane.this.selectedMotorSegment;
                            GeomEditorMapPane.this.footSegment = GeomEditorMapPane.this.selectedFootSegment;
                            GeomEditorMapPane.this.bikeSegment = GeomEditorMapPane.this.selectedBikeSegment;
                            GeomEditorMapPane.this.lastExitValue = 0;
                            this.close();
                            break;
                        }
                        case 1: {
                            GeomEditorMapPane.this.motorSegment = GeomEditorMapPane.this.origMotorSegment;
                            GeomEditorMapPane.this.footSegment = GeomEditorMapPane.this.origFootSegment;
                            GeomEditorMapPane.this.bikeSegment = GeomEditorMapPane.this.origBikeSegment;
                            GeomEditorMapPane.this.motorSegmentUpdate = false;
                            GeomEditorMapPane.this.footSegmentUpdate = false;
                            GeomEditorMapPane.this.bikeSegmentUpdate = false;
                            GeomEditorMapPane.this.lastExitValue = 1;
                            this.close();
                            break;
                        }
                        default: {
                            GeomEditorMapPane.this.lastExitValue = 2;
                        }
                    }
                }
            }

            private void close() {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add(this);
        dialog.pack();
        dialog.setVisible(true);
        return dialog;
    }

    @Override
    public void setSegments(SegmentModel motorSegment, SegmentModel footSegment, SegmentModel bikeSegment, boolean init) {
        if (init) {
            this.origMotorSegment = motorSegment;
            this.origFootSegment = footSegment;
            this.origBikeSegment = bikeSegment;
        }
        super.setSegments(motorSegment, footSegment, bikeSegment, init);
    }

    @Override
    protected ModelEnviroment getModelEnvironment() {
        return ((AbstractLocationEditorPane)this.parent).getModelEnviroment();
    }

    @Override
    protected void updateParent() {
        if (this.parent != null) {
            ((AbstractLocationEditorPane)this.parent).update();
        }
    }

    public Integer getLastExitValue() {
        return this.lastExitValue;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }
}

