/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.peppergis.client.gui.location.AbstractGeomEditorMapPane;
import de.datomino.peppergis.client.gui.renderer.CoordinateEditorLayerRenderer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;

public class GeomEditorMapMouseManipulator
implements MouseManipulator {
    private AbstractGeomEditorMapPane coordinateMapPanel;
    private boolean dragged;

    public GeomEditorMapMouseManipulator(AbstractGeomEditorMapPane coordinateMapPanel) {
        this.coordinateMapPanel = coordinateMapPanel;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragged) {
            return;
        }
        NavigatorPanel navigatorPanel = this.coordinateMapPanel.getNavigatorPanel();
        Point2D.Double real = navigatorPanel.getReal(e.getX(), e.getY());
        CoordinateFactory coordinateFactory = navigatorPanel.getCoordinateFactory();
        this.coordinateMapPanel.setCoordinate(coordinateFactory.createCoordinate(real.x, real.y), false);
        this.coordinateMapPanel.setSegments(null, null, null, false);
        this.coordinateMapPanel.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        CoordinateEditorLayerRenderer renderer = this.coordinateMapPanel.getCoordinateEditorLayerRenderer();
        Point2D.Double real = this.coordinateMapPanel.getNavigatorPanel().getReal(e.getX(), e.getY());
        Coordinate coordinate = renderer.getSelectedCoordinate(real);
        if (renderer.isActive() && coordinate != null) {
            this.coordinateMapPanel.getNavigatorPanel().setCursor(Cursor.getPredefinedCursor(13));
            this.dragged = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.coordinateMapPanel.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        this.dragged = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (NavigatorPanningAction.performWheelZoom(e, this.coordinateMapPanel.getNavigatorPanel())) {
            this.coordinateMapPanel.getNavigatorPanel().forceCalcTransform();
        }
    }
}

