/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.location.GeomEditorMapPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.map.SegmentModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLocationEditorPane
extends JPanel {
    private static final long serialVersionUID = -7443821484471108233L;
    public static double DEFAULTMAXUPP = 4.0;
    private ModelEnviroment modelEnviroment;
    private Properties properties;
    private NavigatorPanel navigatorPanel;
    private JList legendList;
    private double maxUpp;
    private boolean withAllModels;
    private GeomEditorMapPane geomEditorMapPane;

    public AbstractLocationEditorPane(ModelEnviroment modelEnviroment, Properties properties) {
        this(modelEnviroment, properties, DEFAULTMAXUPP);
    }

    public AbstractLocationEditorPane(ModelEnviroment modelEnviroment, Properties properties, double maxUpp) {
        this.modelEnviroment = modelEnviroment;
        this.properties = properties;
        this.maxUpp = maxUpp;
        this.withAllModels = false;
        JComponent mapPanel = this.createMapPanel();
        JSplitPane splitPane = new JSplitPane(1, this.createLeftPanel(), mapPanel);
        splitPane.setOneTouchExpandable(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        JPanel undoManagerPane = new JPanel(new FlowLayout());
        undoManagerPane.add(new JButton(undoManager.getUndoAction()));
        undoManagerPane.add(new JButton(undoManager.getRedoAction()));
        undoManagerPane.add(new JButton(undoManager.getSaveAction()));
        if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("locationeditor.segment"))) {
            undoManagerPane.add(new JButton(new AbstractAction("Segment"){
                private static final long serialVersionUID = -7834973898984432258L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractLocationEditorPane.this.showCoordinateEditorMapPane("", null, null, null, null, true);
                }
            }));
        }
        JSplitPane mainSplitPane = new JSplitPane(0, this.createTopPanel(undoManagerPane), splitPane);
        mainSplitPane.setOneTouchExpandable(true);
        Double resizeWeight = this.getResizeWeight();
        if (resizeWeight != null) {
            mainSplitPane.setResizeWeight(resizeWeight);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)mainSplitPane, "Center");
        if (this.legendList != null) {
            this.legendList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && !e.isConsumed()) {
                        e.consume();
                        Object selObject = this.getSelObjectInList();
                        if (selObject != null) {
                            AbstractLocationEditorPane.this.showLegendDialog(selObject);
                        }
                    }
                }

                public Object getSelObjectInList() {
                    int selIndex = AbstractLocationEditorPane.this.legendList.getSelectedIndex();
                    if (selIndex < 0) {
                        return null;
                    }
                    return AbstractLocationEditorPane.this.legendList.getModel().getElementAt(selIndex);
                }
            });
        }
        this.update();
    }

    protected Double getResizeWeight() {
        return null;
    }

    protected abstract JComponent createTopPanel(JPanel var1);

    protected abstract JComponent createLeftPanel();

    protected abstract AbstractLayerRenderer getLayerRenderer();

    public abstract void update();

    protected abstract void showLegendDialog(Object var1);

    public JDialog showCoordinateEditorMapPane(String title, Coordinate startCoordinate, SegmentModel motorSegment, SegmentModel footSegment, SegmentModel bikeSegment, boolean routeStreetEditable) {
        if (this.geomEditorMapPane == null) {
            this.geomEditorMapPane = new GeomEditorMapPane(this, routeStreetEditable);
        }
        this.geomEditorMapPane.setCoordinate(startCoordinate, true);
        this.geomEditorMapPane.setSegments(motorSegment, footSegment, bikeSegment, true);
        return this.geomEditorMapPane.showDialog(title, this);
    }

    protected JComponent createMapPanel() {
        this.navigatorPanel = new NavigatorPanel(this.getStartCoordinate(), OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setPanning(true);
        this.navigatorPanel.getPanningAction().setSelected(true);
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        this.addRenderers(this.modelEnviroment);
        DefaultMouseManipulator mouseManipulator = new DefaultMouseManipulator(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AbstractLocationEditorPane.this.getNavigatorPanel().getUpp() <= AbstractLocationEditorPane.this.maxUpp && AbstractLocationEditorPane.this.isWithAllModels()) {
                    DefaultListModel model = (DefaultListModel)AbstractLocationEditorPane.this.legendList.getModel();
                    model.clear();
                    AbstractLocationEditorPane.this.update();
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (NavigatorPanningAction.performWheelZoom(e, AbstractLocationEditorPane.this.getNavigatorPanel())) {
                    AbstractLocationEditorPane.this.getNavigatorPanel().forceCalcTransform();
                    if (AbstractLocationEditorPane.this.getNavigatorPanel().getUpp() <= AbstractLocationEditorPane.this.maxUpp) {
                        DefaultListModel model = (DefaultListModel)AbstractLocationEditorPane.this.legendList.getModel();
                        model.clear();
                        AbstractLocationEditorPane.this.update();
                    }
                }
            }
        };
        this.navigatorPanel.setMouseManipulator(mouseManipulator);
        this.navigatorPanel.addMouseListener(mouseManipulator);
        return this.navigatorPanel;
    }

    private void addRenderers(ModelEnviroment modelEnviroment) {
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        this.addRenderer(osmNavigatorRenderer);
        AbstractLayerRenderer layerRenderer = this.getLayerRenderer();
        if (layerRenderer != null) {
            this.addRenderer(layerRenderer);
            this.navigatorPanel.addMouseListener(layerRenderer);
        }
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        this.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        this.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
    }

    protected void addRenderer(NavigatorRenderer navigatorRenderer) {
        navigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(navigatorRenderer);
    }

    private Coordinate getStartCoordinate() {
        String startString = this.properties.getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = Wgs84Factory.INSTANCE.createCoordinate(11.576843, 48.136308);
        }
        return startCoordinate;
    }

    public JList getLegendList() {
        return this.legendList;
    }

    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public GeomEditorMapPane getCoordinateEditorMapPane() {
        return this.geomEditorMapPane;
    }

    public boolean isWithAllModels() {
        return this.withAllModels;
    }

    public void setWithAllModels(boolean withAllModels) {
        this.withAllModels = withAllModels;
    }

    protected void setLegendList(JList legendList) {
        this.legendList = legendList;
    }
}

