/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class AbstractControlPanel
extends JPanel {
    private static final long serialVersionUID = -5884632411138237690L;
    private JSpinner xSpinner;
    private JSpinner ySpinner;
    private SearchLocationAction searchLocationAction;
    private JComboBox<String> coordinateFormat;

    public AbstractControlPanel(NavigatorPanel navigatorPanel, ModelEnviroment modelEnvironment, AbstractToggleAction showMotorSegmentAction, AbstractToggleAction showBikeSegmentAction, AbstractToggleAction showFootSegmentAction, boolean withSearchRendering, boolean routeSegmentEditable) {
        this(navigatorPanel, modelEnvironment, showMotorSegmentAction, showBikeSegmentAction, showFootSegmentAction, withSearchRendering, routeSegmentEditable, true, true);
    }

    public AbstractControlPanel(NavigatorPanel navigatorPanel, ModelEnviroment modelEnvironment, AbstractToggleAction showMotorSegmentAction, AbstractToggleAction showBikeSegmentAction, AbstractToggleAction showFootSegmentAction, boolean withSearchRendering, boolean routeSegmentEditable, boolean segmentVisibilityMutuallyExclusive, boolean withCoordinates) {
        super(new FlowLayout());
        if (withCoordinates) {
            JLabel locationXLabel = new JLabel("X ");
            this.add(locationXLabel);
            this.xSpinner = new JSpinner(new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.001));
            JSpinner.NumberEditor editorX = new JSpinner.NumberEditor(this.xSpinner, "###,###,##0.######");
            this.xSpinner.setEditor(editorX);
            this.xSpinner.setPreferredSize(new Dimension(100, 25));
            this.add(this.xSpinner);
            JLabel locationYLabel = new JLabel("Y ");
            this.add(locationYLabel);
            this.ySpinner = new JSpinner(new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.001));
            JSpinner.NumberEditor editorY = new JSpinner.NumberEditor(this.ySpinner, "###,###,##0.######");
            this.ySpinner.setEditor(editorY);
            this.ySpinner.setPreferredSize(new Dimension(100, 25));
            this.add(this.ySpinner);
            String wgs84 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate_factory.Wgs84.name", new Serializable[0]);
            String mercator = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate_factory.Mercator.name", new Serializable[0]);
            this.coordinateFormat = new JComboBox<String>(new String[]{wgs84, mercator});
            this.coordinateFormat.setSelectedItem(wgs84);
            this.add(this.coordinateFormat);
        }
        this.searchLocationAction = new SearchLocationAction(this, navigatorPanel, modelEnvironment, withSearchRendering, true){
            private static final long serialVersionUID = -7167342319551497603L;

            @Override
            protected void doAfterFindingCoordinate(ImmutablePoint point) {
                super.doAfterFindingCoordinate(point);
                AbstractControlPanel.this.doAfterCoordinateFound(point);
                AbstractControlPanel.this.doAfterCoordinateFound(this.getCoordinate());
            }
        };
        this.add(new JButton(this.searchLocationAction));
        if (withCoordinates) {
            JButton updateButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.update", new Serializable[0])){
                private static final long serialVersionUID = 5063782018133441114L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractControlPanel.this.update();
                }
            });
            this.add(updateButton);
        }
        JToggleButton showMotorSegmentButton = new JToggleButton(showMotorSegmentAction);
        showMotorSegmentButton.setForeground(PeppergisConstants.MOTOR_SEGMENT_COLOR);
        JToggleButton showFootSegmentButton = new JToggleButton(showFootSegmentAction);
        showFootSegmentButton.setForeground(PeppergisConstants.FOOT_SEGMENT_COLOR);
        JToggleButton showBikeSegmentButton = new JToggleButton(showBikeSegmentAction);
        showBikeSegmentButton.setForeground(PeppergisConstants.BIKE_SEGMENT_COLOR);
        if (routeSegmentEditable) {
            this.add(showMotorSegmentButton);
            this.add(showFootSegmentButton);
            this.add(showBikeSegmentButton);
            if (segmentVisibilityMutuallyExclusive) {
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(showMotorSegmentButton);
                buttonGroup.add(showFootSegmentButton);
                buttonGroup.add(showBikeSegmentButton);
            }
        }
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    protected abstract void doAfterCoordinateFound(ImmutablePoint var1);

    protected abstract void doAfterCoordinateFound(Coordinate var1);

    public abstract void update();

    public JSpinner getxSpinner() {
        return this.xSpinner;
    }

    public JSpinner getySpinner() {
        return this.ySpinner;
    }

    public SearchLocationAction getSearchLocationAction() {
        return this.searchLocationAction;
    }

    public JComboBox<String> getCoordinateFormat() {
        return this.coordinateFormat;
    }
}

