/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.letter;

import de.datomino.peppergis.client.data.DataManagerAccess;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.letter.BasicLetterPane;
import de.datomino.peppergis.client.gui.letter.LetterAttributeValuePane;
import de.datomino.peppergis.client.gui.location.ImportedLocationAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicArrowButton;

public class LetterDialog
extends CommonDialog
implements Pausable {
    private static final long serialVersionUID = 7701393906002917081L;
    private List<LetterModel> letters;
    private int currentIndex = 0;
    private ModelEnviroment modelEnviroment;
    private BasicLetterPane basicLetterPane;
    private List<LetterAttributeValuePane> letterAttributeValuePanes;
    private ParcelAddressPane parcelAddressPane;
    private ImportedLocationAddressPane importedLocationAddressPane;
    private PausableInternalFrame internalFrame;

    public LetterDialog(Window parent, List<LetterModel> letters, ModelEnviroment modelEnviroment) {
        super((Component)parent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.letters = letters;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        if (this.letters.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            if (this.importedLocationAddressPane != null) {
                this.importedLocationAddressPane.centerCoord();
            }
            if (this.parcelAddressPane != null) {
                this.parcelAddressPane.centerCoord();
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setTitle(this.letters.get(this.currentIndex).getLetterNumber());
        this.pack();
        this.setDefaultCloseOperation(2);
        SwingUtils.centerDialog(this, this.getParent());
        if (visible) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(visible);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4578396289778907053L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LetterDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel addressComponent;
        JTabbedPane tabbedPane = new JTabbedPane();
        LetterModel letter = this.letters.get(this.currentIndex);
        boolean modifiable = LetterModelUtil.isLetterModifiable(letter);
        this.basicLetterPane = new BasicLetterPane(letter, this.modelEnviroment);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.common", new Serializable[0]), this.basicLetterPane);
        LocationModel location = letter.getLocation();
        ParcelModel parcel = location.getParcel();
        if (parcel == null) {
            this.importedLocationAddressPane = new ImportedLocationAddressPane(location.getImportedLocation(), this.modelEnviroment, false, true);
            addressComponent = this.importedLocationAddressPane;
        } else {
            addressComponent = this.parcelAddressPane = new ParcelAddressPane(parcel, this.modelEnviroment, false, false);
        }
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.address", new Serializable[0]), addressComponent);
        Collection<AttributeGroupModel> groups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(AttributeGroupType.LETTER);
        this.letterAttributeValuePanes = new ArrayList<LetterAttributeValuePane>(groups.size());
        for (AttributeGroupModel group : groups) {
            LetterAttributeValuePane letterAttributeValuePane = new LetterAttributeValuePane(letter, Collections.singleton(group), this.modelEnviroment);
            letterAttributeValuePane.fillValues(letter);
            this.letterAttributeValuePanes.add(letterAttributeValuePane);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)letterAttributeValuePane, "North");
            tabbedPane.add(group.getName(), new JScrollPane(panel));
        }
        this.setEnabled(modifiable);
        return tabbedPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -6675080622780941906L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LetterDialog.this.basicLetterPane.adaptValuesToModel();
                for (LetterAttributeValuePane letterAttributeValuePane : LetterDialog.this.letterAttributeValuePanes) {
                    letterAttributeValuePane.adaptValuesToModel((Model)LetterDialog.this.letters.get(LetterDialog.this.currentIndex));
                }
                if (LetterDialog.this.importedLocationAddressPane != null) {
                    LetterDialog.this.importedLocationAddressPane.adaptValuesToModel();
                }
                if (LetterDialog.this.parcelAddressPane != null) {
                    try {
                        LetterDialog.this.parcelAddressPane.adaptValuesToModel(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LetterDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.attributesChanged", new Serializable[]{((LetterModel)LetterDialog.this.letters.get(LetterDialog.this.currentIndex)).getLetterNumber()}));
                LetterDialog.this.dispose();
            }
        };
    }

    private JPanel createControlPanel() {
        this.setTitle(this.letters.get(this.currentIndex).getLetterNumber());
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LetterDialog.this.nextLetter(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.letters.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LetterDialog.this.nextLetter(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void nextLetter(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.letters.size() - 1;
        } else if (this.currentIndex > this.letters.size() - 1) {
            this.currentIndex = 0;
        }
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }

    public void setLocallyEnabled(boolean b) {
        this.basicLetterPane.setEnabled(b);
        for (LetterAttributeValuePane letterAttributeValuePane : this.letterAttributeValuePanes) {
            letterAttributeValuePane.setEnabled(b);
        }
        if (this.parcelAddressPane != null) {
            this.parcelAddressPane.setEnabled(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.importedLocationAddressPane != null) {
            super.setEnabled(b);
        }
        this.setLocallyEnabled(b);
    }

    private LetterModel getCurrentLetter() {
        return this.letters.get(this.currentIndex);
    }

    @Override
    protected Action[] getAdditionalActions() {
        Action[] actions2;
        Action[] superActions = super.getAdditionalActions();
        if (this.isExternalEditEnabled() && DataManagerAccess.isModelAllowedToEdit()) {
            actions2 = new Action[superActions.length + 1];
            System.arraycopy(superActions, 0, actions2, 0, superActions.length);
            actions2[actions2.length - 1] = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0])){
                private static final long serialVersionUID = 2396047713329596870L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LetterDialog.this.internalFrame != null) {
                        LetterDialog.this.internalFrame.pause(LetterDialog.this);
                    }
                    DataManagerAccess.showModel(ModelEnviroment.getDesktopClientApplication(), LetterDialog.this.getCurrentLetter());
                    if (LetterDialog.this.internalFrame != null) {
                        LetterDialog.this.internalFrame.unlockResume();
                    }
                }
            };
        } else {
            actions2 = superActions;
        }
        return actions2;
    }

    public void setInternalFrame(PausableInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    protected boolean isExternalEditEnabled() {
        return true;
    }

    @Override
    public void pause() {
        this.setVisible(false);
    }

    @Override
    public void resume() {
        this.setVisible(true);
    }
}

