/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.image;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.image.ImageListChooserPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.Action;

public class ImageChooserDialog
extends CommonDialog {
    private static final long serialVersionUID = -6567115468668910583L;
    private ModelEnviroment modelEnviroment;
    private ImageListChooserPane imageChooserPane;
    private CallBack callBack;
    private boolean editable;

    public ImageChooserDialog(Window parent, ModelEnviroment modelEnviroment, boolean editable) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.images", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.buildLayout();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = -802907189365257162L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageChooserDialog.this.callBack != null) {
                    ImageChooserDialog.this.callBack.executeAfterCancel();
                }
                super.actionPerformed(e);
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.imageChooserPane = new ImageListChooserPane(this.modelEnviroment, this.editable);
        return this.imageChooserPane;
    }

    @Override
    protected Action getOkAction() {
        return new DialogDisposeAction(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 7920085483611142036L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageChooserDialog.this.callBack != null) {
                    ImageChooserDialog.this.callBack.executeAfterOk();
                }
                super.actionPerformed(e);
            }
        };
    }

    public Long getSelectedImageModelId() {
        return this.imageChooserPane.getSelectedImageModelId();
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    public ImageModel getSelectedImage() {
        return this.imageChooserPane.getSelectedImage();
    }

    public static interface CallBack {
        public void executeAfterOk();

        public void executeAfterCancel();
    }
}

