/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.subscription;

import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelectionDialog;
import de.datomino.peppergis.client.gui.attribute.filter.AbstractAttributeFilterPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.filter.AbstractFilterPane;
import de.datomino.peppergis.client.gui.filter.subscription.SubscriptionAttributeFilterPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterAreaRelationModelImpl;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SubscriptionFilterPane
extends AbstractFilterPane<SubscriptionFilterModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = 7753054945437663853L;
    private EnumComboBox<SubscriptionStatus> subscriptionStatusComboBox;
    private JTextField subscriptionNumber;
    private JCheckBox subscriptionFilterAreaRelationEnabled;
    private Collection<SubscriptionFilterAreaRelationModel> subscriptionFilterAreaRelationModels = Collections.emptySet();
    private AreaSelectionAction areaSelectionAction;
    private JCheckBox considerWeekday;
    private JCheckBox monday;
    private JCheckBox tuesday;
    private JCheckBox wednesday;
    private JCheckBox thursday;
    private JCheckBox friday;
    private JCheckBox saturday;
    private JCheckBox sunday;
    private EnumComboBox<SubscriptionDeliveryType> subscriptionDeliveryType;
    private JFormattedTextField startDate;
    private JFormattedTextField endDate;

    public SubscriptionFilterPane(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void adaptSpecialValuesToModel(ModelObjectFilter<SubscriptionFilterModel> modelObjectFilter) {
        SubscriptionFilterModel subscriptionFilterModel = (SubscriptionFilterModel)modelObjectFilter.getAttachedObject();
        SubscriptionStatus subscriptionStatus = this.subscriptionStatusComboBox.getSelectedValue();
        subscriptionFilterModel.setSubscriptionStatus(subscriptionStatus);
        subscriptionFilterModel.setSubscriptionNumber(this.subscriptionNumber.getText());
        subscriptionFilterModel.setSubscriptionFilterAreaEnabled(this.subscriptionFilterAreaRelationEnabled.isSelected());
        for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : this.subscriptionFilterAreaRelationModels) {
            subscriptionFilterAreaRelationModel.setSubscriptionFilter(subscriptionFilterModel);
        }
        for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : subscriptionFilterModel.iterableSubscriptionFilterAreaRelation()) {
            if (this.subscriptionFilterAreaRelationModels.contains(subscriptionFilterAreaRelationModel)) continue;
            subscriptionFilterAreaRelationModel.delete();
        }
        subscriptionFilterModel.clearSubscriptionFilterAreaRelation();
        for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : this.subscriptionFilterAreaRelationModels) {
            subscriptionFilterModel.addASubscriptionFilterAreaRelation(subscriptionFilterAreaRelationModel);
        }
        boolean weekday = this.considerWeekday.isSelected();
        subscriptionFilterModel.setMonday(weekday ? Boolean.valueOf(this.monday.isSelected()) : null);
        subscriptionFilterModel.setTuesday(weekday ? Boolean.valueOf(this.tuesday.isSelected()) : null);
        subscriptionFilterModel.setWednesday(weekday ? Boolean.valueOf(this.wednesday.isSelected()) : null);
        subscriptionFilterModel.setThursday(weekday ? Boolean.valueOf(this.thursday.isSelected()) : null);
        subscriptionFilterModel.setFriday(weekday ? Boolean.valueOf(this.friday.isSelected()) : null);
        subscriptionFilterModel.setSaturday(weekday ? Boolean.valueOf(this.saturday.isSelected()) : null);
        subscriptionFilterModel.setSunday(weekday ? Boolean.valueOf(this.sunday.isSelected()) : null);
        SubscriptionDeliveryType selectedValue = this.subscriptionDeliveryType.getSelectedValue();
        subscriptionFilterModel.setDeliveryType(selectedValue);
        subscriptionFilterModel.setStartDate((Date)this.startDate.getValue());
        subscriptionFilterModel.setEndDate((Date)this.endDate.getValue());
    }

    @Override
    protected AbstractAttributeFilterPane<SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> createAttributeFilterPane() {
        SubscriptionAttributeFilterPane subscriptionAttributeFilterPane = new SubscriptionAttributeFilterPane(this.getParentWindow(), this.getModelEnviroment().getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors());
        return subscriptionAttributeFilterPane;
    }

    @Override
    protected Component getSpecialParameterComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0])));
        this.subscriptionNumber = new JTextField(30);
        panel.add(this.subscriptionNumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.status", new Serializable[0])));
        Enum[] subscriptionStatus = new SubscriptionStatus[SubscriptionStatus.values().length - 1];
        int i = 0;
        for (SubscriptionStatus status : SubscriptionStatus.values()) {
            if (status == SubscriptionStatus.ALL) continue;
            subscriptionStatus[i++] = status;
        }
        this.subscriptionStatusComboBox = new EnumComboBox(SubscriptionStatus.class, true, subscriptionStatus);
        panel.add(this.subscriptionStatusComboBox);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0])));
        JPanel bPanel = new JPanel(new BorderLayout());
        JPanel sPanel = new JPanel(new SpringLayout());
        this.subscriptionFilterAreaRelationEnabled = new JCheckBox();
        this.subscriptionFilterAreaRelationEnabled.addActionListener(new SubscriptionFilterAreaRelationActionListener());
        sPanel.add(this.subscriptionFilterAreaRelationEnabled);
        this.areaSelectionAction = new AreaSelectionAction();
        JButton button = new JButton(this.areaSelectionAction);
        sPanel.add(button);
        SpringUtilities.makeCompactGrid(sPanel, 1, 2, 2, 2, 2, 2);
        bPanel.add((Component)sPanel, "West");
        panel.add(bPanel);
        JPanel wPanel = new JPanel(new SpringLayout());
        this.considerWeekday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.consider.weekday", new Serializable[0]));
        this.considerWeekday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = SubscriptionFilterPane.this.considerWeekday.isSelected();
                SubscriptionFilterPane.this.monday.setEnabled(b);
                SubscriptionFilterPane.this.tuesday.setEnabled(b);
                SubscriptionFilterPane.this.wednesday.setEnabled(b);
                SubscriptionFilterPane.this.thursday.setEnabled(b);
                SubscriptionFilterPane.this.friday.setEnabled(b);
                SubscriptionFilterPane.this.saturday.setEnabled(b);
                SubscriptionFilterPane.this.sunday.setEnabled(b);
            }
        });
        wPanel.add(this.considerWeekday);
        sPanel = new JPanel(new BorderLayout());
        JPanel wePanel = new JPanel(new FlowLayout());
        this.monday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday.short", new Serializable[0]));
        wePanel.add(this.monday);
        this.tuesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday.short", new Serializable[0]));
        wePanel.add(this.tuesday);
        this.wednesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday.short", new Serializable[0]));
        wePanel.add(this.wednesday);
        this.thursday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday.short", new Serializable[0]));
        wePanel.add(this.thursday);
        this.friday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday.short", new Serializable[0]));
        wePanel.add(this.friday);
        this.saturday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday.short", new Serializable[0]));
        wePanel.add(this.saturday);
        this.sunday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday.short", new Serializable[0]));
        wePanel.add(this.sunday);
        sPanel.add((Component)wePanel, "West");
        wPanel.add(sPanel);
        SpringUtilities.makeCompactGrid(wPanel, 2, 1, 2, 2, 2, 2);
        panel.add(new JLabel());
        panel.add(wPanel);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SubscriptionDeliveryType.class.getName(), new Serializable[0])));
        this.subscriptionDeliveryType = new EnumComboBox<SubscriptionDeliveryType>(SubscriptionDeliveryType.class, true);
        panel.add(this.subscriptionDeliveryType);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.validationTime", new Serializable[0])));
        sPanel = new JPanel(new GridLayout(1, 2));
        this.startDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        this.startDate.setColumns(30);
        sPanel.add(this.startDate);
        this.endDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        this.endDate.setColumns(30);
        sPanel.add(this.endDate);
        panel.add(sPanel);
        SpringUtilities.makeCompactGrid(panel, 6, 2, 5, 2, 2, 2);
        return panel;
    }

    @Override
    protected void setSpecialEnabled(boolean enabled) {
        this.subscriptionStatusComboBox.setEnabled(enabled);
        this.subscriptionNumber.setEditable(enabled);
        this.subscriptionFilterAreaRelationEnabled.setEnabled(enabled);
        this.areaSelectionAction.setEnabled(enabled && this.subscriptionFilterAreaRelationEnabled.isSelected());
        this.considerWeekday.setEnabled(enabled);
        boolean weekdayEnabled = this.considerWeekday.isSelected();
        this.monday.setEnabled(enabled && weekdayEnabled);
        this.tuesday.setEnabled(enabled && weekdayEnabled);
        this.wednesday.setEnabled(enabled && weekdayEnabled);
        this.thursday.setEnabled(enabled && weekdayEnabled);
        this.friday.setEnabled(enabled && weekdayEnabled);
        this.saturday.setEnabled(enabled && weekdayEnabled);
        this.sunday.setEnabled(enabled && weekdayEnabled);
        this.subscriptionDeliveryType.setEnabled(enabled);
        this.startDate.setEditable(enabled);
        this.endDate.setEditable(enabled);
    }

    @Override
    protected void setSpecialFilterValues(ModelObjectFilter<SubscriptionFilterModel> modelObjectFilter) {
        if (modelObjectFilter == null) {
            this.subscriptionStatusComboBox.setSelectedIndex(0);
            this.subscriptionNumber.setText("");
            this.subscriptionFilterAreaRelationEnabled.setSelected(false);
            this.subscriptionFilterAreaRelationModels = Collections.emptyList();
            this.considerWeekday.setSelected(false);
            this.monday.setSelected(false);
            this.tuesday.setSelected(false);
            this.wednesday.setSelected(false);
            this.thursday.setSelected(false);
            this.friday.setSelected(false);
            this.saturday.setSelected(false);
            this.sunday.setSelected(false);
            this.subscriptionDeliveryType.setSelectedIndex(0);
            this.startDate.setValue(null);
            this.endDate.setValue(null);
        } else {
            SubscriptionFilterModel subscriptionFilterModel = (SubscriptionFilterModel)modelObjectFilter.getAttachedObject();
            SubscriptionStatus subscriptionStatus = subscriptionFilterModel.getSubscriptionStatus();
            this.subscriptionStatusComboBox.setSelectedValue(subscriptionStatus);
            String subscriptionNumber = subscriptionFilterModel.getSubscriptionNumber();
            this.subscriptionNumber.setText(subscriptionNumber == null ? "" : subscriptionNumber);
            Boolean subscriptionFilterAreaEnabled = subscriptionFilterModel.getSubscriptionFilterAreaEnabled();
            this.subscriptionFilterAreaRelationEnabled.setSelected(subscriptionFilterAreaEnabled != null && subscriptionFilterAreaEnabled != false);
            this.subscriptionFilterAreaRelationModels = new ArrayList<SubscriptionFilterAreaRelationModel>(subscriptionFilterModel.countSubscriptionFilterAreaRelation());
            for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : subscriptionFilterModel.iterableSubscriptionFilterAreaRelation()) {
                this.subscriptionFilterAreaRelationModels.add(subscriptionFilterAreaRelationModel);
            }
            boolean consider = false;
            Boolean b = subscriptionFilterModel.getMonday();
            this.monday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getTuesday();
            this.tuesday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getWednesday();
            this.wednesday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getThursday();
            this.thursday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getFriday();
            this.friday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getSaturday();
            this.saturday.setSelected(b != null && b != false);
            consider |= b != null;
            b = subscriptionFilterModel.getSunday();
            this.sunday.setSelected(b != null && b != false);
            this.considerWeekday.setSelected(consider |= b != null);
            this.subscriptionDeliveryType.setSelectedValue(subscriptionFilterModel.getDeliveryType());
        }
    }

    private class SubscriptionFilterAreaRelationActionListener
    implements ActionListener {
        private SubscriptionFilterAreaRelationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubscriptionFilterPane.this.setSpecialEnabled(SubscriptionFilterPane.this.isEnabled());
        }
    }

    private class AreaSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 702941251827464621L;

        private AreaSelectionAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaSelection", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog = new MultiAreaObjectSelectionDialog(SubscriptionFilterPane.this.getParentWindow(), SubscriptionFilterPane.this.getModelEnviroment(), new MultiAreaObjectSelectionDialog.CallBack(){

                @Override
                public void doOnOk(MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog) {
                    Collection<AreaObjectModel> areaObjectModels = multiAreaObjectSelectionDialog.getSelectedAreaObjects();
                    SubscriptionFilterPane.this.subscriptionFilterAreaRelationModels = new ArrayList(areaObjectModels.size());
                    for (AreaObjectModel areaObjectModel : areaObjectModels) {
                        SubscriptionFilterAreaRelationModelImpl subscriptionFilterAreaRelationModel = new SubscriptionFilterAreaRelationModelImpl();
                        subscriptionFilterAreaRelationModel.setAreaObject(areaObjectModel);
                        SubscriptionFilterPane.this.subscriptionFilterAreaRelationModels.add(subscriptionFilterAreaRelationModel);
                    }
                }

                @Override
                public void doOnCancel(MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog) {
                }
            });
            ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(SubscriptionFilterPane.this.subscriptionFilterAreaRelationModels.size());
            for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : SubscriptionFilterPane.this.subscriptionFilterAreaRelationModels) {
                list.add(subscriptionFilterAreaRelationModel.getAreaObject());
            }
            multiAreaObjectSelectionDialog.setSelectedAreaObjects(list);
            multiAreaObjectSelectionDialog.pack();
            SwingUtils.center((Window)multiAreaObjectSelectionDialog, SwingUtils.findWindowParent(SubscriptionFilterPane.this));
            multiAreaObjectSelectionDialog.setVisible(true);
        }
    }
}

