/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.poi;

import de.datomino.peppergis.client.gui.attribute.filter.AbstractAttributeFilterPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.filter.AbstractFilterPane;
import de.datomino.peppergis.client.gui.filter.poi.PoiAttributeFilterPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class PoiFilterPane
extends AbstractFilterPane<PoiFilterModel, PoiAttributeValueDescriptorModel, PoiStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = 7753054945437663853L;
    private JTextField poiNumber;
    private EnumComboBox<PoiType> poiType;

    public PoiFilterPane(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void adaptSpecialValuesToModel(ModelObjectFilter<PoiFilterModel> modelObjectFilter) {
        PoiFilterModel poiFilterModel = (PoiFilterModel)modelObjectFilter.getAttachedObject();
        poiFilterModel.setPoiNumber(this.poiNumber.getText());
        poiFilterModel.setPoiType(this.poiType.getSelectedValue());
    }

    @Override
    protected AbstractAttributeFilterPane<PoiAttributeValueDescriptorModel, PoiStaticChoiceAttributeValueModel> createAttributeFilterPane() {
        PoiAttributeFilterPane poiAttributeFilterPane = new PoiAttributeFilterPane(this.getParentWindow(), this.getModelEnviroment().getAllCaller().getBaseCaller().getAllPoiAttributeValueDescriptors());
        return poiAttributeFilterPane;
    }

    @Override
    protected Component getSpecialParameterComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.poiNumber", new Serializable[0])));
        this.poiNumber = new JTextField(30);
        panel.add(this.poiNumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.status", new Serializable[0])));
        EnumSet<PoiType> types = EnumSet.allOf(PoiType.class);
        types.removeAll(Arrays.asList(PoiType.ORIGIN, PoiType.END_POINT, PoiType.REMOVED));
        this.poiType = new EnumComboBox<PoiType>(PoiType.class, true, (Collection<PoiType>)types);
        panel.add(this.poiType);
        SpringUtilities.makeCompactGrid(panel, 2, 2, 2, 2, 2, 2);
        return panel;
    }

    @Override
    protected void setSpecialEnabled(boolean enabled) {
        this.poiType.setEnabled(enabled);
        this.poiNumber.setEditable(enabled);
    }

    @Override
    protected void setSpecialFilterValues(ModelObjectFilter<PoiFilterModel> modelObjectFilter) {
        if (modelObjectFilter == null) {
            this.poiType.setSelectedValue(PoiType.AREAOBJECT_LOCATION);
            this.poiNumber.setText("");
        } else {
            PoiFilterModel poiFilterModel = (PoiFilterModel)modelObjectFilter.getAttachedObject();
            PoiType poiType = poiFilterModel.getPoiType();
            this.poiType.setSelectedValue(poiType);
            String poiNumber = poiFilterModel.getPoiNumber();
            this.poiNumber.setText(poiNumber == null ? "" : poiNumber);
        }
    }
}

