/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.renderer;

import de.datomino.peppergis.client.gui.filter.pattern.renderer.AbstractRendererPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class FilterPatternParameterTableModel<V extends Model>
extends AbstractTableModel {
    private static final long serialVersionUID = 4637992938581323169L;
    private AbstractRendererPane<?, ?, ?, V, ?, ?, ?, ?> rendererPane;
    private List<Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>>> parameterList;
    private String languagePrefix;

    public FilterPatternParameterTableModel(AbstractRendererPane<?, ?, ?, V, ?, ?, ?, ?> rendererPane) {
        this.rendererPane = rendererPane;
        this.languagePrefix = RendererType.class.getName() + "." + this.rendererPane.getRendererType().name();
        this.parameterList = new ArrayList();
        for (String parameter : rendererPane.getParameterKeys()) {
            this.addParameter(parameter);
        }
    }

    private void addParameter(String name) {
        this.parameterList.add(new Tripel(name, null, this.rendererPane.getParameterEditor(name)));
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.parameterList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>> tripel = this.parameterList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>> tripelBefore;
                String drawString = tripel.getElement1();
                if (rowIndex > 0 && (tripelBefore = this.parameterList.get(rowIndex - 1)).getElement1().equals(drawString)) {
                    drawString = "";
                }
                return StringUtil.isBlank(drawString) ? "" : ModelEnviroment.getMessageResolver().resolveMessage(this.languagePrefix + "." + drawString, new Serializable[0]);
            }
            case 1: {
                return tripel.getElement2();
            }
            case 2: {
                return tripel.getElement3();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return ObjectFilter.class;
            }
            case 2: {
                return Component.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>> tripel = this.parameterList.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                boolean newOne = tripel.getElement2() == null;
                boolean delete = false;
                if (aValue == null || aValue instanceof String) {
                    tripel.setElement2(null);
                    delete = true;
                } else {
                    tripel.setElement2((ObjectFilter)aValue);
                }
                if (newOne && delete) {
                    return;
                }
                if (delete) {
                    this.parameterList.remove(rowIndex);
                    this.fireTableRowsDeleted(rowIndex, rowIndex);
                    break;
                }
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                if (!newOne) break;
                Tripel newTripel = new Tripel(tripel.getElement1(), null, this.rendererPane.getParameterEditor(tripel.getElement1()));
                this.parameterList.add(rowIndex + 1, newTripel);
                this.fireTableRowsInserted(rowIndex + 1, rowIndex + 1);
                break;
            }
        }
    }

    public String getParameterKey(int row) {
        return this.parameterList.get(row).getElement1();
    }

    public List<Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>>> getParameterList() {
        return this.parameterList;
    }

    public <U, T, S, X> void setParameters(List<FilterPatternParameter<U, T, S, V, AttributeValueFilterModel, X, AreaLayerModel>> parameters) {
        this.parameterList = new LinkedList();
        HashMap map = new HashMap();
        String[] parameterKeys = this.rendererPane.getParameterKeys();
        for (String parameter : parameterKeys) {
            map.put(parameter, new LinkedList());
        }
        for (FilterPatternParameter filterPatternParameter : parameters) {
            String key = filterPatternParameter.getParameterKey();
            String value = filterPatternParameter.getParameterValue();
            ObjectFilter filter = filterPatternParameter.getObjectFilter();
            ValueEditor<?> parameterEditor = this.rendererPane.getParameterEditor(key);
            if (parameterEditor == null) continue;
            ((List)map.get(key)).add(new Tripel(key, filter, parameterEditor));
            parameterEditor.setSerializedValue(value);
        }
        for (String key : parameterKeys) {
            List list = (List)map.get(key);
            boolean nullExists = false;
            for (Tripel tripel : list) {
                if (tripel.getElement2() != null) continue;
                nullExists = true;
            }
            this.parameterList.addAll(list);
            if (nullExists) continue;
            this.addParameter(key);
        }
        this.fireTableDataChanged();
    }
}

