/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.legend;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.FilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatternLegendSelectionListener;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tupel;

public class FilterPatternLegendPane<T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model>
extends AbstractLegendPane<T, S, U, V, X> {
    private static final long serialVersionUID = -8702137653458181218L;
    private AbstractLegendPane.SymbolType symbolType;
    private ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup;
    private ModelEnviroment modelEnviroment;
    private Set<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>> checkBoxes;
    private JCheckBox defaultCheckBox;
    private FilterPatternLegendDialog<T, S, U, V, W, X> filterDialog;
    private List<PatternLegendSelectionListener> patternLegendSelectionListeners = new LinkedList<PatternLegendSelectionListener>();

    public FilterPatternLegendPane(AbstractLegendPane.SymbolType symbolType, ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup, ModelEnviroment modelEnviroment, boolean markable, FilterPatternLegendDialog<T, S, U, V, W, X> filterDialog) {
        super(new BorderLayout());
        this.symbolType = symbolType;
        this.modelFilterPatternSetup = modelFilterPatternSetup;
        this.modelEnviroment = modelEnviroment;
        this.filterDialog = filterDialog;
        this.buildLayout(markable);
    }

    private void buildLayout(boolean markable) {
        if (this.modelFilterPatternSetup != null) {
            Quad<Map<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>>, Map<ObjectFilter<V, AttributeValueFilterModel>, RendererType>, List<Tupel<String, String>>, RendererType> rendererInformation = this.getRendererInformation(this.modelFilterPatternSetup);
            Map<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>> highestParamMap = rendererInformation.getElement1();
            Map<ObjectFilter<V, AttributeValueFilterModel>, RendererType> rendererTypeMap = rendererInformation.getElement2();
            List<Tupel<String, String>> defaultParams = rendererInformation.getElement3();
            RendererType defaultRendererType = rendererInformation.getElement4();
            JPanel rendererPane = new JPanel(new SpringLayout());
            this.checkBoxes = new HashSet<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>>();
            for (Map.Entry<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>> entry : highestParamMap.entrySet()) {
                String name;
                final ObjectFilter<V, AttributeValueFilterModel> objectFilter = entry.getKey();
                String string = name = objectFilter == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.default", new Serializable[0]) : objectFilter.getName();
                if (markable) {
                    final JCheckBox checkBox = new JCheckBox(name, true);
                    checkBox.setVerticalAlignment(1);
                    this.checkBoxes.add(new Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>(objectFilter, checkBox));
                    rendererPane.add(checkBox);
                    checkBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (objectFilter.getAttachedObject() != null && objectFilter.getAttachedObject() instanceof AreaFilterModel) {
                                FilterPatternLegendPane.this.registerSelectedFilter((Model)objectFilter.getAttachedObject(), checkBox.isSelected());
                            }
                            FilterPatternLegendPane.this.processFilterSelectionChanged(objectFilter, checkBox.isSelected());
                        }
                    });
                    if (objectFilter.getAttachedObject() != null && objectFilter.getAttachedObject() instanceof AreaFilterModel) {
                        this.registerSelectedFilter((Model)objectFilter.getAttachedObject(), markable);
                        if (markable) {
                            this.filterDialog.addToInitialFiltersList((Model)objectFilter.getAttachedObject());
                        }
                    }
                } else {
                    JLabel label = new JLabel(name);
                    label.setVerticalAlignment(1);
                    this.checkBoxes.add(new Tupel<ObjectFilter<V, AttributeValueFilterModel>, Object>(objectFilter, null));
                    rendererPane.add(label);
                }
                RendererType rendererType = rendererTypeMap.get(objectFilter);
                List<Tupel<String, String>> params = entry.getValue();
                for (Tupel<String, String> dParam : defaultParams) {
                    boolean found = false;
                    for (Tupel<String, String> param : params) {
                        if (!dParam.getElement1().equals(param.getElement1())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    params.add(dParam);
                }
                rendererPane.add(this.createRendererPanel(rendererType, params, this.symbolType, this.modelEnviroment));
            }
            String defaultName = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.default", new Serializable[0]);
            if (markable) {
                this.defaultCheckBox = new JCheckBox(defaultName, true);
                this.defaultCheckBox.setVerticalAlignment(1);
                rendererPane.add(this.defaultCheckBox);
                this.defaultCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FilterPatternLegendPane.this.processDefaultSelectionChanged(FilterPatternLegendPane.this.defaultCheckBox.isSelected());
                    }
                });
            } else {
                JLabel label = new JLabel(defaultName);
                label.setVerticalAlignment(1);
                rendererPane.add(label);
            }
            RendererType rendererType = defaultRendererType == null ? RendererType.INVISIBLE : defaultRendererType;
            rendererPane.add(this.createRendererPanel(rendererType, defaultParams, this.symbolType, this.modelEnviroment));
            SpringUtilities.makeCompactGrid(rendererPane, highestParamMap.size() + 1, 2, 10, 10, 20, 10);
            this.add((Component)rendererPane, "North");
        }
    }

    public boolean isDefaultSelected() {
        return this.defaultCheckBox == null || this.defaultCheckBox.isSelected();
    }

    public Collection<ObjectFilter<V, AttributeValueFilterModel>> getSelectedObjectFilter() {
        LinkedList<ObjectFilter<V, AttributeValueFilterModel>> objectFilters = new LinkedList<ObjectFilter<V, AttributeValueFilterModel>>();
        for (Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox> tupel : this.checkBoxes) {
            JCheckBox checkBox = tupel.getElement2();
            if (checkBox != null && !checkBox.isSelected()) continue;
            objectFilters.add(tupel.getElement1());
        }
        return objectFilters;
    }

    protected void processDefaultSelectionChanged(boolean selection) {
        this.fireDefaultSelectionChanged(new PatterLegendSelectionEvent(this, null, selection));
    }

    protected void processFilterSelectionChanged(ObjectFilter<V, AttributeValueFilterModel> objectFilter, boolean selection) {
        this.fireFilterSelectionChanged(new PatterLegendSelectionEvent<V>(this, objectFilter, selection));
    }

    protected void registerSelectedFilter(V selectedFilter, boolean isSelected) {
        if (isSelected) {
            this.filterDialog.addToSelectedFiltersList(selectedFilter);
        } else {
            this.filterDialog.removeFromSelectedFiltersList((Model)selectedFilter);
        }
    }

    public void addPatternLegendSelectionListener(PatternLegendSelectionListener<V> patternLegendSelectionListener) {
        this.patternLegendSelectionListeners.add(patternLegendSelectionListener);
    }

    public void removePatternLegendSelectionListener(PatternLegendSelectionListener<V> patternLegendSelectionListener) {
        this.patternLegendSelectionListeners.remove(patternLegendSelectionListener);
    }

    protected void fireDefaultSelectionChanged(PatterLegendSelectionEvent<V> event) {
        for (PatternLegendSelectionListener patternLegendSelectionListener : this.patternLegendSelectionListeners) {
            patternLegendSelectionListener.defaultSelectionChanged(event);
        }
    }

    protected void fireFilterSelectionChanged(PatterLegendSelectionEvent<V> event) {
        for (PatternLegendSelectionListener patternLegendSelectionListener : this.patternLegendSelectionListeners) {
            patternLegendSelectionListener.filterSelectionChanged(event);
        }
    }

    public Boolean isShowDefaultSelected() {
        return this.defaultCheckBox.isSelected();
    }
}

