/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.SetupLayerRelation;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractFilterPatternSetupDialog<T extends Model, S extends Model, U extends Model, V extends Model, X extends Model>
extends CommonDialog {
    private static final long serialVersionUID = 5941840198760155315L;
    private ModelEnviroment modelEnviroment;
    private JList setupList;
    private Action addAction;
    private Action removeAction;
    private Action duplicateAction;
    private Action openAction;

    public AbstractFilterPatternSetupDialog(Window parent, String title) {
        super((Component)parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = new ModelEnviroment(parent);
        this.buildLayout();
        this.modelEnviroment.getUndoManager().startTransaction();
        this.fillValues();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    private void fillValues() {
        Collection<ModelFilterPatternSetup<T, S, U, V, X>> setups = this.fetchSetups(this.modelEnviroment);
        DefaultListModel dlm = (DefaultListModel)this.setupList.getModel();
        for (ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup : setups) {
            dlm.addElement(new SetupItem(modelFilterPatternSetup));
        }
    }

    protected abstract Collection<ModelFilterPatternSetup<T, S, U, V, X>> fetchSetups(ModelEnviroment var1);

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -2295283723586929432L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilterPatternSetupDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.setupList = new JList(new DefaultListModel());
        this.setupList.setSelectionMode(0);
        this.setupList.addListSelectionListener(new SetupListSelectionListener());
        this.setupList.addMouseListener(new SetupListMouseListener());
        panel.add((Component)new JScrollPane(this.setupList), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.removeAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = -2295283723586929432L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupItem setupItem = (SetupItem)AbstractFilterPatternSetupDialog.this.setupList.getSelectedValue();
                AbstractFilterPatternSetupDialog.this.deleteCascaded(setupItem);
                DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternSetupDialog.this.setupList.getModel();
                dlm.removeElement(setupItem);
            }
        };
        buttonPanel.add(new JButton(this.removeAction));
        this.removeAction.setEnabled(false);
        this.addAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0])){
            private static final long serialVersionUID = -7325180118532519870L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelFilterPatternSetup modelFilterPatternSetup = AbstractFilterPatternSetupDialog.this.createNewFilterPatternSetup();
                modelFilterPatternSetup.setName(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.newSetup", new Serializable[0]));
                DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternSetupDialog.this.setupList.getModel();
                dlm.addElement(new SetupItem(modelFilterPatternSetup));
            }
        };
        buttonPanel.add(new JButton(this.addAction));
        this.duplicateAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0])){
            private static final long serialVersionUID = -1237795203102461733L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupItem setupItem = (SetupItem)AbstractFilterPatternSetupDialog.this.setupList.getSelectedValue();
                DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternSetupDialog.this.setupList.getModel();
                ModelFilterPatternSetup newFilterPatternSetup = AbstractFilterPatternSetupDialog.this.duplicateFilterPatternSetup(setupItem.getModelFilterPatternSetup());
                if (newFilterPatternSetup != null) {
                    dlm.addElement(new SetupItem(newFilterPatternSetup));
                }
            }
        };
        buttonPanel.add(new JButton(this.duplicateAction));
        this.duplicateAction.setEnabled(false);
        this.openAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.open", new Serializable[0])){
            private static final long serialVersionUID = -1237795203102461733L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilterPatternSetupDialog.this.openPatternSetup();
            }
        };
        buttonPanel.add(new JButton(this.openAction));
        this.openAction.setEnabled(false);
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    protected abstract ModelFilterPatternSetup<T, S, U, V, X> duplicateFilterPatternSetup(ModelFilterPatternSetup<T, S, U, V, X> var1);

    protected abstract ModelFilterPatternSetup<T, S, U, V, X> createNewFilterPatternSetup();

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -1237795203102461733L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilterPatternSetupDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
                try {
                    AbstractFilterPatternSetupDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                    AbstractFilterPatternSetupDialog.this.dispose();
                    AbstractFilterPatternSetupDialog.this.doAfterOkAction();
                }
                catch (ValidateException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private void deleteCascaded(SetupItem setupItem) {
        ((Model)setupItem.getModelFilterPatternSetup().getAttachedObject()).delete();
        List relations = setupItem.getModelFilterPatternSetup().getRelations();
        for (FilterPatternRelation filterPatternRelation : relations) {
            ((Model)filterPatternRelation.getAttachedObject()).delete();
            List parameters = filterPatternRelation.getFilterPatternParameter();
            for (FilterPatternParameter parameter : parameters) {
                ((Model)parameter.getAttachedObject()).delete();
            }
        }
        Set setupLayerRelations = setupItem.getModelFilterPatternSetup().getLayerRelations();
        for (SetupLayerRelation relTobeDeleted : setupLayerRelations) {
            ((Model)relTobeDeleted.getAttachedObject()).delete();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.addAction.setEnabled(b);
        this.openAction.setEnabled(b);
        boolean removeEnabled = b;
        boolean duplicateEnabled = b;
        if (b) {
            SetupItem setupItem = (SetupItem)this.setupList.getSelectedValue();
            boolean bl = removeEnabled = setupItem != null;
            if (removeEnabled) {
                Boolean modifiable = setupItem.getModelFilterPatternSetup().getModifiable();
                removeEnabled = modifiable == null || modifiable != false;
            }
            duplicateEnabled = setupItem != null;
        }
        this.removeAction.setEnabled(removeEnabled);
        this.duplicateAction.setEnabled(duplicateEnabled);
    }

    protected abstract void showSetupDialog(ModelFilterPatternSetup<T, S, U, V, X> var1, ModelEnviroment var2);

    protected void doAfterOkAction() {
    }

    private void openPatternSetup() {
        SetupItem setupItem = (SetupItem)this.setupList.getSelectedValue();
        if (setupItem != null) {
            this.modelEnviroment.getUndoManager().finishTransaction("");
            this.showSetupDialog(setupItem.getModelFilterPatternSetup(), this.modelEnviroment);
            this.modelEnviroment.getUndoManager().startTransaction();
        }
    }

    private class SetupItem {
        private ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup;

        public SetupItem(ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup) {
            this.modelFilterPatternSetup = modelFilterPatternSetup;
        }

        public ModelFilterPatternSetup<T, S, U, V, X> getModelFilterPatternSetup() {
            return this.modelFilterPatternSetup;
        }

        public String toString() {
            return this.getModelFilterPatternSetup().getName();
        }
    }

    private class SetupListMouseListener
    extends MouseAdapter {
        private SetupListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() > 1) {
                AbstractFilterPatternSetupDialog.this.openPatternSetup();
            }
        }
    }

    private class SetupListSelectionListener
    implements ListSelectionListener {
        private SetupListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AbstractFilterPatternSetupDialog.this.setEnabled(AbstractFilterPatternSetupDialog.this.isEnabled());
        }
    }
}

