/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern;

import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.filter.pattern.renderer.AbstractRendererPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternRelation;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.SetupLayerRelation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractFilterPatternRelationPane<T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model>
extends JPanel {
    private static final long serialVersionUID = -8630609915908444235L;
    private JTextField setupName;
    private JPanel cardPane;
    private CardLayout cardLayout;
    private RendererType shownRendererType;
    private JList relationList;
    private JComboBox rendererTypeComboBox;
    private JList layerList;
    private Action addAction;
    private Action removeAction;
    private ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup;
    private FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, X, AreaLayerModel> modelFilterPatternRelation;
    private Map<RendererType, AbstractRendererPane<T, S, U, V, W, ?, ?, X>> rendererPaneMap;
    private Window parent;
    private ModelEnviroment modelEnviroment;

    public AbstractFilterPatternRelationPane(Window parent, ModelEnviroment modelEnviroment, ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup) {
        super(new BorderLayout());
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.modelFilterPatternSetup = modelFilterPatternSetup;
        this.fillValues();
    }

    private void fillValues() {
        this.setupName.setText(this.modelFilterPatternSetup.getName());
        DefaultListModel dlm = (DefaultListModel)this.relationList.getModel();
        for (FilterPatternRelation filterPatternRelation : this.modelFilterPatternSetup.getRelations()) {
            dlm.addElement(new FilterPatternRelationListItem(filterPatternRelation, Integer.toString(dlm.getSize())));
        }
        Collection<AreaLayerModel> layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        dlm = (DefaultListModel)this.layerList.getModel();
        TreeSet<Integer> indicesToSelect = new TreeSet<Integer>();
        int count = 0;
        for (AreaLayerModel areaLayerModel : layers) {
            dlm.addElement(areaLayerModel);
            for (SetupLayerRelation setupLayerRelation : this.modelFilterPatternSetup.getLayerRelations()) {
                if (!areaLayerModel.equals(setupLayerRelation.getAreaLayer())) continue;
                indicesToSelect.add(count);
                break;
            }
            ++count;
        }
        int[] indices = new int[indicesToSelect.size()];
        count = 0;
        for (Integer i : indicesToSelect) {
            indices[count] = i;
            ++count;
        }
        this.layerList.setSelectedIndices(indices);
        Boolean bl = this.modelFilterPatternSetup.getModifiable();
        this.setEnabled(this.isEnabled() && (bl == null || bl != false));
    }

    private void buildLayout() {
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])), "West");
        this.setupName = new JTextField(30);
        namePanel.add((Component)this.setupName, "Center");
        this.add((Component)namePanel, "North");
        JPanel listPanel = new JPanel(new BorderLayout());
        this.relationList = new JList(new DefaultListModel());
        this.relationList.setSelectionMode(0);
        this.relationList.addListSelectionListener(new RelationListSelectionListener());
        listPanel.add((Component)new JScrollPane(this.relationList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        buttonPanel.add((Component)new JButton(this.removeAction), "West");
        this.addAction = new AddAction();
        buttonPanel.add((Component)new JButton(this.addAction), "East");
        listPanel.add((Component)buttonPanel, "South");
        this.add((Component)listPanel, "West");
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        this.rendererTypeComboBox = new JComboBox<Object>(EnumItem.createEnumItems(Arrays.asList(this.getValidRendererTypes())).toArray());
        this.rendererTypeComboBox.addActionListener(new RendererComboBoxListener());
        topPanel.add((Component)this.rendererTypeComboBox, "Center");
        mainPanel.add((Component)topPanel, "North");
        this.cardLayout = new CardLayout();
        this.cardPane = new JPanel(this.cardLayout);
        this.setupCards();
        mainPanel.add((Component)new JScrollPane(this.cardPane), "Center");
        this.add((Component)mainPanel, "Center");
        JPanel layerPanel = new JPanel(new BorderLayout());
        this.layerList = new JList(new DefaultListModel());
        this.layerList.getSelectionModel().setSelectionMode(2);
        final ListCellRenderer listCellRenderer = this.layerList.getCellRenderer();
        this.layerList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof AreaLayerModel) {
                    value = ((AreaLayerModel)value).getDisplayname();
                }
                return listCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        layerPanel.add((Component)new JScrollPane(this.layerList), "South");
        this.add((Component)layerPanel, "South");
    }

    private void setupCards() {
        this.rendererPaneMap = new HashMap();
        for (RendererType rendererType : this.getValidRendererTypes()) {
            AbstractRendererPane<T, S, U, V, W, ?, ?, X> rendererPane = this.createRendererPane(rendererType);
            this.cardPane.add(rendererPane, rendererType.name());
            this.rendererPaneMap.put(rendererType, rendererPane);
        }
    }

    protected abstract RendererType[] getValidRendererTypes();

    protected abstract AbstractRendererPane<T, S, U, V, W, ?, ?, X> createRendererPane(RendererType var1);

    protected abstract ModelFilterPatternRelation<T, S, U, V, X> createModelFilterPatternRelation();

    private void deleteCascaded(FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, X, AreaLayerModel> modelFilterPatternRelation) {
        modelFilterPatternRelation.setPatternSetup(null);
        ((Model)modelFilterPatternRelation.getAttachedObject()).delete();
        for (FilterPatternParameter<U, T, S, V, AttributeValueFilterModel, X, AreaLayerModel> modelFilterPatternParameter : modelFilterPatternRelation.getFilterPatternParameter()) {
            ((Model)modelFilterPatternParameter.getAttachedObject()).delete();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean selected = !this.relationList.isSelectionEmpty();
        this.rendererTypeComboBox.setEnabled(enabled && selected);
        for (int i = 0; i < this.cardPane.getComponentCount(); ++i) {
            this.cardPane.getComponent(i).setEnabled(enabled && selected);
        }
        this.removeAction.setEnabled(enabled && selected);
        this.addAction.setEnabled(enabled);
        this.layerList.setEnabled(enabled);
    }

    private void reorgNumberTitles() {
        DefaultListModel dlm = (DefaultListModel)this.relationList.getModel();
        for (int i = 0; i < dlm.getSize(); ++i) {
            FilterPatternRelationListItem filterPatternRelationListItem = (FilterPatternRelationListItem)dlm.getElementAt(i);
            filterPatternRelationListItem.setTitle(Integer.toString(i));
        }
    }

    public void adaptValuesToModel() {
        this.modelFilterPatternSetup.setName(this.setupName.getText());
        Object[] selectedValues = this.layerList.getSelectedValues();
        HashSet setupLayerRelations = new HashSet();
        for (Object value : selectedValues) {
            AreaLayerModel areaLayerModel = (AreaLayerModel)value;
            SetupLayerRelation<X, AreaLayerModel> setupLayerRelation = this.createSetupLayerRelation();
            setupLayerRelation.setAreaLayer(areaLayerModel);
            setupLayerRelations.add(setupLayerRelation);
        }
        this.modelFilterPatternSetup.setLayerRelations(setupLayerRelations);
        if (this.modelFilterPatternRelation != null) {
            EnumItem enumItem = (EnumItem)this.rendererTypeComboBox.getSelectedItem();
            RendererType rendererType = (RendererType)((Object)enumItem.getT());
            this.modelFilterPatternRelation.setRendererType(rendererType);
            AbstractRendererPane<T, S, U, V, W, ?, ?, X> rendererPane = this.rendererPaneMap.get((Object)this.shownRendererType);
            rendererPane.adaptValuesToModel();
        }
    }

    protected abstract SetupLayerRelation<X, AreaLayerModel> createSetupLayerRelation();

    protected Window getWindowParent() {
        return this.parent;
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    private class FilterPatternRelationListItem {
        private FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, X, AreaLayerModel> modelFilterPatternRelation;
        private String title;

        public FilterPatternRelationListItem(FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, X, AreaLayerModel> modelFilterPatternRelation, String title) {
            this.modelFilterPatternRelation = modelFilterPatternRelation;
            this.title = title;
        }

        public FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, X, AreaLayerModel> getModelFilterPatternRelation() {
            return this.modelFilterPatternRelation;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    private class RendererComboBoxListener
    implements ActionListener {
        private RendererComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EnumItem enumItem = (EnumItem)AbstractFilterPatternRelationPane.this.rendererTypeComboBox.getSelectedItem();
            RendererType rendererType = (RendererType)((Object)enumItem.getT());
            AbstractFilterPatternRelationPane.this.modelFilterPatternRelation.setRendererType(rendererType);
            for (AbstractRendererPane pane : AbstractFilterPatternRelationPane.this.rendererPaneMap.values()) {
                pane.setFilterPatternRelation(null);
            }
            AbstractRendererPane rendererPane = (AbstractRendererPane)AbstractFilterPatternRelationPane.this.rendererPaneMap.get((Object)rendererType);
            rendererPane.setFilterPatternRelation(AbstractFilterPatternRelationPane.this.modelFilterPatternRelation);
            AbstractFilterPatternRelationPane.this.cardLayout.show(AbstractFilterPatternRelationPane.this.cardPane, rendererType.name());
            AbstractFilterPatternRelationPane.this.shownRendererType = rendererType;
        }
    }

    private class RelationListSelectionListener
    implements ListSelectionListener {
        private RelationListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AbstractFilterPatternRelationPane.this.setEnabled(AbstractFilterPatternRelationPane.this.isEnabled());
            AbstractFilterPatternRelationPane.this.adaptValuesToModel();
            FilterPatternRelationListItem selected = (FilterPatternRelationListItem)AbstractFilterPatternRelationPane.this.relationList.getSelectedValue();
            if (selected != null) {
                FilterPatternRelation modelFilterPatternRelation = selected.getModelFilterPatternRelation();
                AbstractFilterPatternRelationPane.this.modelFilterPatternRelation = modelFilterPatternRelation;
                RendererType rendererType = modelFilterPatternRelation.getRendererType();
                for (int i = 0; i < AbstractFilterPatternRelationPane.this.rendererTypeComboBox.getItemCount(); ++i) {
                    EnumItem item = (EnumItem)AbstractFilterPatternRelationPane.this.rendererTypeComboBox.getItemAt(i);
                    if (rendererType != item.getT()) continue;
                    AbstractFilterPatternRelationPane.this.rendererTypeComboBox.setSelectedIndex(i);
                    break;
                }
                for (AbstractRendererPane pane : AbstractFilterPatternRelationPane.this.rendererPaneMap.values()) {
                    pane.setFilterPatternRelation(null);
                }
                AbstractRendererPane pane = (AbstractRendererPane)AbstractFilterPatternRelationPane.this.rendererPaneMap.get((Object)rendererType);
                pane.setFilterPatternRelation(modelFilterPatternRelation);
                AbstractFilterPatternRelationPane.this.cardLayout.show(AbstractFilterPatternRelationPane.this.cardPane, RendererType.INVISIBLE.name());
                AbstractFilterPatternRelationPane.this.cardLayout.show(AbstractFilterPatternRelationPane.this.cardPane, rendererType.name());
                AbstractFilterPatternRelationPane.this.shownRendererType = rendererType;
                AbstractFilterPatternRelationPane.this.layerList.clearSelection();
                DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternRelationPane.this.layerList.getModel();
                Set layerRelations = modelFilterPatternRelation.getPatternSetup().getLayerRelations();
                LinkedList<Integer> toSelect = new LinkedList<Integer>();
                if (layerRelations != null) {
                    for (int i = 0; i < dlm.getSize(); ++i) {
                        AreaLayerModel areaLayerModel = (AreaLayerModel)dlm.elementAt(i);
                        for (SetupLayerRelation setupLayerRelation : layerRelations) {
                            if (!((AreaLayerModel)setupLayerRelation.getAreaLayer()).equals(areaLayerModel)) continue;
                            toSelect.add(i);
                        }
                    }
                }
                int[] toSelectArray = new int[toSelect.size()];
                int count = 0;
                for (Integer n : toSelect) {
                    toSelectArray[count] = n;
                    ++count;
                }
                AbstractFilterPatternRelationPane.this.layerList.setSelectedIndices(toSelectArray);
            } else {
                AbstractFilterPatternRelationPane.this.cardLayout.show(AbstractFilterPatternRelationPane.this.cardPane, RendererType.INVISIBLE.name());
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -8522024325566007024L;

        private RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterPatternRelationListItem selected = (FilterPatternRelationListItem)AbstractFilterPatternRelationPane.this.relationList.getSelectedValue();
            FilterPatternRelation modelFilterPatternRelation = selected.getModelFilterPatternRelation();
            AbstractFilterPatternRelationPane.this.deleteCascaded(modelFilterPatternRelation);
            DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternRelationPane.this.relationList.getModel();
            dlm.removeElement(selected);
            AbstractFilterPatternRelationPane.this.reorgNumberTitles();
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 205599512825833137L;

        private AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel dlm = (DefaultListModel)AbstractFilterPatternRelationPane.this.relationList.getModel();
            ModelFilterPatternRelation modelFilterPatternRelation = AbstractFilterPatternRelationPane.this.createModelFilterPatternRelation();
            modelFilterPatternRelation.setPatternSetup(AbstractFilterPatternRelationPane.this.modelFilterPatternSetup);
            modelFilterPatternRelation.setRendererType(RendererType.INVISIBLE);
            dlm.addElement(new FilterPatternRelationListItem(modelFilterPatternRelation, Integer.toString(dlm.getSize())));
        }
    }
}

