/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.letter;

import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelectionDialog;
import de.datomino.peppergis.client.gui.attribute.filter.AbstractAttributeFilterPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.filter.AbstractFilterPane;
import de.datomino.peppergis.client.gui.filter.letter.LetterAttributeFilterPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.LetterFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.LetterFilterAreaRelationModelImpl;
import de.datomino.peppergis.client.model.filter.LetterFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class LetterFilterPane
extends AbstractFilterPane<LetterFilterModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = 7753054945437663853L;
    private JTextField letterNumber;
    private JCheckBox letterFilterAreaRelationEnabled;
    private Collection<LetterFilterAreaRelationModel> letterFilterAreaRelationModels = Collections.emptySet();
    private AreaSelectionAction areaSelectionAction;
    private EnumComboBox<LetterDeliveryType> letterDeliveryType;
    private JFormattedTextField startDate;
    private JFormattedTextField endDate;

    public LetterFilterPane(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void adaptSpecialValuesToModel(ModelObjectFilter<LetterFilterModel> modelObjectFilter) {
        LetterFilterModel letterFilterModel = (LetterFilterModel)modelObjectFilter.getAttachedObject();
        letterFilterModel.setLetterNumber(this.letterNumber.getText());
        letterFilterModel.setLetterFilterAreaEnabled(this.letterFilterAreaRelationEnabled.isSelected());
        for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : this.letterFilterAreaRelationModels) {
            letterFilterAreaRelationModel.setLetterFilter(letterFilterModel);
        }
        for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : letterFilterModel.iterableLetterFilterAreaRelation()) {
            if (this.letterFilterAreaRelationModels.contains(letterFilterAreaRelationModel)) continue;
            letterFilterAreaRelationModel.delete();
        }
        letterFilterModel.clearLetterFilterAreaRelation();
        for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : this.letterFilterAreaRelationModels) {
            letterFilterModel.addALetterFilterAreaRelation(letterFilterAreaRelationModel);
        }
        letterFilterModel.setDeliveryType(this.letterDeliveryType.getSelectedValue());
        letterFilterModel.setStartDate((Date)this.startDate.getValue());
        letterFilterModel.setEndDate((Date)this.endDate.getValue());
    }

    @Override
    protected AbstractAttributeFilterPane<LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> createAttributeFilterPane() {
        LetterAttributeFilterPane letterAttributeFilterPane = new LetterAttributeFilterPane(this.getParentWindow(), this.getModelEnviroment().getAllCaller().getLetterCaller().getAllLetterAttributeValueDescriptors());
        return letterAttributeFilterPane;
    }

    @Override
    protected Component getSpecialParameterComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letterNumber", new Serializable[0])));
        this.letterNumber = new JTextField(30);
        panel.add(this.letterNumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0])));
        JPanel bPanel = new JPanel(new BorderLayout());
        JPanel sPanel = new JPanel(new SpringLayout());
        this.letterFilterAreaRelationEnabled = new JCheckBox();
        this.letterFilterAreaRelationEnabled.addActionListener(new LetterFilterAreaRelationActionListener());
        sPanel.add(this.letterFilterAreaRelationEnabled);
        this.areaSelectionAction = new AreaSelectionAction();
        JButton button = new JButton(this.areaSelectionAction);
        sPanel.add(button);
        SpringUtilities.makeCompactGrid(sPanel, 1, 2, 2, 2, 2, 2);
        bPanel.add((Component)sPanel, "West");
        panel.add(bPanel);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(LetterDeliveryType.class.getName(), new Serializable[0])));
        this.letterDeliveryType = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, true);
        panel.add(this.letterDeliveryType);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.validationTime", new Serializable[0])));
        sPanel = new JPanel(new BorderLayout());
        this.startDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        this.startDate.setColumns(30);
        sPanel.add((Component)this.startDate, "West");
        this.endDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        this.endDate.setColumns(30);
        sPanel.add((Component)this.endDate, "East");
        panel.add(sPanel);
        SpringUtilities.makeCompactGrid(panel, 4, 2, 5, 2, 2, 2);
        return panel;
    }

    @Override
    protected void setSpecialEnabled(boolean enabled) {
        this.letterNumber.setEditable(enabled);
        this.letterFilterAreaRelationEnabled.setEnabled(enabled);
        this.areaSelectionAction.setEnabled(enabled && this.letterFilterAreaRelationEnabled.isSelected());
        this.letterDeliveryType.setEnabled(enabled);
        this.startDate.setEditable(enabled);
        this.endDate.setEditable(enabled);
    }

    @Override
    protected void setSpecialFilterValues(ModelObjectFilter<LetterFilterModel> modelObjectFilter) {
        if (modelObjectFilter == null) {
            this.letterNumber.setText("");
            this.letterFilterAreaRelationEnabled.setSelected(false);
            this.letterFilterAreaRelationModels = Collections.emptyList();
            this.letterDeliveryType.setSelectedIndex(0);
            this.startDate.setValue(null);
            this.endDate.setValue(null);
        } else {
            LetterFilterModel letterFilterModel = (LetterFilterModel)modelObjectFilter.getAttachedObject();
            String letterNumber = letterFilterModel.getLetterNumber();
            this.letterNumber.setText(letterNumber == null ? "" : letterNumber);
            Boolean letterFilterAreaEnabled = letterFilterModel.getLetterFilterAreaEnabled();
            this.letterFilterAreaRelationEnabled.setSelected(letterFilterAreaEnabled != null && letterFilterAreaEnabled != false);
            this.letterFilterAreaRelationModels = new ArrayList<LetterFilterAreaRelationModel>(letterFilterModel.countLetterFilterAreaRelation());
            for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : letterFilterModel.iterableLetterFilterAreaRelation()) {
                this.letterFilterAreaRelationModels.add(letterFilterAreaRelationModel);
            }
        }
    }

    private class LetterFilterAreaRelationActionListener
    implements ActionListener {
        private LetterFilterAreaRelationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LetterFilterPane.this.setSpecialEnabled(LetterFilterPane.this.isEnabled());
        }
    }

    private class AreaSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 702941251827464621L;

        private AreaSelectionAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaSelection", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog = new MultiAreaObjectSelectionDialog(LetterFilterPane.this.getParentWindow(), LetterFilterPane.this.getModelEnviroment(), new MultiAreaObjectSelectionDialog.CallBack(){

                @Override
                public void doOnOk(MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog) {
                    Collection<AreaObjectModel> areaObjectModels = multiAreaObjectSelectionDialog.getSelectedAreaObjects();
                    LetterFilterPane.this.letterFilterAreaRelationModels = new ArrayList(areaObjectModels.size());
                    for (AreaObjectModel areaObjectModel : areaObjectModels) {
                        LetterFilterAreaRelationModelImpl letterFilterAreaRelationModel = new LetterFilterAreaRelationModelImpl();
                        letterFilterAreaRelationModel.setAreaObject(areaObjectModel);
                        LetterFilterPane.this.letterFilterAreaRelationModels.add(letterFilterAreaRelationModel);
                    }
                }

                @Override
                public void doOnCancel(MultiAreaObjectSelectionDialog multiAreaObjectSelectionDialog) {
                }
            });
            ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(LetterFilterPane.this.letterFilterAreaRelationModels.size());
            for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : LetterFilterPane.this.letterFilterAreaRelationModels) {
                list.add(letterFilterAreaRelationModel.getAreaObject());
            }
            multiAreaObjectSelectionDialog.setSelectedAreaObjects(list);
            multiAreaObjectSelectionDialog.setVisible(true);
        }
    }
}

