/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractFilterComboBox<T extends Model>
extends JComboBox
implements TableCellRenderer {
    private static final long serialVersionUID = -2779949467903434102L;
    private ModelEnviroment modelEnviroment;

    public AbstractFilterComboBox(ModelEnviroment modelEnviroment) {
        super(new DefaultComboBoxModel());
        this.modelEnviroment = modelEnviroment;
        this.fillValues();
    }

    protected void fillValues() {
        Collection<ModelObjectFilter<T>> filterModels = this.fetchFilters();
        DefaultComboBoxModel dlm = (DefaultComboBoxModel)this.getModel();
        dlm.addElement("");
        for (ModelObjectFilter<T> filterModel : filterModels) {
            dlm.addElement(filterModel);
        }
    }

    protected abstract Collection<ModelObjectFilter<T>> fetchFilters();

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public ModelObjectFilter<T> getSelectedFilter() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == 0) {
            return null;
        }
        return (ModelObjectFilter)this.getSelectedItem();
    }

    public void setSelectedFilter(ObjectFilter<T, AttributeValueFilterModel> filter) {
        this.setSelectedIndex(0);
        if (filter != null) {
            DefaultComboBoxModel dlm = (DefaultComboBoxModel)this.getModel();
            for (int i = 1; i < dlm.getSize(); ++i) {
                ModelObjectFilter filterListItem = (ModelObjectFilter)dlm.getElementAt(i);
                if (!((Model)filter.getAttachedObject()).equals(filterListItem.getAttachedObject())) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setSelectedItem(value);
        return this;
    }

    public class CellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public CellEditor() {
            super(AbstractFilterComboBox.this);
        }
    }
}

