/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.exception;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import org.ktde.swing.ButtonBox;

public class StaleStateExceptionDialog
extends JDialog {
    private static final long serialVersionUID = 9101082089434483739L;
    private StaleStateException throwable;
    private JCheckBox showStack;

    public StaleStateExceptionDialog(Window parent, StaleStateException throwable) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.throwable = throwable;
        this.getContentPane().setLayout(new SpringLayout());
        this.buildLayout(false);
        this.pack();
        SwingUtils.center((Window)this, parent);
    }

    private void buildLayout(boolean showStackBoolean) {
        try {
            this.setIconImage(ImageIO.read(StaleStateExceptionDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Container mainPanel = this.getContentPane();
        mainPanel.removeAll();
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.staleStateException.message", new Serializable[0]));
        mainPanel.add(label);
        this.showStack = new JCheckBox("Details", showStackBoolean);
        mainPanel.add(this.showStack);
        this.showStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaleStateExceptionDialog.this.changeStackTraceView();
            }
        });
        if (showStackBoolean) {
            mainPanel.add(this.createStackTraceArea());
        }
        JButton button = new JButton(new AbstractAction("Ok"){
            private static final long serialVersionUID = 1117777171675787686L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StaleStateExceptionDialog.this.doOk();
            }
        });
        ButtonBox buttonBox = new ButtonBox();
        buttonBox.add(button);
        mainPanel.add(buttonBox);
        SpringUtilities.makeCompactGrid(mainPanel, 3 + (showStackBoolean ? 1 : 0), 1, 5, 5, 2, 2);
    }

    private JComponent createStackTraceArea() {
        Long persistentVersion = this.throwable.getPersistentVersion();
        JTextArea text = new JTextArea(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.staleStateException", new Serializable[]{this.throwable.getName(), this.throwable.getId(), persistentVersion == null ? "N/A" : persistentVersion, this.throwable.getCalledVersion()}));
        text.setEditable(false);
        return new JScrollPane(text);
    }

    private void changeStackTraceView() {
        boolean showStackBoolean = this.showStack != null && this.showStack.isSelected();
        this.buildLayout(showStackBoolean);
        int width = this.getWidth();
        int height = this.getHeight();
        this.pack();
        if (showStackBoolean) {
            int newHeight = this.getHeight();
            this.setSize(width, Math.min(newHeight, height * 3));
        }
        this.repaint(1L);
    }

    protected void doOk() {
        this.dispose();
    }
}

