/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer.agency;

import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.offer.AgencyModelImpl;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AgencyPane
extends JPanel {
    private static final long serialVersionUID = -8112151922312135730L;
    private JTextField agencyNumber;
    private JTextField agencyName;
    private AddressPane addressPane;
    private JList agencyList;
    private AddAction addAction;
    private RemoveAction removeAction;
    private ModelEnviroment modelEnviroment;
    private AgencyModel lastSelected;
    private List<Boolean> agencyDeleteable = new LinkedList<Boolean>();

    public AgencyPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        Collection<AgencyModel> agencies = this.modelEnviroment.getAllCaller().getBaseCaller().getAllAgencies();
        DefaultListModel dlm = (DefaultListModel)this.agencyList.getModel();
        for (AgencyModel agency : agencies) {
            dlm.addElement(agency);
            boolean deletable = this.modelEnviroment.getAllCaller().getBaseCaller().isAgencyDeletable(agency);
            this.agencyDeleteable.add(deletable);
        }
    }

    private void buildLayout() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.agencyList = new JList(new DefaultListModel());
        this.agencyList.setCellRenderer(new AgencyRenderer(this.agencyList.getCellRenderer()));
        this.agencyList.setSelectionMode(0);
        this.agencyList.addListSelectionListener(new AgencyListSelectionListener());
        listPanel.add((Component)new JScrollPane(this.agencyList), "Center");
        JPanel listButtonPanel = new JPanel(new BorderLayout());
        this.addAction = new AddAction();
        listButtonPanel.add((Component)new JButton(this.addAction), "East");
        this.removeAction = new RemoveAction();
        this.removeAction.setEnabled(false);
        listButtonPanel.add((Component)new JButton(this.removeAction), "West");
        listPanel.add((Component)listButtonPanel, "South");
        listPanel.setPreferredSize(new Dimension(200, 500));
        this.add((Component)listPanel, "Center");
        JPanel dataPanel = new JPanel(new SpringLayout());
        dataPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.agency.agencyNumber", new Serializable[0])));
        this.agencyNumber = new JTextField(20);
        dataPanel.add(this.agencyNumber);
        dataPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.agency.agencyName", new Serializable[0])));
        this.agencyName = new JTextField(20);
        dataPanel.add(this.agencyName);
        dataPanel.add(new JLabel(""));
        this.addressPane = new AddressPane(this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        dataPanel.add(this.addressPane);
        SpringUtilities.makeCompactGrid(dataPanel, 3, 2, 5, 5, 2, 2);
        JPanel sDataPanel = new JPanel(new BorderLayout());
        sDataPanel.add((Component)dataPanel, "North");
        this.add((Component)sDataPanel, "East");
    }

    public void close() {
        this.adaptCurrentValues();
    }

    private void adaptCurrentValues() {
        if (this.lastSelected != null) {
            ImportedLocationModel importedLocation;
            this.lastSelected.setAgencyNumber(this.agencyNumber.getText());
            this.lastSelected.setName(this.agencyName.getText());
            LocationModel location = this.lastSelected.getLocation();
            if (location == null) {
                location = new LocationModelImpl();
                this.lastSelected.setLocation(location);
            }
            if ((importedLocation = location.getImportedLocation()) == null) {
                importedLocation = new ImportedLocationModelImpl();
                location.setImportedLocation(importedLocation);
            }
            importedLocation.setCountry(this.addressPane.getCountry());
            importedLocation.setPostcode(this.addressPane.getPostcode());
            importedLocation.setCity(this.addressPane.getCity());
            importedLocation.setDistrict(this.addressPane.getDistrict());
            importedLocation.setStreet(this.addressPane.getStreet());
            importedLocation.setHousenumber(this.addressPane.getHousenumber());
            importedLocation.setHousenumberExtension(this.addressPane.getHousenumberExtension());
        }
    }

    private class AgencyListSelectionListener
    implements ListSelectionListener {
        private AgencyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AgencyPane.this.adaptCurrentValues();
            AgencyModel agencyModel = (AgencyModel)AgencyPane.this.agencyList.getSelectedValue();
            if (agencyModel == null) {
                AgencyPane.this.agencyName.setText("");
                AgencyPane.this.agencyName.setEditable(false);
                AgencyPane.this.agencyNumber.setText("");
                AgencyPane.this.agencyNumber.setEditable(false);
                AgencyPane.this.removeAction.setEnabled(false);
                AgencyPane.this.addressPane.setEnabled(false);
            } else {
                AgencyPane.this.agencyName.setText(agencyModel.getName());
                AgencyPane.this.agencyName.setEditable(true);
                AgencyPane.this.agencyNumber.setText(agencyModel.getAgencyNumber());
                AgencyPane.this.agencyNumber.setEditable(agencyModel.getId() == null);
                int index = AgencyPane.this.agencyList.getSelectedIndex();
                AgencyPane.this.removeAction.setEnabled((Boolean)AgencyPane.this.agencyDeleteable.get(index));
                AgencyPane.this.addressPane.setEnabled(true);
                LocationModel locationModel = agencyModel.getLocation();
                AgencyPane.this.addressPane.setLocation(locationModel);
            }
            AgencyPane.this.lastSelected = agencyModel;
        }
    }

    private class AgencyRenderer
    extends AbstractStringListCellRenderer {
        public AgencyRenderer(ListCellRenderer listCellRenderer) {
            super(listCellRenderer);
        }

        @Override
        protected String getString(Object value) {
            if (value instanceof AgencyModel) {
                AgencyModel agencyModel = (AgencyModel)value;
                return agencyModel.getAgencyNumber() + " - " + agencyModel.getName();
            }
            return value == null ? "" : value.toString();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 5328910570753774908L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgencyModel agencyModel = (AgencyModel)AgencyPane.this.agencyList.getSelectedValue();
            if (agencyModel != null) {
                int index = AgencyPane.this.agencyList.getSelectedIndex();
                DefaultListModel dlm = (DefaultListModel)AgencyPane.this.agencyList.getModel();
                dlm.removeElement(agencyModel);
                AgencyPane.this.agencyDeleteable.remove(index);
                agencyModel.delete();
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -2844946265286347163L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgencyModelImpl agencyModel = new AgencyModelImpl();
            agencyModel.setAgencyNumber("?");
            agencyModel.setName("");
            DefaultListModel dlm = (DefaultListModel)AgencyPane.this.agencyList.getModel();
            dlm.addElement(agencyModel);
            AgencyPane.this.agencyDeleteable.add(true);
            AgencyPane.this.agencyList.setSelectedValue(agencyModel, true);
        }
    }
}

