/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.customer.CustomerSearchParameterPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModel;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModelImpl;
import de.datomino.peppergis.client.model.base.CustomerMailContactModel;
import de.datomino.peppergis.client.model.base.CustomerMailContactModelImpl;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModel;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModelImpl;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.dto.lucene.CustomerSearchDto;
import de.datomino.peppergis.dto.lucene.LocationSearchDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.Salutation;
import de.datomino.peppergis.util.offer.OfferSharedUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.util.StringUtil;

public class CustomerSearchPane
extends JPanel {
    private static final long serialVersionUID = 2122663098467876366L;
    private CustomerSearchParameterPane customerSearchParameterPane;
    private JList resultList;
    private ModelEnviroment modelEnviroment;
    private CustomerModel selectedCustomerModel;
    private boolean offersEnabled;

    public CustomerSearchPane(ModelEnviroment modelEnviroment, boolean saveable) {
        this(modelEnviroment, saveable, false);
    }

    public CustomerSearchPane(ModelEnviroment modelEnviroment, boolean saveable, boolean offersEnabled) {
        super(new BorderLayout());
        this.offersEnabled = offersEnabled;
        this.modelEnviroment = modelEnviroment;
        this.customerSearchParameterPane = new CustomerSearchParameterPane(modelEnviroment, offersEnabled);
        this.buildLayout(saveable);
    }

    private void buildLayout(boolean saveable) {
        this.add((Component)this.customerSearchParameterPane, "North");
        JPanel resultPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel2 = new JPanel(new SpringLayout());
        buttonPanel2.add(new JButton(new ClearAction()));
        if (saveable) {
            buttonPanel2.add(new JButton(new SaveAction(false)));
            buttonPanel2.add(new JButton(new SaveAction(true)));
        }
        buttonPanel2.add(new JButton(new SearchAction(false)));
        if (this.offersEnabled) {
            JButton button = new JButton(new SearchAction(true));
            button.setForeground(Color.MAGENTA);
            buttonPanel2.add(button);
        }
        SpringUtilities.makeCompactGrid(buttonPanel2, 1, 2 + (saveable ? 2 : 0) + (this.offersEnabled ? 1 : 0), 2, 2, 2, 2);
        buttonPanel.add((Component)buttonPanel2, "West");
        resultPanel.add((Component)buttonPanel, "North");
        this.resultList = new JList(new DefaultListModel());
        this.resultList.setSelectionMode(0);
        this.resultList.addListSelectionListener(new ResultListSelectionListener());
        this.resultList.setCellRenderer(new ResultListRenderer());
        resultPanel.add((Component)new JScrollPane(this.resultList), "Center");
        this.add((Component)resultPanel, "Center");
    }

    private boolean confirmIfExisting() {
        CustomerModel customer = this.isCustomerWithNameAndAddressExisting();
        if (customer != null) {
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), "Es existiert bereits ein Kunde mit dem gleichen Namen/Adresse (" + customer.getCustomerNumber() + " - " + customer.getBusinessPartnerNumber() + "). Trotzdem neuen Kunden anlegen?", "Frage", 2, 2);
            return d == 0;
        }
        return true;
    }

    private CustomerModel isCustomerWithNameAndAddressExisting() {
        List<CustomerModel> customers;
        CustomerSearchDto customerSearchDto = new CustomerSearchDto();
        String companyName = this.customerSearchParameterPane.getCompanyName();
        String lastName = this.customerSearchParameterPane.getLastName();
        String firstName = this.customerSearchParameterPane.getFirstName();
        customerSearchDto.setCompanyName(companyName);
        customerSearchDto.setLastName(lastName);
        customerSearchDto.setFirstName(firstName);
        AddressPane addressPane = this.customerSearchParameterPane.getAddressPane();
        String city = null;
        Country country = null;
        String district = null;
        Integer housenumber = null;
        String housenumberExtension = null;
        String postcode = null;
        String street = null;
        if (addressPane != null) {
            city = addressPane.getCity();
            country = addressPane.getCountry();
            district = addressPane.getDistrict();
            housenumber = addressPane.getHousenumber();
            housenumberExtension = addressPane.getHousenumberExtension();
            postcode = addressPane.getPostcode();
            street = addressPane.getStreet();
            LocationSearchDto locationSearchDto = new LocationSearchDto();
            locationSearchDto.setCity(city);
            locationSearchDto.setCountry(country);
            locationSearchDto.setDistrict(district);
            locationSearchDto.setHousenumber(housenumber);
            locationSearchDto.setHousenumberExtension(housenumberExtension);
            locationSearchDto.setPostcode(postcode);
            locationSearchDto.setStreet(street);
            customerSearchDto.setLocationSearchDto(locationSearchDto);
        }
        return (customers = this.modelEnviroment.getAllCaller().getCustomerSearchCaller().searchOfferCustomersExact(customerSearchDto, 1)).isEmpty() ? null : customers.get(0);
    }

    public boolean checkCustomerValues() {
        String city;
        String street;
        AddressPane addressPane;
        String postcode;
        Salutation salutation = this.customerSearchParameterPane.getSalutation();
        if (salutation == null) {
            return false;
        }
        String customerNumber = this.customerSearchParameterPane.getCustomerNumber().trim();
        String companyName = this.customerSearchParameterPane.getCompanyName();
        String lastName = this.customerSearchParameterPane.getLastName();
        String phone = this.customerSearchParameterPane.getPhone();
        if (StringUtil.isAtLeastOneBlank(customerNumber, phone, postcode = (addressPane = this.customerSearchParameterPane.getAddressPane()).getPostcode(), street = addressPane.getStreet(), city = addressPane.getCity())) {
            return false;
        }
        if (StringUtil.isBlank(companyName) && StringUtil.isBlank(lastName)) {
            return false;
        }
        Integer housenumber = addressPane.getHousenumber();
        return housenumber != null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.resultList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.resultList.removeListSelectionListener(listener);
    }

    public CustomerModel getSelectedCustomerModel() {
        return this.selectedCustomerModel;
    }

    public String getOfferNumber() {
        return this.customerSearchParameterPane.getOfferNumber();
    }

    public CustomerSearchParameterPane getCustomerSearchParameterPane() {
        return this.customerSearchParameterPane;
    }

    public OfferModel getSelectedOffer() {
        Object selectedValue = this.resultList.getSelectedValue();
        if (selectedValue instanceof OfferModel) {
            return (OfferModel)selectedValue;
        }
        return null;
    }

    public CustomerModel getAdaptedCustomer(boolean newCustomer) {
        CustomerMailContactModel mailModel;
        CustomerPhoneContactModel phoneModel;
        CustomerFaxContactModel faxModel;
        CustomerModel customer;
        String customerNumber = this.customerSearchParameterPane.getCustomerNumber().trim();
        customerNumber = OfferSharedUtil.addPrefix(customerNumber);
        Collection<CustomerModel> customers = this.modelEnviroment.getAllCaller().getCustomerSearchCaller().getCustomerByNumber(customerNumber);
        if (customers.isEmpty()) {
            customer = new CustomerModelImpl();
        } else if (newCustomer) {
            customerNumber = this.modelEnviroment.getAllCaller().getBaseCaller().getNextCustomerNumber();
            customer = new CustomerModelImpl();
        } else {
            customer = customers.iterator().next();
        }
        customer.setCustomerNumber(customerNumber);
        customer.setAgency(this.customerSearchParameterPane.getAgency());
        String companyName = this.customerSearchParameterPane.getCompanyName();
        if (StringUtil.isBlank(companyName)) {
            customer.setCompany(false);
            customer.setName((this.customerSearchParameterPane.getFirstName() + " " + customer.getLastName()).trim());
        } else {
            customer.setCompany(true);
            customer.setName(companyName);
        }
        customer.setFirstName(this.customerSearchParameterPane.getFirstName());
        customer.setLastName(this.customerSearchParameterPane.getLastName());
        customer.setSalutation(this.customerSearchParameterPane.getSalutation());
        customer.setCompanyName(companyName);
        String businessPartnerNumber = this.customerSearchParameterPane.getBusinessPartnerNumber();
        if (StringUtil.isBlank(businessPartnerNumber)) {
            businessPartnerNumber = OfferSharedUtil.removePrefix(customerNumber);
        }
        customer.setBusinessPartnerNumber(businessPartnerNumber);
        LocationModelImpl locationModel = new LocationModelImpl();
        ImportedLocationModelImpl importedLocation = new ImportedLocationModelImpl();
        importedLocation.setGeoLocation(ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(0.0, 0.0)));
        AddressPane addressPane = this.customerSearchParameterPane.getAddressPane();
        importedLocation.setCity(addressPane.getCity());
        Country country = addressPane.getCountry();
        if (country == null) {
            country = this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry();
        }
        importedLocation.setCountry(country);
        importedLocation.setDistrict(addressPane.getDistrict());
        importedLocation.setHousenumber(addressPane.getHousenumber());
        importedLocation.setHousenumberExtension(addressPane.getHousenumberExtension());
        importedLocation.setInformation("");
        importedLocation.setPostcode(addressPane.getPostcode());
        importedLocation.setStreet(addressPane.getStreet());
        locationModel.setImportedLocation(importedLocation);
        customer.setDefaultLocation(locationModel);
        if (customer.isFaxContactsEmpty()) {
            faxModel = new CustomerFaxContactModelImpl();
            customer.addFaxContact(faxModel);
        } else {
            faxModel = customer.iterateFaxContacts().next();
        }
        faxModel.setCustomerOrder(0);
        faxModel.setFaxNumber(this.customerSearchParameterPane.getFax());
        faxModel.setFirstName("");
        faxModel.setLastName("");
        if (customer.isPhoneContactsEmpty()) {
            phoneModel = new CustomerPhoneContactModelImpl();
            customer.addPhoneContact(phoneModel);
        } else {
            phoneModel = customer.iteratePhoneContacts().next();
        }
        phoneModel.setCustomerOrder(0);
        phoneModel.setPhoneNumber(this.customerSearchParameterPane.getPhone());
        phoneModel.setFirstName("");
        phoneModel.setLastName("");
        if (customer.isMailContactsEmpty()) {
            mailModel = new CustomerMailContactModelImpl();
            customer.addMailContact(mailModel);
        } else {
            mailModel = customer.iterateMailContacts().next();
        }
        mailModel.setCustomerOrder(0);
        mailModel.setEmail(this.customerSearchParameterPane.getEmail());
        mailModel.setFirstName("");
        mailModel.setLastName("");
        return customer;
    }

    private class ResultListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -1047849377420651521L;

        private ResultListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StringBuilder sb = new StringBuilder();
            if (value instanceof CustomerModel) {
                CustomerModel customerModel = (CustomerModel)value;
                sb.append(StringUtil.nullToFallback(OfferSharedUtil.removePrefix(customerModel.getCustomerNumber()), "?")).append(" - ");
                Boolean isCompany = customerModel.getCompany();
                if (isCompany == null) {
                    isCompany = false;
                }
                if (isCompany.booleanValue()) {
                    sb.append(StringUtil.nullToFallback(customerModel.getCompanyName(), "?"));
                } else {
                    sb.append((StringUtil.nullToEmpty(customerModel.getTitle()) + " " + StringUtil.nullToEmpty(customerModel.getFirstName()) + " " + customerModel.getLastName()).trim());
                }
            } else if (value instanceof OfferModel) {
                Date creationTime;
                OfferModel offerModel = (OfferModel)value;
                sb.append(offerModel.getOfferNumber());
                CustomerModel customer = offerModel.getCustomer();
                if (customer != null) {
                    String lastName;
                    String companyName = customer.getCompanyName();
                    if (!StringUtil.isBlank(companyName)) {
                        sb.append(" - ").append(companyName);
                    }
                    if (!StringUtil.isBlank(lastName = customer.getLastName())) {
                        sb.append(" - ").append(lastName);
                    }
                }
                if ((creationTime = offerModel.getCreationTime()) != null) {
                    sb.append(" - ").append(new SimpleDateFormat("yyyyMMdd").format(creationTime));
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
        }
    }

    private class ResultListSelectionListener
    implements ListSelectionListener {
        private ResultListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object selectedValue = CustomerSearchPane.this.resultList.getSelectedValue();
            CustomerModel customerModel = null;
            if (selectedValue instanceof CustomerModel) {
                customerModel = (CustomerModel)selectedValue;
            } else if (selectedValue instanceof OfferModel) {
                OfferModel offer = (OfferModel)selectedValue;
                customerModel = offer.getCustomer();
            }
            CustomerSearchPane.this.selectedCustomerModel = customerModel;
            if (customerModel != null) {
                CustomerSearchPane.this.customerSearchParameterPane.setCustomerModel(customerModel);
            }
        }
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -1479996892389284352L;
        private boolean offer;

        private SearchAction(boolean offer) {
            super(offer ? "Auftrag suchen" : "Kunde suchen");
            this.offer = offer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String offerNumber = CustomerSearchPane.this.customerSearchParameterPane.getOfferNumber();
            String companyName = CustomerSearchPane.this.customerSearchParameterPane.getCompanyName();
            String firstName = CustomerSearchPane.this.customerSearchParameterPane.getFirstName();
            String lastName = CustomerSearchPane.this.customerSearchParameterPane.getLastName();
            if (this.offer && CustomerSearchPane.this.offersEnabled) {
                Collection<OfferModel> offers = CustomerSearchPane.this.modelEnviroment.getAllCaller().getOfferCaller().searchOfferBy(offerNumber, companyName, firstName, lastName);
                DefaultListModel dlm = (DefaultListModel)CustomerSearchPane.this.resultList.getModel();
                dlm.clear();
                for (OfferModel offer : offers) {
                    dlm.addElement(offer);
                }
            } else {
                String email = CustomerSearchPane.this.customerSearchParameterPane.getEmail();
                String fax = CustomerSearchPane.this.customerSearchParameterPane.getFax();
                String phone = CustomerSearchPane.this.customerSearchParameterPane.getPhone();
                Salutation salutation = CustomerSearchPane.this.customerSearchParameterPane.getSalutation();
                String agencyName = CustomerSearchPane.this.customerSearchParameterPane.getAgencyName();
                String agencyNumber = CustomerSearchPane.this.customerSearchParameterPane.getAgencyNumber();
                String businessPartnerNumber = CustomerSearchPane.this.customerSearchParameterPane.getBusinessPartnerNumber();
                AddressPane addressPane = CustomerSearchPane.this.customerSearchParameterPane.getAddressPane();
                String city = null;
                Country country = null;
                String district = null;
                Integer housenumber = null;
                String housenumberExtension = null;
                String postcode = null;
                String street = null;
                if (addressPane != null) {
                    city = addressPane.getCity();
                    country = addressPane.getCountry();
                    district = addressPane.getDistrict();
                    housenumber = addressPane.getHousenumber();
                    housenumberExtension = addressPane.getHousenumberExtension();
                    postcode = addressPane.getPostcode();
                    street = addressPane.getStreet();
                }
                CustomerSearchDto customerSearchDto = new CustomerSearchDto();
                customerSearchDto.setCompanyName(companyName);
                customerSearchDto.seteMail(email);
                customerSearchDto.setFaxNumber(fax);
                customerSearchDto.setFirstName(firstName);
                customerSearchDto.setLastName(lastName);
                customerSearchDto.setPhoneNumber(phone);
                customerSearchDto.setSalutation(salutation);
                customerSearchDto.setAgencyName(agencyName);
                customerSearchDto.setAgencyNumber(agencyNumber);
                customerSearchDto.setBusinessPartnerNumber(businessPartnerNumber);
                if (!CustomerSearchPane.this.offersEnabled) {
                    customerSearchDto.setOfferNumber(offerNumber);
                }
                if (addressPane != null) {
                    LocationSearchDto locationSearchDto = new LocationSearchDto();
                    locationSearchDto.setCity(city);
                    locationSearchDto.setCountry(country);
                    locationSearchDto.setDistrict(district);
                    locationSearchDto.setHousenumber(housenumber);
                    locationSearchDto.setHousenumberExtension(housenumberExtension);
                    locationSearchDto.setPostcode(postcode);
                    locationSearchDto.setStreet(street);
                    customerSearchDto.setLocationSearchDto(locationSearchDto);
                }
                List<CustomerModel> customers = CustomerSearchPane.this.modelEnviroment.getAllCaller().getCustomerSearchCaller().searchOfferCustomers(customerSearchDto, 10);
                DefaultListModel dlm = (DefaultListModel)CustomerSearchPane.this.resultList.getModel();
                dlm.clear();
                for (CustomerModel customerModel : customers) {
                    dlm.addElement(customerModel);
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 5707160275510343792L;
        private boolean update;

        private SaveAction(boolean update) {
            super(update ? "Kunde aktualisieren" : "Kunde anlegen");
            this.update = update;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomerSearchPane.this.checkCustomerValues()) {
                if (this.update || CustomerSearchPane.this.confirmIfExisting()) {
                    CustomerSearchPane.this.modelEnviroment.getUndoManager().startTransaction();
                    try {
                        CustomerSearchPane.this.getAdaptedCustomer(!this.update);
                        CustomerSearchPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                        try {
                            CustomerSearchPane.this.modelEnviroment.getUndoManager().storeTransactions();
                        }
                        catch (ValidateException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                    catch (Exception ex) {
                        CustomerSearchPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(CustomerSearchPane.this), "Bitte \u00fcberpr\u00fcfen Sie, ob Sie alle mit * gekennzeichneten Felder ausgef\u00fcllt haben", "Fehlende Felder", 2);
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = 4358269673990800217L;

        public ClearAction() {
            super("Leeren");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomerSearchPane.this.customerSearchParameterPane.clearValues();
        }
    }
}

