/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.AgentModel;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.ktde.util.StringUtil;

public class AgentComboBox
extends JComboBox {
    private static final long serialVersionUID = 1553159931209588141L;
    private ModelEnviroment modelEnviroment;
    private boolean allowEmpty;

    public AgentComboBox(ModelEnviroment modelEnviroment, boolean allowEmpty) {
        super(new DefaultComboBoxModel());
        this.modelEnviroment = modelEnviroment;
        this.allowEmpty = allowEmpty;
        this.setRenderer(new AgentRenderer(this.getRenderer()));
        this.loadAgents();
    }

    private void loadAgents() {
        List<AgentModel> agents = this.modelEnviroment.getAllCaller().getOfferCaller().getAllAgents();
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.getModel();
        dcm.removeAllElements();
        if (this.allowEmpty) {
            dcm.addElement(" ");
        }
        for (AgentModel agentModel : agents) {
            dcm.addElement(agentModel);
        }
    }

    @Override
    public AgentModel getSelectedItem() {
        Object object = super.getSelectedItem();
        if (object == null || object instanceof String) {
            return null;
        }
        return (AgentModel)object;
    }

    private class AgentRenderer
    implements ListCellRenderer {
        private ListCellRenderer parent;

        public AgentRenderer(ListCellRenderer parent) {
            this.parent = parent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null || value instanceof String) {
                return this.parent.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            AgentModel agentModel = (AgentModel)value;
            StringBuilder sb = new StringBuilder();
            String agentNumber = agentModel.getAgentNumber();
            boolean numberExists = false;
            if (!StringUtil.isBlank(agentNumber)) {
                sb.append(agentNumber.trim());
                numberExists = true;
            }
            String firstName = agentModel.getFirstName();
            String lastName = agentModel.getLastName();
            String name = firstName.trim() + " " + lastName.trim();
            if (StringUtil.isBlank(name = name.trim())) {
                if (!numberExists) {
                    sb.append("?");
                }
            } else {
                if (numberExists) {
                    sb.append(" - ");
                }
                sb.append(name);
            }
            return this.parent.getListCellRendererComponent(list, sb.toString(), index, isSelected, cellHasFocus);
        }
    }
}

