/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.tree;

import de.datomino.util.collection.Transformer;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.builder.EqualsBuilder;

public final class JTreeUtils {
    private JTreeUtils() {
    }

    public static TreePath findTreePathWithUserObject(JTree tree, Object o) {
        return JTreeUtils.findTreePathWithUserObject(tree, o, new Transformer<Object, Object>(){

            @Override
            public Object transform(Object t) {
                return t;
            }
        });
    }

    private static <T> TreePath findTreePathWithUserObjectRek(DefaultMutableTreeNode dmt, T o, Stack<DefaultMutableTreeNode> stack, Transformer<Object, T> transformer) {
        Object u = dmt.getUserObject();
        T value = transformer.transform(u);
        if (new EqualsBuilder().append(value, o).isEquals()) {
            Object[] path = new Object[stack.size()];
            path = stack.toArray(path);
            return new TreePath(path);
        }
        for (int i = 0; i < dmt.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)dmt.getChildAt(i);
            stack.push(child);
            TreePath tp = JTreeUtils.findTreePathWithUserObjectRek(child, o, stack, transformer);
            if (tp != null) {
                return tp;
            }
            stack.pop();
        }
        return null;
    }

    public static <T> TreePath findTreePathWithUserObject(JTree tree, T o, Transformer<Object, T> transformer) {
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        TreeModel model = tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        stack.push(root);
        return JTreeUtils.findTreePathWithUserObjectRek(root, o, stack, transformer);
    }
}

