/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.table;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

public class MoveInTableAction<T, S>
extends AbstractAction {
    private static final long serialVersionUID = -384774528960133886L;
    private MoveInTableType moveInListType;
    private JTable table;
    private List<S> dataList;

    public MoveInTableAction(String name, MoveInTableType moveInListType, JTable table) {
        super(name);
        this.moveInListType = moveInListType;
        this.table = table;
    }

    public MoveInTableAction(String name, MoveInTableType moveInListType, JTable table, List<S> dataList) {
        this(name, moveInListType, table);
        this.dataList = dataList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int s = this.table.getSelectedRow();
        if (s >= 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
            Object[] row = new Object[dtm.getColumnCount()];
            for (int i = 0; i < dtm.getColumnCount(); ++i) {
                row[i] = dtm.getValueAt(s, i);
            }
            T t = this.doBefore();
            dtm.removeRow(s);
            Object dataObject = null;
            if (this.dataList != null) {
                dataObject = this.dataList.remove(s);
            }
            Integer newIndex = null;
            switch (this.moveInListType) {
                case DOWN: {
                    newIndex = Math.min(s + 1, dtm.getRowCount());
                    dtm.insertRow((int)newIndex, row);
                    if (this.dataList == null) break;
                    this.dataList.add(newIndex, dataObject);
                    break;
                }
                case HIGHEST: {
                    dtm.insertRow(0, row);
                    newIndex = 0;
                    if (this.dataList == null) break;
                    this.dataList.add(0, dataObject);
                    break;
                }
                case LOWEST: {
                    newIndex = dtm.getRowCount();
                    dtm.addRow(row);
                    if (this.dataList == null) break;
                    this.dataList.add(dataObject);
                    break;
                }
                case UP: {
                    newIndex = Math.max(s - 1, 0);
                    dtm.insertRow((int)newIndex, row);
                    if (this.dataList == null) break;
                    this.dataList.add(newIndex, dataObject);
                }
            }
            if (newIndex != null) {
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.clearSelection();
                selectionModel.addSelectionInterval(newIndex, newIndex);
            }
            this.doAfter(t);
        }
    }

    protected T doBefore() {
        return null;
    }

    protected void doAfter(T t) {
    }

    public static enum MoveInTableType {
        UP,
        DOWN,
        HIGHEST,
        LOWEST;

    }
}

