/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class FilteredListSelectorPane<T>
extends JPanel {
    private static final long serialVersionUID = -2532929086847103346L;
    private JTextField search;
    private JList list;
    private List<T> data;
    private boolean emptyItem;

    public FilteredListSelectorPane(List<T> data, boolean emptyItem, int visibleRowCount, int selectionMode) {
        super(new BorderLayout());
        this.buildLayout(visibleRowCount);
        this.list.setSelectionMode(selectionMode);
        this.data = new ArrayList<T>(data);
        this.emptyItem = emptyItem;
        if (emptyItem) {
            this.data.add(0, null);
        }
        DefaultListModel dlm = (DefaultListModel)this.list.getModel();
        for (T t : this.data) {
            dlm.addElement(t);
        }
    }

    public FilteredListSelectorPane(List<T> data, boolean emptyItem, int visibleRowCount) {
        this(data, emptyItem, visibleRowCount, 2);
    }

    public FilteredListSelectorPane(int selectionModel) {
        this(new ArrayList(), false, 10, selectionModel);
    }

    protected abstract String getString(T var1);

    private void buildLayout(int visibleRowCount) {
        this.search = new JTextField(10);
        this.search.getDocument().addDocumentListener(new SearchListener());
        this.add((Component)this.search, "North");
        this.list = new JList(new DefaultListModel());
        this.list.setVisibleRowCount(visibleRowCount);
        this.list.setCellRenderer(new AbstractListCellRenderer<T>(){

            @Override
            protected String getStringFromValue(T t) {
                if (FilteredListSelectorPane.this.emptyItem && t == null) {
                    return " ";
                }
                return FilteredListSelectorPane.this.getString(t);
            }
        });
        this.add(new JScrollPane(this.list));
    }

    private void filter() {
        String f = this.search.getText();
        Pattern pattern = this.createrPattern(f);
        DefaultListModel dlm = (DefaultListModel)this.list.getModel();
        dlm.clear();
        for (T t : this.data) {
            if (!this.isToAdd(t, pattern)) continue;
            dlm.addElement(t);
        }
        this.afterFilter();
    }

    protected void afterFilter() {
    }

    protected boolean isToAdd(T t, Pattern pattern) {
        Matcher matcher = pattern.matcher(this.getString(t).toLowerCase());
        return matcher.matches();
    }

    private Pattern createrPattern(String f) {
        String text = "*" + f + "*";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                sb.append("\\").append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        Pattern pattern = Pattern.compile(sb.toString());
        return pattern;
    }

    public List<T> getSelectedValues(boolean clear) {
        Object[] s = this.list.getSelectedValues();
        ArrayList<Object> selected = new ArrayList<Object>(s.length);
        for (Object o : s) {
            selected.add(o);
        }
        if (this.emptyItem && selected.size() > 1) {
            selected.remove(null);
        }
        if (clear) {
            this.list.clearSelection();
        }
        return selected;
    }

    public void setValues(List<T> ts) {
        this.data.clear();
        if (this.emptyItem) {
            this.data.add(0, null);
        }
        this.data.addAll(ts);
        DefaultListModel dlm = (DefaultListModel)this.list.getModel();
        dlm.clear();
        for (T t : this.data) {
            dlm.addElement(t);
        }
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    private class SearchListener
    implements DocumentListener {
        private SearchListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FilteredListSelectorPane.this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FilteredListSelectorPane.this.filter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FilteredListSelectorPane.this.filter();
        }
    }
}

