/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class EnumItem<T extends Enum<T>> {
    private T t;
    private String name;

    public EnumItem(T t) {
        this.t = t;
    }

    public T getT() {
        return this.t;
    }

    public String toString() {
        if (this.name == null) {
            String key = this.getT().getClass().getName().replace('$', '.') + "." + ((Enum)this.getT()).name();
            this.name = ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]);
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj != null && EnumItem.class.isInstance(obj)) {
            return this.getT() == ((EnumItem)obj).getT();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getT()).toHashCode();
    }

    public static <S extends Enum<S>> List<EnumItem<S>> createEnumItems(Collection<S> enums) {
        ArrayList<EnumItem<S>> list = new ArrayList<EnumItem<S>>(enums.size());
        for (Enum s : enums) {
            list.add(new EnumItem<Enum>(s));
        }
        return list;
    }
}

