/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.international.country.Country;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComboBox;

public class CountryComboBox
extends JComboBox {
    private static final long serialVersionUID = 8030086940378473343L;

    public CountryComboBox(boolean withEmpty, Country preselectedCountry) {
        this(Country.values(), withEmpty, preselectedCountry);
    }

    public CountryComboBox(Country[] countries, boolean withEmpty, Country preselectedCountry) {
        super(CountryComboBox.createItems(countries, withEmpty));
        this.setSelectedItem(preselectedCountry);
        this.setRenderer(new AbstractStringListCellRenderer(this.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value == null || value instanceof String) {
                    return (String)value;
                }
                return ((Country)value).getDisplayName(ModelEnviroment.getMessageResolver().getLocaleString());
            }
        });
    }

    private static Object[] createItems(Country[] countries, boolean withEmpty) {
        Arrays.sort(countries, new Comparator<Country>(){

            @Override
            public int compare(Country o1, Country o2) {
                String n1 = o1.getDisplayName(ModelEnviroment.getMessageResolver().getLocaleString());
                String n2 = o2.getDisplayName(ModelEnviroment.getMessageResolver().getLocaleString());
                return n1.compareTo(n2);
            }
        });
        if (withEmpty) {
            Object[] objects = new Object[1 + countries.length];
            objects[0] = "";
            System.arraycopy(countries, 0, objects, 1, countries.length);
            return objects;
        }
        return countries;
    }

    @Override
    public Country getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return (Country)o;
    }
}

