/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;

public class CommonMultiDialog<C extends CommonDialog>
extends JDialog {
    private static final long serialVersionUID = 2109531960161807732L;
    private List<C> commonDialogs;
    private int currentIndex;

    public CommonMultiDialog(Window parent, String title, Dialog.ModalityType modalityType) {
        super(parent, title, modalityType);
    }

    public CommonMultiDialog(Window parent, String title, Dialog.ModalityType modalityType, List<C> commonDialogs) {
        this(parent, title, modalityType);
        try {
            this.setIconImage(ImageIO.read(CommonMultiDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.commonDialogs = commonDialogs;
    }

    public void showDialog() {
        if (this.commonDialogs == null || this.commonDialogs.isEmpty()) {
            return;
        }
        if (this.currentIndex < 0 || this.currentIndex > this.commonDialogs.size() - 1) {
            this.currentIndex = 0;
        }
        ((CommonDialog)this.commonDialogs.get(this.currentIndex)).setVisible(true);
    }

    private void addControlPanels() {
        int index = 0;
        for (CommonDialog commonDialg : this.commonDialogs) {
            commonDialg.add((Component)this.createControlPanel(index++), "First");
        }
    }

    private JPanel createControlPanel(int index) {
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMultiDialog.this.nextDialog(-1);
            }
        });
        if (index < 1) {
            leftButton.setEnabled(false);
        }
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(index + 1 + "/" + this.commonDialogs.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMultiDialog.this.nextDialog(1);
            }
        });
        if (index > this.commonDialogs.size() - 2) {
            rightButton.setEnabled(false);
        }
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void nextDialog(int step) {
        ((CommonDialog)this.commonDialogs.get(this.currentIndex)).dispose();
        this.currentIndex += step;
        this.showDialog();
    }
}

