/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.util.StringComparator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class CheckBoxPane<T>
extends Box {
    private static final long serialVersionUID = 5103165722050349234L;
    private Map<T, JCheckBox> map;

    public CheckBoxPane(Collection<T> ts, Collection<T> selected, int axis) {
        super(axis);
        this.map = new HashMap<T, JCheckBox>(ts.size());
        this.initialize(ts, selected);
    }

    private void initialize(Collection<T> ts, Collection<T> selected) {
        if (this.selectAll()) {
            final JCheckBox jcb = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.selectAll", new Serializable[0]));
            jcb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckBoxPane.this.map.forEach((k, v) -> v.setSelected(jcb.isSelected()));
                }
            });
            super.add(jcb);
            super.add(new JLabel("-------------------------------"));
        }
        ArrayList<T> list = new ArrayList<T>(ts);
        Collections.sort(list, new StringComparator<T>(true){

            @Override
            protected String getString(T o) {
                return CheckBoxPane.this.getDisplayString(o);
            }
        });
        for (Object t : list) {
            JCheckBox jcb = new JCheckBox(this.getDisplayString(t));
            jcb.setSelected(selected.contains(t));
            jcb.setEnabled(this.isEnabled(t));
            super.add(this.createComponent(t, jcb));
            this.map.put(t, jcb);
        }
    }

    protected String getDisplayString(T t) {
        return t.toString();
    }

    protected Component createComponent(T t, JCheckBox checkBox) {
        return checkBox;
    }

    protected boolean isEnabled(T t) {
        return true;
    }

    protected boolean selectAll() {
        return false;
    }

    public Collection<T> getSelection() {
        HashSet<T> selected = new HashSet<T>();
        for (T t : this.map.keySet()) {
            JCheckBox jcb = this.map.get(t);
            if (!jcb.isSelected()) continue;
            selected.add(t);
        }
        return selected;
    }

    public void setSelection(Collection<T> selected) {
        for (T t : this.map.keySet()) {
            JCheckBox jcb = this.map.get(t);
            jcb.setSelected(selected.contains(t));
        }
        this.repaint(10L);
    }
}

