/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.ktde.swing.ToggleAction;

public class ActionComboBox
extends JComboBox {
    private static final long serialVersionUID = 72224773323418557L;
    private boolean markChecked;
    private Map<ToggleAction, String> specialRenderingNames;

    public ActionComboBox(Collection<? extends ToggleAction> actions2, boolean markChecked) {
        super(new DefaultComboBoxModel());
        this.markChecked = markChecked;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (ToggleAction toggleAction : actions2) {
            model.addElement(toggleAction);
        }
        this.addActionListener(new ComboBoxActionListener());
        this.setRenderer(new ComboBoxActionRenderer());
    }

    public void setSpecialRenderName(ToggleAction action, String string) {
        if (this.specialRenderingNames == null) {
            this.specialRenderingNames = new HashMap<ToggleAction, String>();
        }
        this.specialRenderingNames.put(action, string);
    }

    private class ComboBoxActionRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4885216776454826048L;

        private ComboBoxActionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String specialName;
            Object nValue = value;
            if (ActionComboBox.this.specialRenderingNames != null && (specialName = (String)ActionComboBox.this.specialRenderingNames.get(value)) != null) {
                nValue = specialName;
            }
            if (nValue instanceof ToggleAction) {
                ToggleAction action = (ToggleAction)value;
                String string = action.getValue("Name").toString();
                if (ActionComboBox.this.markChecked && action.isSelected()) {
                    string = "\u2714 " + string;
                }
                nValue = string;
            }
            return super.getListCellRendererComponent((JList<?>)list, nValue, index, isSelected, cellHasFocus);
        }
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = ActionComboBox.this.getSelectedItem();
            if (object instanceof ToggleAction) {
                ToggleAction action = (ToggleAction)object;
                action.actionPerformed(e);
            }
        }
    }
}

