/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractSuggestionBox<T>
extends JComboBox {
    private static final long serialVersionUID = -4586430690274283296L;
    private boolean locked = false;

    public AbstractSuggestionBox() {
        super(new DefaultComboBoxModel());
        this.setEditable(true);
        ((JTextField)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(new SuggestionListener());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                if (!AbstractSuggestionBox.this.locked && e.getStateChange() == 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!AbstractSuggestionBox.this.locked) {
                                AbstractSuggestionBox.this.locked = true;
                                AbstractSuggestionBox.this.setTextOnSelection(e.getItem());
                                AbstractSuggestionBox.this.locked = false;
                            }
                        }
                    });
                }
            }
        });
    }

    private synchronized void changed() {
        final JTextField editorComponent = (JTextField)this.getEditor().getEditorComponent();
        final String value = editorComponent.getText();
        if (!this.locked) {
            this.locked = true;
            final List<T> suggestions = this.getSuggestions(value);
            final DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.getModel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int caret = editorComponent.getCaretPosition();
                    dcm.removeAllElements();
                    for (Object suggestion : suggestions) {
                        dcm.addElement(suggestion);
                    }
                    AbstractSuggestionBox.this.hidePopup();
                    if (!suggestions.isEmpty()) {
                        AbstractSuggestionBox.this.showPopup();
                    }
                    editorComponent.setText(value);
                    editorComponent.setCaretPosition(Math.min(caret, value.length()));
                    AbstractSuggestionBox.this.locked = false;
                }
            });
        }
    }

    protected synchronized void setTextSave(String text) {
        this.locked = true;
        JTextField editorComponent = (JTextField)this.getEditor().getEditorComponent();
        editorComponent.setText(text);
        this.locked = false;
    }

    protected abstract List<T> getSuggestions(String var1);

    protected abstract void setTextOnSelection(Object var1);

    public String getSelectedText() {
        JTextField editorComponent = (JTextField)this.getEditor().getEditorComponent();
        return editorComponent.getText();
    }

    private class SuggestionListener
    implements DocumentListener {
        private SuggestionListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractSuggestionBox.this.changed();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractSuggestionBox.this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractSuggestionBox.this.changed();
        }
    }
}

