/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.model.Model;
import java.awt.Component;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.builder.EqualsBuilder;

public abstract class AbstractModelComboBox<T extends Model>
extends JComboBox {
    private static final long serialVersionUID = 1111758354638552910L;
    private boolean emptyItem;

    public AbstractModelComboBox(Collection<T> models, boolean emptyItem) {
        this.emptyItem = emptyItem;
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setModels(models);
    }

    public void setModels(Iterable<T> models) {
        this.removeAllItems();
        if (this.emptyItem) {
            this.addItem("");
        }
        if (models != null) {
            for (Model t : models) {
                this.addItem(t);
            }
        }
    }

    public AbstractModelComboBox(boolean emptyItem) {
        this(null, emptyItem);
    }

    protected abstract String getStringRepresentation(T var1);

    public T getSelectedItem() {
        Object o = super.getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return (T)((Model)o);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null && this.emptyItem) {
            super.setSelectedIndex(0);
        } else {
            super.setSelectedItem(anObject);
        }
    }

    public void setSelectedItemById(Long id) {
        int index = 0;
        if (id != null) {
            int i;
            ComboBoxModel model = this.getModel();
            int n = i = this.emptyItem ? 1 : 0;
            while (i < model.getSize()) {
                Model m = (Model)model.getElementAt(i);
                if (new EqualsBuilder().append(id, m.getId()).isEquals()) {
                    index = i;
                }
                ++i;
            }
        }
        super.setSelectedIndex(index);
    }

    protected boolean isEmptyItem() {
        return this.emptyItem;
    }

    private class Renderer
    implements ListCellRenderer {
        private ListCellRenderer parent;

        public Renderer(ListCellRenderer parent) {
            this.parent = parent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String string = value == null ? null : (value instanceof String ? value.toString() : AbstractModelComboBox.this.getStringRepresentation((Model)value));
            return this.parent.getListCellRendererComponent(list, string, index, isSelected, cellHasFocus);
        }
    }
}

