/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.blocking;

import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class BusyDialogShowingThread
extends Thread {
    private BusyDialog busyDialog;
    private long millis;
    private String message;
    private boolean interrupted;
    private Window parent;

    public BusyDialogShowingThread(Window parent, long millis, String message) {
        this.parent = parent;
        this.millis = millis;
        this.message = message;
    }

    @Override
    public void run() {
        super.run();
        try {
            Thread.sleep(this.millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.interrupted) {
            this.openDialog();
        }
    }

    public void setMessage(String message) {
        if (this.busyDialog != null) {
            this.busyDialog.setMessage(message, null);
        }
    }

    private void openDialog() {
        if (!this.interrupted && this.busyDialog == null) {
            BufferedImage image;
            try {
                image = ImageIO.read(BusyDialogShowingThread.class.getResourceAsStream("/images/pepper.png"));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.busyDialog = new BusyDialog(this.parent, this.message, image);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BusyDialogShowingThread.this.busyDialog.setVisible(true);
                }
            }).start();
        }
    }

    public void terminate() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.interrupted = true;
        try {
            this.busyDialog.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

