/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class TextSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = -8712470619272452804L;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    public TextSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.TEXT, descriptorModels);
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        simpleAttributeValueFilterModel.setTextValue(this.getAreaField().getText());
    }

    @Override
    protected Component getConstantWidget() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getAreaField());
        }
        return this.scrollPane;
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        String value = simpleAttributeValueFilterModel.getStringValue();
        this.getAreaField().setText(value == null ? "" : value);
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getAreaField().setEditable(b);
    }

    private JTextArea getAreaField() {
        if (this.textArea == null) {
            this.textArea = new JTextArea(5, 30);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){
                private String currentValue = " ";
                private String[] memory = new String[2];
                private byte i = 0;

                @Override
                public void removeUpdate(DocumentEvent e) {
                    try {
                        if (!e.getDocument().getText(0, e.getDocument().getLength()).equals(this.memory[0]) || !this.memory[0].equals(this.memory[1])) {
                            TextSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(TextSimpleAttributeSingleValuePane.this));
                            this.i = (byte)(this.i + 1);
                            this.memory[Math.abs((int)(this.i % 2))] = e.getDocument().getText(0, e.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        if (!this.currentValue.equals(e.getDocument().getText(0, e.getDocument().getLength()))) {
                            this.currentValue = e.getDocument().getText(0, e.getDocument().getLength());
                            TextSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(TextSimpleAttributeSingleValuePane.this));
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        return this.textArea;
    }
}

