/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class StringSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = -8712470619272452804L;
    private JTextField textField;

    public StringSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.STRING, descriptorModels);
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        simpleAttributeValueFilterModel.setStringValue(this.getTextField().getText());
    }

    @Override
    protected Component getConstantWidget() {
        return this.getTextField();
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        String value = simpleAttributeValueFilterModel.getStringValue();
        this.getTextField().setText(value == null ? "" : value);
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getTextField().setEditable(b);
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(30);
            this.textField.getDocument().addDocumentListener(new DocumentListener(){
                private String currentValue = " ";
                private String[] memory = new String[2];
                private byte i = 0;

                @Override
                public void removeUpdate(DocumentEvent e) {
                    try {
                        if (!e.getDocument().getText(0, e.getDocument().getLength()).equals(this.memory[0]) || !this.memory[0].equals(this.memory[1])) {
                            StringSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(StringSimpleAttributeSingleValuePane.this));
                            this.i = (byte)(this.i + 1);
                            this.memory[Math.abs((int)(this.i % 2))] = e.getDocument().getText(0, e.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        if (!this.currentValue.equals(e.getDocument().getText(0, e.getDocument().getLength()))) {
                            this.currentValue = e.getDocument().getText(0, e.getDocument().getLength());
                            StringSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(StringSimpleAttributeSingleValuePane.this));
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        return this.textField;
    }
}

