/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends JPanel {
    private static final long serialVersionUID = 7748317080624846789L;
    private JComboBox refValues;
    private JRadioButton ref;
    private JRadioButton constant;
    private List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    public AbstractSimpleAttributeSingleValuePane(AttributeValueType attributeValueType, Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(new BorderLayout());
        this.initialize(attributeValueType, descriptorModels);
    }

    protected void initialize(AttributeValueType attributeValueType, Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        this.buildLayout();
        this.fillComboBox(attributeValueType, descriptorModels);
    }

    private void fillComboBox(AttributeValueType attributeValueType, Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.refValues.getModel();
        for (AttributeValueDescriptorModel<T, S> attributeValueDescriptorModel : descriptorModels) {
            if (attributeValueDescriptorModel.getAttributeValueType() != attributeValueType) continue;
            dcm.addElement(attributeValueDescriptorModel);
        }
    }

    private void buildLayout() {
        RadioButtonActionListener radioButtonActionListener = new RadioButtonActionListener();
        JPanel upPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new SpringLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.constant = new JRadioButton();
        panel.add(this.constant);
        buttonGroup.add(this.constant);
        panel.add(this.getConstantWidget());
        this.constant.setSelected(true);
        this.constant.addActionListener(radioButtonActionListener);
        this.ref = new JRadioButton();
        panel.add(this.ref);
        buttonGroup.add(this.ref);
        this.refValues = new JComboBox(new DefaultComboBoxModel());
        this.refValues.setEnabled(false);
        panel.add(this.refValues);
        this.ref.addActionListener(radioButtonActionListener);
        this.refValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(AbstractSimpleAttributeSingleValuePane.this));
            }
        });
        SpringUtilities.makeCompactGrid(panel, 2, 2, 2, 2, 2, 2);
        upPanel.add((Component)panel, "North");
        this.add((Component)upPanel, "Center");
    }

    protected abstract Component getConstantWidget();

    private void setEnablings() {
        boolean enabled = this.isEnabled();
        this.ref.setEnabled(enabled);
        this.constant.setEnabled(enabled);
        this.refValues.setEnabled(enabled && this.ref.isSelected());
        this.setConstantWidgetEnabled(enabled && this.constant.isSelected());
    }

    protected abstract void setConstantWidgetEnabled(boolean var1);

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnablings();
    }

    public void setValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        String refKey = simpleAttributeValueFilterModel.getRefKeyValue();
        if (refKey == null) {
            this.setConstantValue(simpleAttributeValueFilterModel);
            this.constant.setSelected(true);
        } else {
            DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.refValues.getModel();
            for (int i = 0; i < dcm.getSize(); ++i) {
                AttributeValueDescriptorModel attributeValueDescriptorModel = (AttributeValueDescriptorModel)dcm.getElementAt(i);
                if (!refKey.equals(attributeValueDescriptorModel.getKey())) continue;
                this.refValues.setSelectedIndex(i);
                this.ref.setSelected(true);
                break;
            }
        }
        this.setEnablings();
    }

    public void adaptValuesToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        String refKey = null;
        if (this.ref.isSelected()) {
            refKey = ((AttributeValueDescriptorModel)this.refValues.getSelectedItem()).getKey();
        }
        simpleAttributeValueFilterModel.setRefKeyValue(refKey);
        if (this.constant.isSelected()) {
            this.adaptConstantValueToModel(simpleAttributeValueFilterModel);
        } else {
            simpleAttributeValueFilterModel.setBooleanValue(null);
            simpleAttributeValueFilterModel.setIntegerValue(null);
            simpleAttributeValueFilterModel.setLongValue(null);
            simpleAttributeValueFilterModel.setStaticChoiceValue(null);
            simpleAttributeValueFilterModel.setStringValue(null);
            simpleAttributeValueFilterModel.setTextValue(null);
        }
    }

    protected abstract void adaptConstantValueToModel(SimpleAttributeValueFilterModel var1);

    protected abstract void setConstantValue(SimpleAttributeValueFilterModel var1);

    public void keyChanged(String key) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(e);
        }
    }

    private class RadioButtonActionListener
    implements ActionListener {
        private RadioButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSimpleAttributeSingleValuePane.this.setEnablings();
            AbstractSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(AbstractSimpleAttributeSingleValuePane.this));
        }
    }
}

