/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute;

import de.datomino.peppergis.client.gui.attribute.AttributeDateSpinnerPanel;
import de.datomino.peppergis.client.gui.attribute.AttributeNumberSpinnerPanel;
import de.datomino.peppergis.client.gui.common.BooleanComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.attribute.AttributeValueDescriptor;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractAttributeValuePane<T extends Model, S extends Model, U extends Model, V extends Model>
extends JPanel {
    private static final long serialVersionUID = -4048530470721346321L;
    private Map<Tupel<String, ComponentType>, JComponent> valueComponentMap;
    private Map<String, AttributeValueModel<S, V, U>> attributeValueMap;
    private Map<String, AttributeValueDescriptorModel<U, V>> descriptorMap;
    private ModelEnviroment modelEnviroment;
    private boolean editable = true;
    private boolean aggregate = false;
    private boolean special = false;

    public AbstractAttributeValuePane(T t, Set<AttributeGroupModel> groups, ModelEnviroment modelEnviroment) {
        this(t, groups, Integer.MAX_VALUE, modelEnviroment);
    }

    public AbstractAttributeValuePane(T t, Set<AttributeGroupModel> groups, ModelEnviroment modelEnviroment, boolean editable) {
        this(t, groups, Integer.MAX_VALUE, modelEnviroment, editable);
    }

    public AbstractAttributeValuePane(T t, Set<AttributeGroupModel> groups, int rowsPerCol, ModelEnviroment modelEnviroment) {
        this(t, groups, rowsPerCol, modelEnviroment, true);
    }

    public AbstractAttributeValuePane(T t, Set<AttributeGroupModel> groups, int rowsPerCol, ModelEnviroment modelEnviroment, boolean editable) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        Collection<AttributeValueDescriptorModel<U, V>> descriptors = this.getAttributeValueDescriptors(t);
        if (groups != null) {
            LinkedList<AttributeValueDescriptorModel<U, V>> filtered = new LinkedList<AttributeValueDescriptorModel<U, V>>();
            for (AttributeValueDescriptorModel<U, V> descriptor : descriptors) {
                AttributeGroupModel attributeGroup = descriptor.getAttributeGroup();
                if (attributeGroup == null || !groups.contains(attributeGroup)) continue;
                filtered.add(descriptor);
            }
            descriptors = filtered;
        }
        this.buildLayout(descriptors, rowsPerCol);
    }

    public AbstractAttributeValuePane(Collection<AttributeValueDescriptorModel<U, V>> descriptors, ModelEnviroment modelEnviroment, boolean editable) {
        this(descriptors, Integer.MAX_VALUE, modelEnviroment, editable);
    }

    public AbstractAttributeValuePane(Collection<AttributeValueDescriptorModel<U, V>> descriptors, int rowsPerCol, ModelEnviroment modelEnviroment, boolean editable) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.buildLayout(descriptors, rowsPerCol);
    }

    public AbstractAttributeValuePane(Collection<AttributeValueDescriptorModel<U, V>> descriptors, int rowsPerCol, ModelEnviroment modelEnviroment, boolean editable, boolean aggregate, boolean special) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.aggregate = aggregate;
        this.special = special;
        this.buildLayout(descriptors, rowsPerCol);
    }

    public AbstractAttributeValuePane(Collection<AttributeValueDescriptorModel<U, V>> descriptors, ModelEnviroment modelEnviroment, boolean editable, boolean aggregate, boolean special) {
        this(descriptors, Integer.MAX_VALUE, modelEnviroment, editable, aggregate, special);
    }

    private void buildLayout(Collection<AttributeValueDescriptorModel<U, V>> descriptors, Integer rowsPerCol) {
        this.valueComponentMap = new HashMap<Tupel<String, ComponentType>, JComponent>();
        this.attributeValueMap = new HashMap<String, AttributeValueModel<S, V, U>>();
        this.descriptorMap = new HashMap<String, AttributeValueDescriptorModel<U, V>>();
        LinkedList<AttributeValueDescriptorModel<U, V>> toShows = new LinkedList<AttributeValueDescriptorModel<U, V>>();
        for (AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel : descriptors) {
            if (!this.isToShow(attributeValueDescriptorModel)) continue;
            toShows.add(attributeValueDescriptorModel);
        }
        WidthUnifier widthUnifier = new WidthUnifier();
        JPanel wrapperPane = new JPanel(new SpringLayout());
        JPanel yetAnotherWrapperPane = new JPanel(new BorderLayout());
        JPanel paneForNormalSizeComponents = new JPanel(new SpringLayout());
        JPanel paneForBigSizeComponents = new JPanel(new SpringLayout());
        LinkedList<Component> normalSizeComponents = new LinkedList<Component>();
        LinkedList<Component> bigSizeComponents = new LinkedList<Component>();
        for (AttributeValueDescriptorModel attributeValueDescriptorModel : toShows) {
            String tKey = attributeValueDescriptorModel.getKey();
            Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(tKey, ComponentType.VALUE);
            this.descriptorMap.put(tKey, attributeValueDescriptorModel);
            boolean editable = attributeValueDescriptorModel.getEditable() != false && this.editable;
            JComponent jComponent = this.addComponentEntry(normalSizeComponents, bigSizeComponents, attributeValueDescriptorModel, editable, this.aggregate || this.special ? " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.manual", new Serializable[0]) : "", widthUnifier);
            this.valueComponentMap.put(key, jComponent);
            if (this.aggregate) {
                key = new Tupel<String, ComponentType>(tKey, ComponentType.AGGREGATE);
                JComponent jComponent2 = this.addComponentEntry(normalSizeComponents, bigSizeComponents, attributeValueDescriptorModel, false, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.aggregate", new Serializable[0]), widthUnifier);
                this.valueComponentMap.put(key, jComponent2);
            }
            if (!this.special) continue;
            key = new Tupel<String, ComponentType>(tKey, ComponentType.SPECIAL);
            JComponent jComponent3 = this.addComponentEntry(normalSizeComponents, bigSizeComponents, attributeValueDescriptorModel, false, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.area.mark", new Serializable[0]), widthUnifier);
            this.valueComponentMap.put(key, jComponent3);
        }
        widthUnifier.unifyWidth();
        int dSize = normalSizeComponents.size() + (this.aggregate ? normalSizeComponents.size() : 0) + (this.special ? normalSizeComponents.size() : 0);
        int n2 = dSize / rowsPerCol + (dSize % rowsPerCol == 0 ? 0 : 1);
        n2 = n2 + n2 % 2;
        int rows = Math.min(rowsPerCol, dSize);
        int emptySize = Math.max(rows, 1) * Math.max(n2, 1);
        for (Component component : normalSizeComponents) {
            paneForNormalSizeComponents.add(component);
        }
        for (int i = normalSizeComponents.size(); i < emptySize; ++i) {
            paneForNormalSizeComponents.add(new JLabel(""));
        }
        for (Component component : bigSizeComponents) {
            paneForBigSizeComponents.add(component);
        }
        if (!normalSizeComponents.isEmpty()) {
            SpringUtilities.makeCompactGrid(paneForNormalSizeComponents, Math.max(rows, 1), Math.max(n2, 1), 5, 5, 4, 2);
        }
        if (!bigSizeComponents.isEmpty()) {
            SpringUtilities.makeCompactGrid(paneForBigSizeComponents, Math.max(bigSizeComponents.size() / 2, 1), 2, 5, 5, 4, 2);
        }
        yetAnotherWrapperPane.add((Component)paneForNormalSizeComponents, "West");
        wrapperPane.add(yetAnotherWrapperPane);
        wrapperPane.add(paneForBigSizeComponents);
        SpringUtilities.makeCompactGrid(wrapperPane, 2, 1, 2, 2, 4, 8);
        this.add((Component)wrapperPane, "North");
    }

    public void setAggregateValue(String tKey, Object value) {
        Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(tKey, ComponentType.AGGREGATE);
        this.setAggregateOrSpecialValue(key, value);
    }

    public void setSpecialValue(String tKey, Object value) {
        Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(tKey, ComponentType.SPECIAL);
        this.setAggregateOrSpecialValue(key, value);
    }

    private void setAggregateOrSpecialValue(Tupel<String, ComponentType> key, Object value) {
        AttributeValueType attributeValueType;
        JComponent component = this.valueComponentMap.get(key);
        AttributeValueDescriptorModel<U, V> attributeValueDescriptor = this.descriptorMap.get(key.getElement1());
        if (component != null && (attributeValueType = attributeValueDescriptor.getAttributeValueType()) != null) {
            switch (attributeValueType) {
                case BOOLEAN: {
                    BooleanComboBox checkBox = (BooleanComboBox)component;
                    Boolean booleanValue = (Boolean)value;
                    checkBox.setSelectedItem(booleanValue);
                    break;
                }
                case DATE: {
                    AttributeDateSpinnerPanel dateField = (AttributeDateSpinnerPanel)component;
                    Long longValue = (Long)value;
                    dateField.setValue(longValue == null ? null : new Date(longValue));
                    break;
                }
                case INTEGER: {
                    AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                    if (value == null) {
                        intField.setValue(null);
                        break;
                    }
                    Integer intValue = (Integer)value;
                    intField.setValue(intValue);
                    break;
                }
                case STATIC_CHOICE: {
                    JComboBox comboBox = (JComboBox)component;
                    StaticChoiceValue staticChoiceValue = (StaticChoiceValue)value;
                    boolean found = false;
                    for (int i = 0; i < comboBox.getItemCount(); ++i) {
                        StaticChoiceValueItem staticChoiceValueItem = (StaticChoiceValueItem)comboBox.getItemAt(i);
                        StaticChoiceValue other = staticChoiceValueItem.getStaticChoiceValue();
                        if ((staticChoiceValue != null || other != null) && (staticChoiceValue == null || other == null || !new EqualsBuilder().append(staticChoiceValue.getValue(), other.getValue()).isEquals())) continue;
                        comboBox.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (found) break;
                    comboBox.setSelectedIndex(0);
                    break;
                }
                case STRING: {
                    JTextField textField = (JTextField)component;
                    String textValue = (String)value;
                    textField.setText(textValue == null ? "" : textValue);
                    break;
                }
                case TEXT: {
                    JTextArea textArea = (JTextArea)component;
                    String textAreaValue = (String)value;
                    textArea.setText(textAreaValue == null ? "" : textAreaValue);
                    break;
                }
                case FLOAT: {
                    AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                    if (value == null) {
                        doubleField.setValue(null);
                        break;
                    }
                    Double doubleValue = (Double)value;
                    doubleField.setValue(doubleValue);
                    break;
                }
                case IMAGE: 
                case PDF_DOWN: {
                    break;
                }
                case MULTIPLE_LIST_CHOICE: {
                    break;
                }
            }
        }
    }

    private JComponent addComponentEntry(Collection<Component> normalSizeComponents, Collection<Component> bigSizeComponents, AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel, boolean editable, String suffix, WidthUnifier widthUnifier) {
        JComboBox toAdd = null;
        JScrollPane bigComponentToAdd = null;
        JComponent component = null;
        switch (attributeValueDescriptorModel.getAttributeValueType()) {
            case BOOLEAN: {
                component = new BooleanComboBox(true);
                ((JComponent)component).setEnabled(editable);
                toAdd = component;
                break;
            }
            case DATE: {
                AttributeDateSpinnerPanel dateSpinner = new AttributeDateSpinnerPanel(new Date());
                dateSpinner.setEnabled(editable);
                component = dateSpinner;
                toAdd = component;
                break;
            }
            case INTEGER: {
                Tupel<Double, Double> limitNumbers1 = this.getAttibuteLimitValues((Model)attributeValueDescriptorModel.getAttachedObject());
                Double value1 = 0.0;
                Double stepSize1 = 1.0;
                if (limitNumbers1.getElement1() != null && value1 < limitNumbers1.getElement1()) {
                    value1 = limitNumbers1.getElement1();
                } else if (limitNumbers1.getElement2() != null && value1 > limitNumbers1.getElement2()) {
                    value1 = limitNumbers1.getElement1();
                }
                AttributeNumberSpinnerPanel spinnerInt = new AttributeNumberSpinnerPanel(value1, limitNumbers1.getElement1(), limitNumbers1.getElement2(), stepSize1);
                spinnerInt.setEnabled(editable);
                component = spinnerInt;
                toAdd = component;
                break;
            }
            case STATIC_CHOICE: {
                component = this.createStaticChoiceComboBox(attributeValueDescriptorModel, editable);
                toAdd = component;
                break;
            }
            case STRING: {
                JTextField textField = new JTextField(10);
                textField.setEditable(editable);
                component = textField;
                toAdd = component;
                break;
            }
            case TEXT: {
                JTextArea textArea = new JTextArea(5, 10);
                if (editable) {
                    textArea.setEditable(true);
                } else {
                    textArea.setEditable(false);
                    textArea.setBackground(new Color(242, 241, 240));
                }
                component = textArea;
                bigComponentToAdd = new JScrollPane(component);
                break;
            }
            case FLOAT: {
                Tupel<Double, Double> limitNumbers2 = this.getAttibuteLimitValues((Model)attributeValueDescriptorModel.getAttachedObject());
                Double value2 = 0.0;
                Double stepSize2 = 1.0;
                if (limitNumbers2.getElement1() != null && value2 < limitNumbers2.getElement1()) {
                    value2 = limitNumbers2.getElement1();
                } else if (limitNumbers2.getElement2() != null && value2 > limitNumbers2.getElement2()) {
                    value2 = limitNumbers2.getElement1();
                }
                AttributeNumberSpinnerPanel spinnerFloat = new AttributeNumberSpinnerPanel(value2, limitNumbers2.getElement1(), limitNumbers2.getElement2(), stepSize2);
                spinnerFloat.setEnabled(editable);
                component = spinnerFloat;
                toAdd = component;
                break;
            }
            case IMAGE: {
                JButton imageButton = new JButton();
                imageButton.setEnabled(false);
                component = imageButton;
                toAdd = component;
                break;
            }
            case MULTIPLE_LIST_CHOICE: {
                break;
            }
            case PDF_DOWN: {
                JButton pdfButton = new JButton();
                pdfButton.setEnabled(false);
                component = pdfButton;
                toAdd = component;
                break;
            }
        }
        JPanel subPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(attributeValueDescriptorModel.getName() + suffix);
        if (toAdd == null) {
            subPanel.add((Component)bigComponentToAdd, "Center");
            label.setVerticalAlignment(1);
            bigSizeComponents.add(label);
            bigSizeComponents.add(subPanel);
        } else {
            subPanel.add((Component)toAdd, "East");
            normalSizeComponents.add(label);
            normalSizeComponents.add(subPanel);
            widthUnifier.add(toAdd);
        }
        return component;
    }

    protected boolean isToShow(AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel) {
        String property = ModelEnviroment.getProperties().getProperty("attributes." + this.getPropertyPrefix() + ".showables");
        if (property == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(property, ",");
        String key = attributeValueDescriptorModel.getKey();
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(key)) continue;
            return true;
        }
        return false;
    }

    protected abstract String getPropertyPrefix();

    private JComboBox createStaticChoiceComboBox(AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel, boolean editable) {
        List staticChoiceValues = attributeValueDescriptorModel.getStaticChoiceValues();
        Vector<StaticChoiceValueItem> vector = new Vector<StaticChoiceValueItem>();
        vector.add(new StaticChoiceValueItem(null));
        for (StaticChoiceValue staticChoiceValue : staticChoiceValues) {
            vector.addElement(new StaticChoiceValueItem(staticChoiceValue));
        }
        JComboBox comboBox = new JComboBox(vector);
        comboBox.setEnabled(attributeValueDescriptorModel.getEditable() != false && editable);
        return comboBox;
    }

    public void fillValues(Collection<S> attributeValues) {
        ArrayList<AttributeValueModel<S, V, U>> attributeValueModels = new ArrayList<AttributeValueModel<S, V, U>>(attributeValues.size());
        for (Model s : attributeValues) {
            attributeValueModels.add(this.getAttributeValueModel(s));
        }
        this.fillValuesInternal(attributeValueModels);
    }

    public void fillValues(T t) {
        Collection<AttributeValueModel<S, V, U>> attributeValues = this.getAttributeValues(t);
        this.fillValuesInternal(attributeValues);
    }

    private void fillValuesInternal(Collection<AttributeValueModel<S, V, U>> attributeValues) {
        this.clearValues(ComponentType.VALUE);
        this.attributeValueMap.clear();
        for (AttributeValueModel<S, V, U> attributeValueModel : attributeValues) {
            AttributeValueType attributeValueType;
            AttributeValueDescriptor attributeValueDescriptor = attributeValueModel.getAttributeValueDescriptor();
            if (attributeValueDescriptor == null) continue;
            String tKey = attributeValueDescriptor.getKey();
            Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(tKey, ComponentType.VALUE);
            this.attributeValueMap.put(tKey, attributeValueModel);
            JComponent component = this.valueComponentMap.get(key);
            if (component == null || (attributeValueType = attributeValueDescriptor.getAttributeValueType()) == null) continue;
            switch (attributeValueType) {
                case BOOLEAN: {
                    BooleanComboBox checkBox = (BooleanComboBox)component;
                    Boolean booleanValue = attributeValueModel.getBooleanValue();
                    checkBox.setSelectedItem(booleanValue);
                    break;
                }
                case DATE: {
                    AttributeDateSpinnerPanel dateField = (AttributeDateSpinnerPanel)component;
                    Long longValue = attributeValueModel.getLongValue();
                    dateField.setValue(longValue == null ? null : new Date(longValue));
                    break;
                }
                case INTEGER: {
                    AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                    Integer intValue = attributeValueModel.getIntegerValue();
                    intField.setValue(intValue);
                    break;
                }
                case STATIC_CHOICE: {
                    JComboBox comboBox = (JComboBox)component;
                    StaticChoiceValue staticChoiceValue = attributeValueModel.getStaticChoiceValue();
                    boolean found = false;
                    for (int i = 0; i < comboBox.getItemCount(); ++i) {
                        StaticChoiceValueItem staticChoiceValueItem = (StaticChoiceValueItem)comboBox.getItemAt(i);
                        StaticChoiceValue other = staticChoiceValueItem.getStaticChoiceValue();
                        if ((staticChoiceValue != null || other != null) && (staticChoiceValue == null || other == null || !new EqualsBuilder().append(staticChoiceValue.getValue(), other.getValue()).isEquals())) continue;
                        comboBox.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (found) break;
                    comboBox.setSelectedIndex(0);
                    break;
                }
                case STRING: {
                    JTextField textField = (JTextField)component;
                    String textValue = attributeValueModel.getStringValue();
                    textField.setText(textValue == null ? "" : textValue);
                    break;
                }
                case TEXT: {
                    JTextArea textArea = (JTextArea)component;
                    String textAreaValue = attributeValueModel.getTextValue();
                    textArea.setText(textAreaValue == null ? "" : textAreaValue);
                    break;
                }
                case FLOAT: {
                    AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                    Double doubleValue = attributeValueModel.getFloatValue();
                    doubleField.setValue(doubleValue);
                    break;
                }
                case IMAGE: {
                    JButton imageButton = (JButton)component;
                    byte[] imageData = this.getImageData(attributeValueModel);
                    if (imageData == null) break;
                    try {
                        final BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageData));
                        Image imgForIcon = img.getScaledInstance(25, 25, 4);
                        ImageIcon imageIcon = new ImageIcon(imgForIcon);
                        imageButton.setIcon(imageIcon);
                        imageButton.setBorderPainted(false);
                        imageButton.setContentAreaFilled(false);
                        imageButton.setEnabled(true);
                        imageButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Image imgForDialog = img.getScaledInstance(img.getWidth(null), img.getHeight(null), 4);
                                ImageIcon iconForDialog = new ImageIcon(imgForDialog);
                                JLabel label = new JLabel("", iconForDialog, 0);
                                JOptionPane.showMessageDialog(AbstractAttributeValuePane.this, label, "Image", -1, null);
                            }
                        });
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case PDF_DOWN: {
                    JButton pdfButton = (JButton)component;
                    final byte[] pdfDate = this.getPdfData(attributeValueModel);
                    if (pdfDate == null) break;
                    try {
                        pdfButton.setBorderPainted(false);
                        pdfButton.setContentAreaFilled(false);
                        pdfButton.setEnabled(true);
                        pdfButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    PdfUtil.showPdf(new ByteArrayInputStream(pdfDate));
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        });
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case MULTIPLE_LIST_CHOICE: {
                    break;
                }
            }
        }
    }

    private byte[] getPdfData(AttributeValueModel<S, V, U> attributeValueModel) {
        byte[] imageValue = null;
        Object modelObject = attributeValueModel.getAttachedObject();
        if (modelObject instanceof AreaAttributeValueModel) {
            AreaAttributeValueModel areaAttributeValueModel = (AreaAttributeValueModel)modelObject;
            imageValue = areaAttributeValueModel.getImageValue();
        } else if (modelObject instanceof ParcelAttributeValueModel) {
            ParcelAttributeValueModel parcelAttributeValueModel = (ParcelAttributeValueModel)modelObject;
            imageValue = parcelAttributeValueModel.getImageValue();
        } else if (modelObject instanceof PoiAttributeValueModel) {
            PoiAttributeValueModel poiAttributeValueModel = (PoiAttributeValueModel)modelObject;
            imageValue = poiAttributeValueModel.getImageValue();
        } else if (modelObject instanceof SubscriptionAttributeValueModel) {
            SubscriptionAttributeValueModel subscriptionAttributeValueModel = (SubscriptionAttributeValueModel)modelObject;
            imageValue = subscriptionAttributeValueModel.getImageValue();
        }
        return imageValue;
    }

    public void adaptValuesToModel(T t) {
        for (AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel : this.descriptorMap.values()) {
            String tKey;
            Tupel<String, ComponentType> key;
            JComponent component;
            if (!attributeValueDescriptorModel.getEditable().booleanValue() || (component = this.valueComponentMap.get(key = new Tupel<String, ComponentType>(tKey = attributeValueDescriptorModel.getKey(), ComponentType.VALUE))) == null) continue;
            AttributeValueModel attributeValueModel = this.attributeValueMap.get(tKey);
            if (attributeValueModel == null) {
                attributeValueModel = this.createAttributeValueModel(t, attributeValueDescriptorModel);
            }
            switch (attributeValueDescriptorModel.getAttributeValueType()) {
                case BOOLEAN: {
                    BooleanComboBox checkBox = (BooleanComboBox)component;
                    attributeValueModel.setBooleanValue(checkBox.getSelectedValue());
                    break;
                }
                case DATE: {
                    AttributeDateSpinnerPanel dateField = (AttributeDateSpinnerPanel)component;
                    Date date = (Date)dateField.getValue();
                    attributeValueModel.setLongValue(date == null ? null : Long.valueOf(date.getTime()));
                    break;
                }
                case INTEGER: {
                    AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                    Number value = (Number)intField.getValue();
                    attributeValueModel.setIntegerValue(value == null ? null : Integer.valueOf(value.intValue()));
                    break;
                }
                case STATIC_CHOICE: {
                    JComboBox comboBox = (JComboBox)component;
                    StaticChoiceValueItem staticChoiceValueItem = (StaticChoiceValueItem)comboBox.getSelectedItem();
                    attributeValueModel.setStaticChoiceValue(staticChoiceValueItem.getStaticChoiceValue());
                    break;
                }
                case STRING: {
                    JTextField textField = (JTextField)component;
                    attributeValueModel.setStringValue(textField.getText());
                    break;
                }
                case TEXT: {
                    JTextArea textArea = (JTextArea)component;
                    attributeValueModel.setTextValue(textArea.getText());
                    break;
                }
                case FLOAT: {
                    AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                    Number doubleValue = (Number)doubleField.getValue();
                    attributeValueModel.setFloatValue(doubleValue == null ? null : Double.valueOf(doubleValue.doubleValue()));
                    break;
                }
                case MULTIPLE_LIST_CHOICE: {
                    break;
                }
            }
        }
    }

    private Tupel<Double, Double> getAttibuteLimitValues(U attDescriptor) {
        Tupel<Object, Object> limitNumbers = new Tupel<Object, Object>(null, null);
        Double lowerLimit = null;
        Double upperLimit = null;
        if (attDescriptor != null) {
            if (attDescriptor instanceof AreaAttributeValueDescriptorModel) {
                AreaAttributeValueDescriptorModel areaAttributeDescriptor = (AreaAttributeValueDescriptorModel)attDescriptor;
                lowerLimit = areaAttributeDescriptor.getLowerLimit();
                upperLimit = areaAttributeDescriptor.getUpperLimit();
            } else if (attDescriptor instanceof SubscriptionAttributeValueDescriptorModel) {
                SubscriptionAttributeValueDescriptorModel subAttributeDescriptor = (SubscriptionAttributeValueDescriptorModel)attDescriptor;
                lowerLimit = subAttributeDescriptor.getLowerLimit();
                upperLimit = subAttributeDescriptor.getUpperLimit();
            } else if (attDescriptor instanceof PoiAttributeValueDescriptorModel) {
                PoiAttributeValueDescriptorModel poiAttributeDescriptor = (PoiAttributeValueDescriptorModel)attDescriptor;
                lowerLimit = poiAttributeDescriptor.getLowerLimit();
                upperLimit = poiAttributeDescriptor.getUpperLimit();
            } else if (attDescriptor instanceof ParcelAttributeValueDescriptorModel) {
                ParcelAttributeValueDescriptorModel parcelAttributeDescriptor = (ParcelAttributeValueDescriptorModel)attDescriptor;
                lowerLimit = parcelAttributeDescriptor.getLowerLimit();
                upperLimit = parcelAttributeDescriptor.getUpperLimit();
            }
        }
        limitNumbers.setElement1(lowerLimit);
        limitNumbers.setElement2(upperLimit);
        return limitNumbers;
    }

    private byte[] getImageData(AttributeValueModel<S, V, U> attributeValueModel) {
        byte[] imageValue = null;
        Object modelObject = attributeValueModel.getAttachedObject();
        if (modelObject instanceof AreaAttributeValueModel) {
            AreaAttributeValueModel areaAttributeValueModel = (AreaAttributeValueModel)modelObject;
            imageValue = areaAttributeValueModel.getImageValue();
        } else if (modelObject instanceof ParcelAttributeValueModel) {
            ParcelAttributeValueModel parcelAttributeValueModel = (ParcelAttributeValueModel)modelObject;
            imageValue = parcelAttributeValueModel.getImageValue();
        } else if (modelObject instanceof PoiAttributeValueModel) {
            PoiAttributeValueModel poiAttributeValueModel = (PoiAttributeValueModel)modelObject;
            imageValue = poiAttributeValueModel.getImageValue();
        } else if (modelObject instanceof SubscriptionAttributeValueModel) {
            SubscriptionAttributeValueModel subscriptionAttributeValueModel = (SubscriptionAttributeValueModel)modelObject;
            imageValue = subscriptionAttributeValueModel.getImageValue();
        }
        return imageValue;
    }

    public void clearValues() {
        this.clearValues(ComponentType.VALUE);
        this.clearValues(ComponentType.AGGREGATE);
        this.clearValues(ComponentType.SPECIAL);
    }

    public void clearValues(ComponentType componentType) {
        for (AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel : this.descriptorMap.values()) {
            Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(attributeValueDescriptorModel.getKey(), componentType);
            JComponent component = this.valueComponentMap.get(key);
            if (component == null) continue;
            switch (attributeValueDescriptorModel.getAttributeValueType()) {
                case BOOLEAN: {
                    BooleanComboBox checkBox = (BooleanComboBox)component;
                    checkBox.setSelectedItem(null);
                    break;
                }
                case DATE: {
                    AttributeDateSpinnerPanel dateField = (AttributeDateSpinnerPanel)component;
                    dateField.setValue(null);
                    break;
                }
                case INTEGER: {
                    AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                    intField.setValue(null);
                    break;
                }
                case STATIC_CHOICE: {
                    JComboBox comboBox = (JComboBox)component;
                    comboBox.setSelectedIndex(0);
                    break;
                }
                case STRING: {
                    JTextField textField = (JTextField)component;
                    textField.setText("");
                    break;
                }
                case TEXT: {
                    JTextArea textArea = (JTextArea)component;
                    textArea.setText("");
                    break;
                }
                case FLOAT: {
                    AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                    doubleField.setValue(null);
                    break;
                }
                case IMAGE: {
                    JButton imageButton = (JButton)component;
                    imageButton.setIcon(null);
                    imageButton.setEnabled(false);
                    break;
                }
                case PDF_DOWN: {
                    JButton pdfButton = (JButton)component;
                    pdfButton.setIcon(null);
                    pdfButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (AttributeValueDescriptorModel<U, V> attributeValueDescriptorModel : this.descriptorMap.values()) {
            Tupel<String, ComponentType> key = new Tupel<String, ComponentType>(attributeValueDescriptorModel.getKey(), ComponentType.VALUE);
            boolean editable = enabled && attributeValueDescriptorModel.getEditable() != false;
            JComponent component = this.valueComponentMap.get(key);
            switch (attributeValueDescriptorModel.getAttributeValueType()) {
                case BOOLEAN: {
                    BooleanComboBox checkBox = (BooleanComboBox)component;
                    checkBox.setEnabled(editable);
                    break;
                }
                case DATE: {
                    AttributeDateSpinnerPanel dateField = (AttributeDateSpinnerPanel)component;
                    dateField.setEnabled(editable);
                    break;
                }
                case INTEGER: {
                    AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                    intField.setEnabled(editable);
                    break;
                }
                case STATIC_CHOICE: {
                    JComboBox comboBox = (JComboBox)component;
                    comboBox.setEnabled(editable);
                    break;
                }
                case STRING: {
                    JTextField textField = (JTextField)component;
                    textField.setEditable(editable);
                    break;
                }
                case TEXT: {
                    JTextArea textArea = (JTextArea)component;
                    textArea.setEditable(editable);
                    break;
                }
                case FLOAT: {
                    AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                    doubleField.setEnabled(editable);
                }
            }
        }
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected abstract AttributeValueModel<S, V, U> getAttributeValueModel(S var1);

    protected abstract Collection<AttributeValueModel<S, V, U>> getAttributeValues(T var1);

    protected abstract Collection<AttributeValueDescriptorModel<U, V>> getAttributeValueDescriptors(T var1);

    protected abstract AttributeValueModel<S, V, U> createAttributeValueModel(T var1, AttributeValueDescriptorModel<U, V> var2);

    public Map<Tupel<String, ComponentType>, JComponent> getValueComponentMap() {
        return this.valueComponentMap;
    }

    public Map<String, AttributeValueDescriptorModel<U, V>> getDescriptorMap() {
        return this.descriptorMap;
    }

    private class StaticChoiceValueItem {
        private StaticChoiceValue<V, U> staticChoiceValue;

        public StaticChoiceValueItem(StaticChoiceValue<V, U> staticChoiceValue) {
            this.staticChoiceValue = staticChoiceValue;
        }

        public StaticChoiceValue<V, U> getStaticChoiceValue() {
            return this.staticChoiceValue;
        }

        public String toString() {
            StaticChoiceValue staticChoiceValue = this.getStaticChoiceValue();
            return staticChoiceValue == null ? "" : staticChoiceValue.getName();
        }
    }

    public static enum ComponentType {
        VALUE,
        AGGREGATE,
        SPECIAL;

    }
}

