/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.asynchronous;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.asynchronous.AsynchronousGeneralDto;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractMultiAsynchronousDialog<T, D extends AsynchronousGeneralDto<T>>
extends JDialog {
    private static final long serialVersionUID = -6020417709315924366L;
    protected ModelEnviroment modelEnviroment;
    private Exception exception;
    private T result;
    private JLabel message;
    private JProgressBar[] progressBar;
    private JLabel[] progressMessage;
    private String token;
    private Boolean canceled;
    private Action cancelAction;
    private boolean cancelable;
    private boolean finished = false;
    private boolean closeImmediatlyAfterCancel = false;

    public AbstractMultiAsynchronousDialog(Window parent, String title, String initialMessage, int showProgressBarCount, boolean cancelable, ModelEnviroment modelEnviroment, boolean closeImmediatlyAfterCancel) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.cancelable = cancelable;
        this.closeImmediatlyAfterCancel = closeImmediatlyAfterCancel;
        this.buildLayout(initialMessage, showProgressBarCount);
        this.setDefaultCloseOperation(0);
        this.pack();
        Dimension dim = this.getSize();
        this.setMinimumSize(dim);
        dim = new Dimension(dim.width * 2, dim.height);
        this.setSize(dim);
        SwingUtils.centerDialog(this, parent);
    }

    protected void buildLayout(String initialMessage, int showProgressBarCount) {
        try {
            this.setIconImage(ImageIO.read(AbstractMultiAsynchronousDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(Color.WHITE);
        JPanel top = new JPanel(new BorderLayout());
        top.setBackground(Color.WHITE);
        this.message = new JLabel(initialMessage);
        top.add((Component)this.message, "West");
        centerPanel.add((Component)top, "North");
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel southCenterPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        this.progressBar = new JProgressBar[showProgressBarCount];
        this.progressMessage = new JLabel[showProgressBarCount];
        if (showProgressBarCount > 0) {
            JPanel progessPanel = new JPanel(new SpringLayout());
            progessPanel.setBackground(Color.WHITE);
            for (int i = 0; i < showProgressBarCount; ++i) {
                this.progressMessage[i] = new JLabel(" ");
                progessPanel.add(this.progressMessage[i]);
                this.progressBar[i] = new JProgressBar(0, 0, 100);
                this.progressBar[i].setStringPainted(true);
                progessPanel.add(this.progressBar[i]);
            }
            SpringUtilities.makeCompactGrid(progessPanel, showProgressBarCount * 2, 1, 5, 5, 5, 5);
            JPanel bProgressPanel = new JPanel(new BorderLayout());
            bProgressPanel.add((Component)progessPanel, "South");
            bProgressPanel.add((Component)panel, "Center");
            southCenterPanel.add((Component)bProgressPanel, "Center");
        }
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.add((Component)new JLabel(new ImageIcon(AbstractAsynchronousDialog.class.getResource("/images/waiting.gif"))), "North");
        southCenterPanel.add((Component)imagePanel, "West");
        southPanel.add((Component)southCenterPanel, "Center");
        this.cancelAction = new CancelAction();
        if (this.cancelable) {
            JButton button = new JButton(this.cancelAction);
            JPanel bPanel = new JPanel(new BorderLayout());
            bPanel.add((Component)button, "East");
            southPanel.add((Component)bPanel, "South");
        }
        centerPanel.add((Component)southPanel, "South");
        centerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)centerPanel, "Center");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (!this.finished && e.getID() == 201) {
            if (this.cancelable) {
                this.cancelAction.actionPerformed(null);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    protected void cancel(String token) {
        ModelEnviroment modelEnviroment2 = this.getModelEnviroment();
        modelEnviroment2.getAllCaller().getAsynchronousCaller().cancel(token);
        this.canceled = true;
    }

    public List<Tupel<T, Boolean>> run() throws Exception {
        int index = 0;
        LinkedList<Tupel<T, Boolean>> result = new LinkedList<Tupel<T, Boolean>>();
        while (true) {
            this.token = this.startAsynchronous(index);
            if (this.token == null) break;
            this.canceled = false;
            this.finished = false;
            Thread pullingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    long refreshSeconds = 1L;
                    long terminateNoAnswerSeconds = 300L;
                    long noAnswerSeconds = 0L;
                    AsynchronousGeneralDto.Status status = AsynchronousGeneralDto.Status.RUNNING;
                    Object result = null;
                    Exception exception = null;
                    AbstractMultiAsynchronousDialog.this.canceled = false;
                    boolean canceledAndClose = false;
                    do {
                        block16: {
                            try {
                                Thread.sleep(refreshSeconds * 1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                Object dto = AbstractMultiAsynchronousDialog.this.getAsynchronousDto(AbstractMultiAsynchronousDialog.this.token);
                                String messageKey = ((AsynchronousGeneralDto)dto).getMainMessageKey();
                                if (messageKey != null) {
                                    Serializable[] messageArgs = ((AsynchronousGeneralDto)dto).getMainMessageArgs();
                                    String text = ModelEnviroment.getMessageResolver().resolveMessage(messageKey, messageArgs == null ? new Serializable[]{} : messageArgs);
                                    if (!StringUtil.isBlank(((AsynchronousGeneralDto)dto).getPrefix())) {
                                        String prefix = ModelEnviroment.getMessageResolver().resolveMessage(((AsynchronousGeneralDto)dto).getPrefix(), new Serializable[0]);
                                        text = "<html>" + prefix + "<br>" + text + "</html>";
                                    }
                                    AbstractMultiAsynchronousDialog.this.message.setText(text);
                                }
                                int[] percents = ((AsynchronousGeneralDto)dto).getPercent();
                                for (int i = 0; i < AbstractMultiAsynchronousDialog.this.progressBar.length; ++i) {
                                    if (i >= percents.length) continue;
                                    int percent = percents[i];
                                    percent = Math.max(0, percent);
                                    percent = Math.min(100, percent);
                                    AbstractMultiAsynchronousDialog.this.progressBar[i].setValue(percent);
                                }
                                String[] pMessages = ((AsynchronousGeneralDto)dto).getProgressBarMessageKeys();
                                Serializable[][] pArgs = ((AsynchronousGeneralDto)dto).getProgressBarMessageArgs();
                                for (int i = 0; i < AbstractMultiAsynchronousDialog.this.progressMessage.length; ++i) {
                                    String message;
                                    if (i >= pMessages.length || (message = pMessages[i]) == null) continue;
                                    Serializable[] args = null;
                                    if (i < pArgs.length) {
                                        args = pArgs[i];
                                    }
                                    if (args == null) {
                                        args = new Serializable[]{};
                                    }
                                    AbstractMultiAsynchronousDialog.this.progressMessage[i].setText(ModelEnviroment.getMessageResolver().resolveMessage(pMessages[i], args));
                                }
                                status = ((AsynchronousGeneralDto)dto).getStatus();
                                result = ((AsynchronousGeneralDto)dto).getResult();
                                exception = ((AsynchronousGeneralDto)dto).getException();
                                noAnswerSeconds = 0L;
                            }
                            catch (Exception e) {
                                if ((noAnswerSeconds += refreshSeconds) <= terminateNoAnswerSeconds) break block16;
                                exception = e;
                                status = AsynchronousGeneralDto.Status.ERROR;
                            }
                        }
                        boolean bl = canceledAndClose = AbstractMultiAsynchronousDialog.this.canceled != false && AbstractMultiAsynchronousDialog.this.closeImmediatlyAfterCancel;
                    } while (status == AsynchronousGeneralDto.Status.RUNNING && !canceledAndClose);
                    AbstractMultiAsynchronousDialog.this.getModelEnviroment().getAllCaller().getAsynchronousCaller().removeResult(AbstractMultiAsynchronousDialog.this.token);
                    if (AbstractMultiAsynchronousDialog.this.canceled.booleanValue() && status == AsynchronousGeneralDto.Status.RUNNING) {
                        status = AsynchronousGeneralDto.Status.CANCELED;
                    }
                    switch (status) {
                        case ERROR: {
                            AbstractMultiAsynchronousDialog.this.exception = exception;
                            break;
                        }
                        case CANCELED: {
                            AbstractMultiAsynchronousDialog.this.canceled = true;
                            AbstractMultiAsynchronousDialog.this.result = result;
                            break;
                        }
                        default: {
                            AbstractMultiAsynchronousDialog.this.result = result;
                        }
                    }
                    AbstractMultiAsynchronousDialog.this.finished = true;
                    AbstractMultiAsynchronousDialog.this.dispose();
                }
            });
            pullingThread.start();
            this.setVisible(true);
            while (!this.canceled.booleanValue() && !this.finished) {
                Thread.sleep(50L);
            }
            if (this.exception != null) {
                throw this.exception;
            }
            result.add(new Tupel<T, Boolean>(this.result, this.canceled));
        }
        return result;
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected abstract D getAsynchronousDto(String var1);

    protected abstract String startAsynchronous(int var1);

    protected abstract int getRunCount();

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int d = JOptionPane.showConfirmDialog(AbstractMultiAsynchronousDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirmCancel", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            if (d == 0) {
                AbstractMultiAsynchronousDialog.this.cancel(AbstractMultiAsynchronousDialog.this.token);
                this.setEnabled(false);
            }
        }
    }
}

