/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.areatour;

import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.area.DeliveryRoundComboBox;
import de.datomino.peppergis.client.gui.common.BooleanComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.gui.parcel.ParcelInclusionExclusionPane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.ComponentType;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import de.datomino.peppergis.util.RewardEntity;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.apache.commons.lang.ArrayUtils;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractAreaTourCalculationPane
extends JPanel {
    private static final long serialVersionUID = -5735200602708393994L;
    private EnumComboBox<CalculationWay> calculationWayComboBox;
    private EnumComboBox<AreaCalculationType> areaCalculationType;
    private JSpinner dateSpinner;
    private JSpinner dayGapSpinner;
    private JRadioButton dateRadioButton;
    private JRadioButton dayGapRadioButton;
    private JSpinner timeSpinner;
    private JCheckBox timeActive;
    private EnumComboBox<SubscriptionStatus> statusCombox;
    private EnumComboBox<SubscriptionDeliveryType> subscriptionTypeComBox;
    private EnumComboBox<LetterDeliveryType> letterDeliveryTypeComboBox;
    private EnumComboBox<RouteBackType> routeBackType;
    private BooleanComboBox poi;
    private ParcelInclusionExclusionPane parcelInclusionExclusionPane;
    private JRadioButton preferExclusion;
    private JRadioButton preferInclusion;
    private EnumComboBox<TourExportFormat> tourExportType;
    private ReviewListener reviewListener = new ReviewListener();
    private JTabbedPane tabbedPane;
    private Integer parcelIndex;
    private Integer subscriptionIndex;
    private Integer letterIndex;
    private Holder<RewardEntity> rewardEntity;
    private Holder<Tupel<Date, Date>> nightTimeWindow;
    private JCheckBox[] routeVehicleTypes;
    private RouteTypeComboBox poiRouteVehicleType;
    private RouteTypeComboBox pickPointRouteVehicleType;
    private BooleanComboBox pdf;
    private BooleanComboBox startPickPointType;
    private BooleanComboBox endPickPointType;
    private DefaultAreaObjectChooserPane defaultAreaObjectChooserPane;
    private AreaLayerComboBox areaLayerComboBox;
    private DeliveryRoundComboBox deliveryRoundComboBox;
    private JCheckBox selfParameterCheckbox;
    private JSpinner fixStart;
    private JSpinner fixEnd;
    private JCheckBox difficultyLevel;
    private JCheckBox parcelLocation;
    private ModelEnviroment modelEnviroment;
    private AreaLayerModel fixedAreaLayer;
    private JTextField hourReward;
    private JTextField kmRewardMotor;
    private JTextField kmRewardFoot;
    private JTextField kmRewardBike;
    private JTextField nightSurcharge;
    private JTextField nightSurchargeMinMinutes;
    private JTextField extraCharge;
    private JTextField nightWindowStart;
    private JTextField nightWindowEnd;

    public AbstractAreaTourCalculationPane(ModelEnviroment modelEnviroment) {
        this(modelEnviroment, null);
    }

    public AbstractAreaTourCalculationPane(ModelEnviroment modelEnviroment, AreaLayerModel layer) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.fixedAreaLayer = layer;
        this.buildLayout(layer);
        this.doEnablings();
    }

    private void buildLayout(AreaLayerModel layer) {
        this.tabbedPane = new JTabbedPane();
        int index = -1;
        JPanel layerPane = this.createLayerPane(layer);
        this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]), layerPane);
        ++index;
        JPanel common = this.createCommonPane();
        this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.generalSettings", new Serializable[0]), common);
        ++index;
        if (this.isWithSettingTab()) {
            JPanel settings = this.createSettingsPane();
            this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.config", new Serializable[0]), settings);
            ++index;
        }
        if (this.areTargetsConfigurable()) {
            JPanel parcel = this.createParcelPane();
            this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]), parcel);
            this.parcelIndex = ++index;
            JPanel subscription = this.createSubscriptionPane();
            this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), subscription);
            this.subscriptionIndex = ++index;
            JPanel letter = this.createLetterPane();
            this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.letters", new Serializable[0]), letter);
            this.letterIndex = ++index;
        }
        if (this.isWithCostTab()) {
            JPanel cost = this.createCostPane();
            this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost", new Serializable[0]), cost);
            ++index;
        }
        this.add((Component)this.tabbedPane, "Center");
    }

    private JPanel createLayerPane(AreaLayerModel layer) {
        JPanel pane = new JPanel(new BorderLayout());
        this.defaultAreaObjectChooserPane = new DefaultAreaObjectChooserPane(this.modelEnviroment);
        pane.add((Component)this.defaultAreaObjectChooserPane, "Center");
        if (layer == null) {
            JPanel layerPane = new JPanel(new BorderLayout());
            layerPane.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])), "West");
            this.areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, false, new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND}, false, this.isWageLayersOnly());
            layerPane.add((Component)this.areaLayerComboBox, "Center");
            pane.add((Component)layerPane, "North");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AreaLayerModel selectedItem = (AreaLayerModel)AbstractAreaTourCalculationPane.this.areaLayerComboBox.getSelectedItem();
                    AbstractAreaTourCalculationPane.this.defaultAreaObjectChooserPane.setAreaLayerModel(selectedItem);
                }
            };
            this.areaLayerComboBox.addActionListener(actionListener);
            actionListener.actionPerformed(null);
        } else {
            this.defaultAreaObjectChooserPane.setAreaLayerModel(layer);
        }
        return pane;
    }

    private JPanel createCostPane() {
        JPanel pane = new JPanel(new BorderLayout());
        JPanel costPane = new JPanel(new SpringLayout());
        this.rewardEntity = new Holder<RewardEntity>(new RewardEntity(ModelEnviroment.getProperties()));
        WidthUnifier widthUnifier = new WidthUnifier();
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.hour", new Serializable[0])));
        this.hourReward = this.creatTextField(this.rewardEntity.getElement().getHourReward(), "HourReward", this.rewardEntity, costPane);
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.hourReward, "East");
        widthUnifier.add(this.hourReward);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.motor", new Serializable[0])));
        this.kmRewardMotor = this.creatTextField(this.rewardEntity.getElement().getKmRewardMotor(), "KmRewardMotor", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.kmRewardMotor, "East");
        widthUnifier.add(this.kmRewardMotor);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.bike", new Serializable[0])));
        this.kmRewardBike = this.creatTextField(this.rewardEntity.getElement().getKmRewardBike(), "KmRewardBike", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.kmRewardBike, "East");
        widthUnifier.add(this.kmRewardBike);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.foot", new Serializable[0])));
        this.kmRewardFoot = this.creatTextField(this.rewardEntity.getElement().getKmRewardFoot(), "KmRewardFoot", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.kmRewardFoot, "East");
        widthUnifier.add(this.kmRewardFoot);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.nightsurcharge", new Serializable[0]) + " in %"));
        this.nightSurcharge = this.creatTextField(this.rewardEntity.getElement().getNightSurcharge(), "NightSurcharge", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.nightSurcharge, "East");
        widthUnifier.add(this.nightSurcharge);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.night.minMinute", new Serializable[0])));
        this.nightSurchargeMinMinutes = this.creatTextField(this.rewardEntity.getElement().getNightSurchargeMinMinutes(), "NightSurchargeMinMinutes", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.nightSurchargeMinMinutes, "East");
        widthUnifier.add(this.nightSurchargeMinMinutes);
        costPane.add(eastPanel);
        Date nightStart = TimeUtil.createDate(0, 0, 0, AreaTourModelUtil.NIGHT.getStartHour(), AreaTourModelUtil.NIGHT.getStartMinute(), 0);
        Date nightEnd = TimeUtil.createDate(0, 0, 0, AreaTourModelUtil.NIGHT.getEndHour(), AreaTourModelUtil.NIGHT.getEndMinute(), 0);
        this.nightTimeWindow = new Holder<Tupel<Date, Date>>(new Tupel<Date, Date>(nightStart, nightEnd));
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.night.from", new Serializable[0])));
        this.nightWindowStart = ClientSwingUtil.createParameterTextField(10, ClientFormUtil.dateToString(this.nightTimeWindow.getElement().getElement1(), FormUtil.CLOCKFORMAT), true, "Element1", this.nightTimeWindow, costPane, FormUtil.CLOCKFORMAT, Date.class);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.nightWindowStart, "East");
        widthUnifier.add(this.nightWindowStart);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.night.till", new Serializable[0])));
        this.nightWindowEnd = ClientSwingUtil.createParameterTextField(10, ClientFormUtil.dateToString(this.nightTimeWindow.getElement().getElement2(), FormUtil.CLOCKFORMAT), true, "Element2", this.nightTimeWindow, costPane, FormUtil.CLOCKFORMAT, Date.class);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.nightWindowEnd, "East");
        widthUnifier.add(this.nightWindowEnd);
        costPane.add(eastPanel);
        costPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.extraCharge", new Serializable[0]) + " in %"));
        this.extraCharge = this.creatTextField(this.rewardEntity.getElement().getExtraCharge(), "ExtraCharge", this.rewardEntity, costPane);
        eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)this.extraCharge, "East");
        widthUnifier.add(this.extraCharge);
        costPane.add(eastPanel);
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(costPane, widthUnifier.size(), 2, 5, 5, 5, 5);
        pane.add((Component)costPane, "North");
        return pane;
    }

    private JTextField creatTextField(Number d, String fieldName, Holder<?> holder, Component parent) {
        return ClientSwingUtil.createParameterTextField(10, ClientFormUtil.getNumberString(d), true, fieldName, holder, parent);
    }

    private JPanel createLetterPane() {
        WidthUnifier widthUnifier = new WidthUnifier();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel sub = new JPanel(new SpringLayout());
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(LetterDeliveryType.class.getName(), new Serializable[0])));
        this.letterDeliveryTypeComboBox = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, false);
        JPanel subsub = new JPanel(new BorderLayout());
        subsub.add(this.letterDeliveryTypeComboBox, "East");
        widthUnifier.add(this.letterDeliveryTypeComboBox);
        sub.add(subsub);
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(sub, 1, 2, 5, 5, 5, 5);
        panel.add((Component)sub, "North");
        return panel;
    }

    private JPanel createSubscriptionPane() {
        WidthUnifier widthUnifier = new WidthUnifier();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel sub = new JPanel(new SpringLayout());
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SubscriptionStatus.class.getName(), new Serializable[0])));
        this.statusCombox = new EnumComboBox<SubscriptionStatus>(SubscriptionStatus.class, false);
        JPanel subsub = new JPanel(new BorderLayout());
        subsub.add(this.statusCombox, "East");
        widthUnifier.add(this.statusCombox);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SubscriptionDeliveryType.class.getName(), new Serializable[0])));
        this.subscriptionTypeComBox = new EnumComboBox<SubscriptionDeliveryType>(SubscriptionDeliveryType.class, false);
        subsub = new JPanel(new BorderLayout());
        subsub.add(this.subscriptionTypeComBox, "East");
        widthUnifier.add(this.subscriptionTypeComBox);
        sub.add(subsub);
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(sub, 2, 2, 5, 5, 5, 5);
        panel.add((Component)sub, "North");
        return panel;
    }

    private JPanel createParcelPane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel sub = new JPanel(new SpringLayout());
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.inclusionsExclusions", new Serializable[0])));
        JPanel subsub = new JPanel(new BorderLayout());
        this.preferExclusion = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.preferExclusion", new Serializable[0]));
        JPanel subsubsub = new JPanel(new BorderLayout());
        subsubsub.add((Component)this.preferExclusion, "West");
        this.preferInclusion = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.preferInclusion", new Serializable[0]));
        subsubsub.add((Component)this.preferInclusion, "East");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.preferExclusion);
        buttonGroup.add(this.preferInclusion);
        this.preferExclusion.setSelected(true);
        subsub.add((Component)subsubsub, "East");
        sub.add(subsub);
        this.parcelInclusionExclusionPane = new ParcelInclusionExclusionPane(this.modelEnviroment);
        JLabel[] labels = this.parcelInclusionExclusionPane.getLabels();
        JComponent[] widgets = this.parcelInclusionExclusionPane.getWidgets();
        for (int i = 0; i < labels.length; ++i) {
            sub.add(labels[i]);
            subsub = new JPanel(new BorderLayout());
            subsub.add((Component)widgets[i], "East");
            sub.add(subsub);
        }
        SpringUtilities.makeCompactGrid(sub, 1 + labels.length, 2, 5, 5, 5, 5);
        panel.add((Component)sub, "North");
        return panel;
    }

    private JPanel createSettingsPane() {
        WidthUnifier widthUnifier = new WidthUnifier();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel sub = new JPanel(new SpringLayout());
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(RouteVehicleType.class.getName(), new Serializable[0])));
        JPanel subsub = new JPanel(new BorderLayout());
        JPanel routeVehicleTypePanel = new JPanel(new FlowLayout());
        List<RouteVehicleType> routeVehicleTypes = AbstractAreaTourCalculationPane.getRouteVehicleTypesToSelect();
        this.routeVehicleTypes = new JCheckBox[routeVehicleTypes.size()];
        int index = 0;
        RouteVehicleType[] preselected = this.getPreselectedRouteVehicleTypes();
        for (RouteVehicleType routeVehicleType : routeVehicleTypes) {
            this.routeVehicleTypes[index] = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessageForEnum(routeVehicleType), ArrayUtils.contains((Object[])preselected, (Object)routeVehicleType));
            routeVehicleTypePanel.add(this.routeVehicleTypes[index]);
            ++index;
        }
        subsub.add((Component)routeVehicleTypePanel, "East");
        widthUnifier.add(routeVehicleTypePanel);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.poi", new Serializable[0])));
        this.poiRouteVehicleType = new RouteTypeComboBox(true);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.poiRouteVehicleType, "East");
        widthUnifier.add(this.poiRouteVehicleType);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.pickPoint", new Serializable[0])));
        this.pickPointRouteVehicleType = new RouteTypeComboBox(true);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.pickPointRouteVehicleType, "East");
        widthUnifier.add(this.pickPointRouteVehicleType);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0])));
        this.poi = new BooleanComboBox(false);
        this.poi.setSelectedItem(Boolean.FALSE);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.poi, "East");
        widthUnifier.add(this.poi);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.startPickPoints", new Serializable[0])));
        this.startPickPointType = new BooleanComboBox(false);
        this.startPickPointType.setSelectedItem(Boolean.FALSE);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.startPickPointType, "East");
        widthUnifier.add(this.startPickPointType);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.endPickPoints", new Serializable[0])));
        this.endPickPointType = new BooleanComboBox(false);
        this.endPickPointType.setSelectedItem(Boolean.FALSE);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.endPickPointType, "East");
        widthUnifier.add(this.endPickPointType);
        sub.add(subsub);
        if (this.isWithFixing()) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.firstFix", new Serializable[0])));
            this.fixStart = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            subsub = new JPanel(new BorderLayout());
            subsub.add((Component)this.fixStart, "East");
            widthUnifier.add(this.fixStart);
            sub.add(subsub);
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.lastFix", new Serializable[0])));
            this.fixEnd = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            subsub = new JPanel(new BorderLayout());
            subsub.add((Component)this.fixEnd, "East");
            widthUnifier.add(this.fixEnd);
            sub.add(subsub);
        }
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("buttons.backward", new Serializable[0])));
        this.routeBackType = new EnumComboBox<RouteBackType>(RouteBackType.class, false);
        subsub = new JPanel(new BorderLayout());
        subsub.add(this.routeBackType, "East");
        widthUnifier.add(this.routeBackType);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0])));
        this.difficultyLevel = new JCheckBox();
        this.difficultyLevel.setSelected(true);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.difficultyLevel, "East");
        widthUnifier.add(this.difficultyLevel);
        sub.add(subsub);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0])));
        this.parcelLocation = new JCheckBox();
        this.parcelLocation.setSelected(true);
        subsub = new JPanel(new BorderLayout());
        subsub.add((Component)this.parcelLocation, "East");
        widthUnifier.add(this.parcelLocation);
        sub.add(subsub);
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(sub, widthUnifier.size(), 2, 5, 5, 5, 5);
        panel.add((Component)sub, "North");
        return panel;
    }

    private JPanel createCommonPane() {
        boolean pdf;
        Date startTime;
        JPanel panel = new JPanel(new BorderLayout());
        JPanel sub = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier = new WidthUnifier();
        this.deliveryRoundComboBox = new DeliveryRoundComboBox(this.modelEnviroment, false);
        if (this.isDeliveryRoundSelectable()) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0])));
            JPanel eastPanel = new JPanel(new BorderLayout());
            eastPanel.add((Component)this.deliveryRoundComboBox, "East");
            sub.add(eastPanel);
            widthUnifier.add(this.deliveryRoundComboBox);
            this.deliveryRoundComboBox.addActionListener(this.reviewListener);
            Boolean wageEnabled = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE, UserRole.WAGE_PASSIVE, UserRole.WAGE_DIFFERENCE) && this.modelEnviroment.getAllCaller().getUserCaller().isComponentEnabled(ComponentType.WAGE_TOOL);
            if (wageEnabled.booleanValue()) {
                sub.add(new JLabel(" "));
                this.selfParameterCheckbox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.useSelf", new Serializable[0]));
                this.selfParameterCheckbox.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 2862098092064489364L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (AbstractAreaTourCalculationPane.this.selfParameterCheckbox.isSelected()) {
                            AbstractAreaTourCalculationPane.this.deliveryRoundComboBox.setEnabled(false);
                        } else {
                            AbstractAreaTourCalculationPane.this.deliveryRoundComboBox.setEnabled(true);
                        }
                    }
                });
                this.selfParameterCheckbox.setSelected(false);
                eastPanel = new JPanel(new BorderLayout());
                eastPanel.add((Component)this.selfParameterCheckbox, "East");
                sub.add(eastPanel);
                widthUnifier.add(this.selfParameterCheckbox);
            }
        }
        this.addDateSettings(sub, widthUnifier);
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.time", new Serializable[0])));
        JPanel timePanel = new JPanel(new BorderLayout());
        this.timeActive = new JCheckBox();
        this.timeActive.setSelected(false);
        timePanel.add((Component)this.timeActive, "West");
        String startTimeString = ModelEnviroment.getProperties().getProperty("areatour.startTime.default");
        try {
            String[] start = startTimeString.split(":");
            int startHour = Integer.valueOf(start[0]);
            int startMinute = Integer.valueOf(start[1]);
            startTime = TimeUtil.setTime(new Date(), startHour, startMinute, 0);
        }
        catch (Exception e) {
            startTime = TimeUtil.setTime(new Date(), 6, 0, 0);
        }
        this.timeSpinner = new JSpinner(new SpinnerDateModel(startTime, null, null, 11));
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.timeSpinner, FormUtil.CLOCKFORMAT);
        this.timeSpinner.setEditor(editor);
        this.timeSpinner.setEnabled(false);
        timePanel.add((Component)this.timeSpinner, "Center");
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)timePanel, "East");
        widthUnifier.add(timePanel);
        sub.add(eastPanel);
        this.timeActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAreaTourCalculationPane.this.timeSpinner.setEnabled(AbstractAreaTourCalculationPane.this.timeActive.isSelected());
            }
        });
        this.calculationWayComboBox = new EnumComboBox(CalculationWay.class, false, (Enum[])this.getSelectableCalculationWays());
        if (this.calculationWayComboBox.getItemCount() != 0) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(CalculationWay.class.getName(), new Serializable[0])));
            eastPanel = new JPanel(new BorderLayout());
            eastPanel.add(this.calculationWayComboBox, "East");
            widthUnifier.add(this.calculationWayComboBox);
            sub.add(eastPanel);
        }
        this.calculationWayComboBox.addActionListener(this.reviewListener);
        this.areaCalculationType = new EnumComboBox(AreaCalculationType.class, false, (Enum[])this.getAllowedAreaCalculationTypes());
        if (this.areaCalculationType.getItemCount() != 0) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(AreaCalculationType.class.getName(), new Serializable[0])));
            eastPanel = new JPanel(new BorderLayout());
            eastPanel.add(this.areaCalculationType, "East");
            widthUnifier.add(this.areaCalculationType);
            sub.add(eastPanel);
        }
        this.areaCalculationType.addActionListener(this.reviewListener);
        if (this.isExportFormatSelectable()) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(TourExportFormat.class.getName(), new Serializable[0])));
            this.tourExportType = new EnumComboBox(TourExportFormat.class, !this.isExportFormatForced(), (Enum[])new TourExportFormat[]{TourExportFormat.CSV, TourExportFormat.CSV_ALL});
            eastPanel = new JPanel(new BorderLayout());
            eastPanel.add(this.tourExportType, "East");
            widthUnifier.add(this.tourExportType);
            sub.add(eastPanel);
        }
        if (pdf = this.isPdfSelectable()) {
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.pdf", new Serializable[0])));
            this.pdf = new BooleanComboBox(false);
            this.pdf.setSelectedItem(Boolean.FALSE);
            eastPanel = new JPanel(new BorderLayout());
            eastPanel.add((Component)this.pdf, "East");
            widthUnifier.add(this.pdf);
            sub.add(eastPanel);
        }
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(sub, widthUnifier.size(), 2, 5, 5, 5, 5);
        panel.add((Component)sub, "North");
        return panel;
    }

    private void addDateSettings(JPanel sub, WidthUnifier widthUnifier) {
        sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.date", new Serializable[0])));
        this.dateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 6));
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.dateSpinner, FormUtil.DATEFORMAT);
        this.dateSpinner.setEditor(editor);
        JPanel eastPanel = new JPanel(new BorderLayout());
        if (this.isWithFixedDateOnly()) {
            eastPanel.add((Component)this.dateSpinner, "East");
            widthUnifier.add(this.dateSpinner);
            sub.add(eastPanel);
        } else {
            JPanel innerPanel = new JPanel(new BorderLayout());
            this.dateRadioButton = new JRadioButton();
            innerPanel.add((Component)this.dateRadioButton, "West");
            innerPanel.add((Component)this.dateSpinner, "Center");
            eastPanel.add((Component)innerPanel, "East");
            widthUnifier.add(innerPanel);
            sub.add(eastPanel);
            sub.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.job.reviewAreaTourJob.dayGap", new Serializable[0])));
            this.dayGapSpinner = new JSpinner(new SpinnerNumberModel((Number)0, null, null, (Number)1));
            innerPanel = new JPanel(new BorderLayout());
            this.dayGapRadioButton = new JRadioButton();
            innerPanel.add((Component)this.dayGapRadioButton, "West");
            innerPanel.add((Component)this.dayGapSpinner, "Center");
            eastPanel = new JPanel(new BorderLayout());
            eastPanel.add((Component)innerPanel, "East");
            widthUnifier.add(innerPanel);
            sub.add(eastPanel);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.dateRadioButton);
            buttonGroup.add(this.dayGapRadioButton);
            this.dateRadioButton.setSelected(true);
            this.dayGapSpinner.setEnabled(false);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractAreaTourCalculationPane.this.dateRadioButton.isSelected()) {
                        AbstractAreaTourCalculationPane.this.dateSpinner.setEnabled(true);
                        AbstractAreaTourCalculationPane.this.dayGapSpinner.setEnabled(false);
                    } else if (AbstractAreaTourCalculationPane.this.dayGapRadioButton.isSelected()) {
                        AbstractAreaTourCalculationPane.this.dateSpinner.setEnabled(false);
                        AbstractAreaTourCalculationPane.this.dayGapSpinner.setEnabled(true);
                    }
                }
            };
            this.dateRadioButton.addActionListener(actionListener);
            this.dayGapRadioButton.addActionListener(actionListener);
        }
    }

    private void doEnablings() {
        CalculationWay calculationWay = this.calculationWayComboBox.getSelectedValue();
        if (calculationWay == null) {
            calculationWay = CalculationWay.OPTIMIZE;
        }
        int selectedIndex = this.areaCalculationType.getSelectedIndex();
        switch (calculationWay) {
            case OPTIMIZE: {
                this.areaCalculationType.setElements(false, new AreaCalculationType[]{AreaCalculationType.DEFAULT, AreaCalculationType.SIDE, AreaCalculationType.GROUP});
                this.areaCalculationType.setSelectedIndex(selectedIndex);
                this.areaCalculationType.setEnabled(true);
                break;
            }
            case PARCEL_ORDER: {
                this.areaCalculationType.setElements(false, new AreaCalculationType[]{AreaCalculationType.PARCEL_SORT_ORDER});
                this.areaCalculationType.setEnabled(false);
                break;
            }
            case SAVED_ORDER: {
                this.areaCalculationType.setElements(false, new AreaCalculationType[]{AreaCalculationType.ORIGINAL_CALCULATION});
                this.areaCalculationType.setEnabled(false);
            }
        }
        if (this.areTargetsConfigurable() && this.isDeliveryRoundSelectable()) {
            boolean parcelEnabled = false;
            boolean subscriptionEnabled = false;
            boolean letterEnabled = false;
            DeliveryRoundModel deliveryRoundModel = this.deliveryRoundComboBox.getSelectedDeliveryRound();
            if (deliveryRoundModel != null) {
                for (DeliveryProductModel deliveryProduct : deliveryRoundModel.iterableDeliveryProducts()) {
                    Product product = deliveryProduct.getProduct();
                    if (product == null) continue;
                    switch (product) {
                        case LEAFLET: 
                        case WEEKLY_PAPER: {
                            parcelEnabled = true;
                            break;
                        }
                        case LETTER: {
                            letterEnabled = true;
                            break;
                        }
                        case SUBSCRIPTION: {
                            subscriptionEnabled = true;
                        }
                    }
                }
            }
            this.tabbedPane.setEnabledAt(this.parcelIndex, parcelEnabled);
            this.tabbedPane.setEnabledAt(this.subscriptionIndex, subscriptionEnabled);
            this.tabbedPane.setEnabledAt(this.letterIndex, letterEnabled);
        }
    }

    public Collection<BlockDescriptor> getBlockDescriptors() {
        return this.parcelInclusionExclusionPane == null ? Collections.emptyList() : this.parcelInclusionExclusionPane.getBlockDescriptors();
    }

    public boolean isPoi() {
        return PrimitiveUtil.nullToFalse(this.poi.getSelectedValue());
    }

    public Collection<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>> getRouteVehicleTypes() {
        if (this.isWithSettingTab()) {
            HashSet<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>> vehicles = new HashSet<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>>();
            boolean poiDefaultSelected = this.isDefaultPoiRouteVehicleTypeSelected();
            RouteVehicleType poiRouteVehicleType = null;
            if (!poiDefaultSelected) {
                poiRouteVehicleType = this.getPoiRouteVehicleType();
            }
            boolean pickPointDefaultSelected = this.isDefaultPickPointRouteVehicleTypeSelected();
            RouteVehicleType pickPointRouteVehicleType = null;
            if (!pickPointDefaultSelected) {
                pickPointRouteVehicleType = this.getPickPointRouteVehicleType();
            }
            List<RouteVehicleType> selectables = AbstractAreaTourCalculationPane.getRouteVehicleTypesToSelect();
            Iterator<RouteVehicleType> iter = selectables.iterator();
            for (JCheckBox box : this.routeVehicleTypes) {
                RouteVehicleType next = iter.next();
                if (!box.isSelected()) continue;
                RouteVehicleType nextPoiRouteVehicleType = poiDefaultSelected || poiRouteVehicleType == null ? next : poiRouteVehicleType;
                RouteVehicleType nextPickPointRouteVehicleType = pickPointDefaultSelected || pickPointRouteVehicleType == null ? next : pickPointRouteVehicleType;
                vehicles.add(new Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>(next, nextPoiRouteVehicleType, nextPickPointRouteVehicleType));
            }
            return vehicles;
        }
        return null;
    }

    public final RouteVehicleType[] getSelectedRouteVehicleTypes() {
        List<RouteVehicleType> selectables = AbstractAreaTourCalculationPane.getRouteVehicleTypesToSelect();
        Iterator<RouteVehicleType> iter = selectables.iterator();
        EnumSet<RouteVehicleType> set = EnumSet.noneOf(RouteVehicleType.class);
        for (JCheckBox box : this.routeVehicleTypes) {
            RouteVehicleType next = iter.next();
            if (!box.isSelected()) continue;
            set.add(next);
        }
        RouteVehicleType[] result = new RouteVehicleType[set.size()];
        result = set.toArray(result);
        return result;
    }

    public final boolean isDefaultPoiRouteVehicleTypeSelected() {
        if (this.isWithSettingTab()) {
            return this.poiRouteVehicleType.isDefaultSelected();
        }
        return false;
    }

    public final boolean isDefaultPickPointRouteVehicleTypeSelected() {
        if (this.isWithSettingTab()) {
            return this.pickPointRouteVehicleType.isDefaultSelected();
        }
        return false;
    }

    public final RouteVehicleType getPoiRouteVehicleType() {
        if (this.isWithSettingTab()) {
            return (RouteVehicleType)((Object)this.poiRouteVehicleType.getSelectedValue());
        }
        return null;
    }

    public final RouteVehicleType getPickPointRouteVehicleType() {
        if (this.isWithSettingTab()) {
            return (RouteVehicleType)((Object)this.pickPointRouteVehicleType.getSelectedValue());
        }
        return null;
    }

    public AreaCalculationType getAreaCalculationType() {
        return this.areaCalculationType.getSelectedValue();
    }

    public boolean isPreferExclusions() {
        return this.preferExclusion.isSelected();
    }

    public RouteBackType getRouteBackType() {
        return this.routeBackType.getSelectedValue();
    }

    public boolean isPdf() {
        return this.pdf.getSelectedValue();
    }

    public boolean isStartPickPoint() {
        return PrimitiveUtil.nullToFalse(this.startPickPointType.getSelectedValue());
    }

    public boolean isEndPickPoint() {
        return this.endPickPointType.getSelectedValue();
    }

    public Date getDate() {
        if (this.dateRadioButton == null || this.dateRadioButton.isSelected()) {
            Date date = (Date)this.dateSpinner.getValue();
            Tripel<Integer, Integer, Integer> tripel = this.getTime();
            date = tripel != null ? TimeUtil.setTime(date, tripel.getElement1(), tripel.getElement2(), tripel.getElement3()) : TimeUtil.setTime(date, 0, 0, 0);
            return date;
        }
        return null;
    }

    public Tripel<Integer, Integer, Integer> getTime() {
        if (this.timeActive.isSelected()) {
            Date time = (Date)this.timeSpinner.getValue();
            Tripel<Integer, Integer, Integer> tripel = TimeUtil.getTimeTripel(time);
            return tripel;
        }
        return null;
    }

    public Collection<SubscriptionStatus> getSubscriptionStatus() {
        SubscriptionStatus subscriptionStatus = this.statusCombox.getSelectedValue();
        switch (subscriptionStatus) {
            case ALL: {
                return Arrays.asList(SubscriptionStatus.values());
            }
        }
        return Collections.singletonList(subscriptionStatus);
    }

    public Collection<SubscriptionDeliveryType> getSubscriptionDeliveryTypes() {
        SubscriptionDeliveryType subscriptionDeliveryType = this.subscriptionTypeComBox.getSelectedValue();
        switch (subscriptionDeliveryType) {
            case ALL: {
                return Arrays.asList(SubscriptionDeliveryType.values());
            }
        }
        return Collections.singletonList(subscriptionDeliveryType);
    }

    public Collection<LetterDeliveryType> getLetterDeliveryTypes() {
        LetterDeliveryType letterDeliveryType = this.letterDeliveryTypeComboBox.getSelectedValue();
        switch (letterDeliveryType) {
            case ALL: {
                return Arrays.asList(LetterDeliveryType.values());
            }
        }
        return Collections.singletonList(letterDeliveryType);
    }

    public DeliveryRoundModel getDeliveryRound() {
        return this.deliveryRoundComboBox.getSelectedDeliveryRound();
    }

    public boolean isSelfParameter() {
        return this.selfParameterCheckbox != null && this.selfParameterCheckbox.isSelected();
    }

    public TourExportFormat getTourExportType() {
        return this.tourExportType == null ? null : this.tourExportType.getSelectedValue();
    }

    public RewardEntity getRewardEntity() {
        RewardEntity rewardEntity = this.rewardEntity.getElement();
        String hourReward = this.hourReward.getText();
        try {
            rewardEntity.setHourReward(Double.parseDouble(hourReward));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String kmRewardMotor = this.kmRewardMotor.getText();
        try {
            rewardEntity.setKmRewardMotor(Double.parseDouble(kmRewardMotor));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String kmRewardBike = this.kmRewardBike.getText();
        try {
            rewardEntity.setKmRewardBike(Double.parseDouble(kmRewardBike));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String kmRewardFoot = this.kmRewardFoot.getText();
        try {
            rewardEntity.setKmRewardFoot(Double.parseDouble(kmRewardFoot));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String nightSurcharge = this.nightSurcharge.getText();
        try {
            rewardEntity.setNightSurcharge(Double.parseDouble(nightSurcharge));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String nightSurchargeMinMinutes = this.nightSurchargeMinMinutes.getText();
        try {
            rewardEntity.setNightSurchargeMinMinutes(Integer.parseInt(nightSurchargeMinMinutes));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String extraCharge = this.extraCharge.getText();
        try {
            rewardEntity.setExtraCharge(Double.parseDouble(extraCharge));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rewardEntity;
    }

    public CalculationWay getSelectedCalculationWay() {
        return this.calculationWayComboBox.getSelectedValue();
    }

    public NightSurchargeTimeWindow getNight() {
        NightSurchargeTimeWindow night = AreaTourModelUtil.NIGHT.clone();
        Calendar c = Calendar.getInstance();
        c.setTime(this.nightTimeWindow.getElement().getElement1());
        night.setStartHour(c.get(11));
        night.setStartMinute(c.get(12));
        c.setTime(this.nightTimeWindow.getElement().getElement2());
        night.setEndHour(c.get(11));
        night.setEndMinute(c.get(12));
        return night;
    }

    public Collection<Tupel<AreaObjectModel, List<Model>>> getSelectedAreaObjects(RouteVehicleType routeVehicleType) {
        Set<Long> selectedAreaObjectIds = this.defaultAreaObjectChooserPane.getSelectedAreaObjects();
        Collection<AreaObjectModel> areas = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObjectsById(selectedAreaObjectIds);
        ArrayList<Tupel<AreaObjectModel, List<Model>>> list = new ArrayList<Tupel<AreaObjectModel, List<Model>>>(areas.size());
        for (AreaObjectModel area : areas) {
            list.add(new Tupel<AreaObjectModel, List<Model>>(area, this.getPreOrder(area, routeVehicleType)));
        }
        return list;
    }

    protected abstract List<Model> getPreOrder(AreaObjectModel var1, RouteVehicleType var2);

    public Collection<String> getSelectedAreaShortcuts() {
        return this.defaultAreaObjectChooserPane.getSelectedShortcuts();
    }

    public RoutingType getRoutingType() {
        boolean isFixedStart = this.fixStart != null && (Integer)this.fixStart.getValue() > 0;
        boolean isFixedEnd = this.fixEnd != null && (Integer)this.fixEnd.getValue() > 0;
        return OptimizationType.createOptimizationType(PrimitiveUtil.nullToFalse(this.poi.getSelectedValue()), isFixedStart, isFixedEnd);
    }

    public int getSizeOfStartBlock() {
        return this.fixStart == null ? 0 : (Integer)this.fixStart.getValue();
    }

    public int getSizeOfEndBlock() {
        return this.fixEnd == null ? 0 : (Integer)this.fixEnd.getValue();
    }

    public boolean isWithDifficultyLevel() {
        return this.difficultyLevel.isSelected();
    }

    public boolean isWithParcelLocation() {
        return this.parcelLocation.isSelected();
    }

    public AreaLayerModel getSelectedAreaLayer() {
        if (this.areaLayerComboBox == null) {
            return this.fixedAreaLayer;
        }
        return (AreaLayerModel)this.areaLayerComboBox.getSelectedItem();
    }

    public void setCalculationWays(CalculationWay[] calculationWays) {
        this.calculationWayComboBox.setElements(false, true, calculationWays);
        this.doEnablings();
    }

    protected RouteVehicleType[] getPreselectedRouteVehicleTypes() {
        return new RouteVehicleType[]{RouteVehicleType.FOOT};
    }

    public Tupel<Collection<Tupel<AreaObjectModel, List<Model>>>, Collection<Tupel<AreaObjectModel, List<Model>>>> checkForBrokenOrders() {
        List origOrderBroken = Collections.emptyList();
        List parcelOrderBroken = Collections.emptyList();
        return new Tupel<Collection<Tupel<AreaObjectModel, List<Model>>>, Collection<Tupel<AreaObjectModel, List<Model>>>>(origOrderBroken, parcelOrderBroken);
    }

    protected abstract CalculationWay[] getSelectableCalculationWays();

    protected abstract boolean isPdfSelectable();

    protected abstract boolean isDeliveryRoundSelectable();

    protected abstract boolean areTargetsConfigurable();

    protected abstract boolean isExportFormatForced();

    protected abstract boolean isExportFormatSelectable();

    protected abstract boolean isWithSettingTab();

    protected abstract boolean isWithFixing();

    protected abstract AreaCalculationType[] getAllowedAreaCalculationTypes();

    protected abstract boolean isWithCostTab();

    protected abstract boolean isWageLayersOnly();

    protected boolean isWithFixedDateOnly() {
        return true;
    }

    private static List<RouteVehicleType> getRouteVehicleTypesToSelect() {
        ArrayList<RouteVehicleType> list = new ArrayList<RouteVehicleType>(Arrays.asList(RouteVehicleType.values()));
        Collections.sort(list, new Comparator<RouteVehicleType>(){

            @Override
            public int compare(RouteVehicleType o1, RouteVehicleType o2) {
                String message1 = ModelEnviroment.getMessageResolver().resolveMessageForEnum(o1);
                String message2 = ModelEnviroment.getMessageResolver().resolveMessageForEnum(o2);
                return message1.compareTo(message2);
            }
        });
        return list;
    }

    public Integer getDayGap() {
        if (this.dayGapRadioButton != null && this.dayGapRadioButton.isSelected()) {
            return (Integer)this.dayGapSpinner.getValue();
        }
        return null;
    }

    public void setSelectedAreaLayer(String areaLayer) {
        this.areaLayerComboBox.setLayer(areaLayer);
        AreaLayerModel selectedItem = this.areaLayerComboBox.getLayer();
        this.defaultAreaObjectChooserPane.setAreaLayerModel(selectedItem);
    }

    public void setSelectedAreaShorts(Collection<String> areaShortcuts) {
        this.defaultAreaObjectChooserPane.setSelection(areaShortcuts);
    }

    public void setSelfParameter(boolean selfParameter) {
        if (this.selfParameterCheckbox != null) {
            this.selfParameterCheckbox.setSelected(selfParameter);
        }
    }

    public void setSelectedDeliveryRound(String deliveryRound) {
        this.deliveryRoundComboBox.setSelectedDeliveryRound(deliveryRound);
    }

    public void setSelectedCalculationWay(CalculationWay calculationWay) {
        this.calculationWayComboBox.setSelectedValue(calculationWay);
    }

    public void setSelectedAreaCalculationType(AreaCalculationType areaCalculationType) {
        this.areaCalculationType.setSelectedValue(areaCalculationType);
    }

    public void setDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.dateSpinner.setValue(date);
    }

    public void setDayGap(Integer dayGap) {
        if (this.dayGapSpinner != null) {
            if (dayGap == null) {
                dayGap = 0;
            }
            this.dayGapSpinner.setValue(dayGap);
        }
    }

    public void setDateSettings(Date date, Integer dayGap) {
        this.setDate(date);
        if (this.dayGapSpinner != null) {
            this.setDayGap(dayGap);
            if (dayGap == null) {
                this.dateRadioButton.setSelected(true);
                this.dayGapRadioButton.setSelected(false);
            } else {
                this.dateRadioButton.setSelected(false);
                this.dayGapRadioButton.setSelected(true);
            }
        }
    }

    public void setTime(Tripel<Integer, Integer, Integer> time) {
        Date timeDate;
        if (time == null) {
            this.timeActive.setSelected(false);
            timeDate = TimeUtil.setTime(new Date(), 0, 0, 0);
        } else {
            this.timeActive.setSelected(true);
            timeDate = TimeUtil.setTime(new Date(), time.getElement1(), time.getElement2(), time.getElement3());
        }
        this.timeSpinner.setValue(timeDate);
    }

    public void setTourExportType(TourExportFormat tourExportFormat) {
        this.tourExportType.setSelectedValue(tourExportFormat);
    }

    public void setPdf(boolean pdf) {
        this.pdf.setSelectedValue(pdf);
    }

    public void setSelectedRouteVehicleTypes(RouteVehicleType[] routeVehicleTypes) {
        if (routeVehicleTypes == null) {
            routeVehicleTypes = new RouteVehicleType[]{};
        }
        List<RouteVehicleType> selectables = AbstractAreaTourCalculationPane.getRouteVehicleTypesToSelect();
        Iterator<RouteVehicleType> iter = selectables.iterator();
        for (JCheckBox box : this.routeVehicleTypes) {
            RouteVehicleType next = iter.next();
            boolean contains = ArrayUtils.contains((Object[])routeVehicleTypes, (Object)next);
            box.setSelected(contains);
        }
    }

    public void setPoiRouteVehicleType(boolean defaultPoiRouteVehicleType, RouteVehicleType routeVehicleType) {
        if (defaultPoiRouteVehicleType) {
            this.poiRouteVehicleType.setSelectedIndex(0);
        } else {
            this.poiRouteVehicleType.setSelectedValue(routeVehicleType);
        }
    }

    public void setPickPointRouteVehicleType(boolean defaultPickPointRouteVehicleType, RouteVehicleType pickPointRouteVehicleType) {
        if (defaultPickPointRouteVehicleType) {
            this.pickPointRouteVehicleType.setSelectedIndex(0);
        } else {
            this.pickPointRouteVehicleType.setSelectedValue(pickPointRouteVehicleType);
        }
    }

    public void setPoi(boolean poi) {
        this.poi.setSelectedValue(poi);
    }

    public void setStartPickPoint(boolean pickPointStart) {
        this.startPickPointType.setSelectedValue(pickPointStart);
    }

    public void setEndPickPoint(boolean pickPointEnd) {
        this.endPickPointType.setSelectedValue(pickPointEnd);
    }

    public void setRouteBackType(RouteBackType routeBackType) {
        this.routeBackType.setSelectedValue(routeBackType);
    }

    public void setWithDifficultyLevel(boolean withDifficultyLevel) {
        this.difficultyLevel.setSelected(withDifficultyLevel);
    }

    public void setWithParcelLocation(boolean withParcelLocation) {
        this.parcelLocation.setSelected(withParcelLocation);
    }

    public void setSubscriptionStatus(Collection<SubscriptionStatus> subscriptionStatus) {
        if (subscriptionStatus == null || subscriptionStatus.isEmpty()) {
            this.statusCombox.setSelectedValue(SubscriptionStatus.ALL);
        } else if ((subscriptionStatus = new HashSet<SubscriptionStatus>(subscriptionStatus)).size() > 1) {
            this.statusCombox.setSelectedValue(SubscriptionStatus.ALL);
        } else {
            this.statusCombox.setSelectedValue((SubscriptionStatus)((Enum)subscriptionStatus.iterator().next()));
        }
    }

    public void setSubscriptionDeliveryType(Collection<SubscriptionDeliveryType> subscriptionDeliveryType) {
        if (subscriptionDeliveryType == null || subscriptionDeliveryType.isEmpty()) {
            this.subscriptionTypeComBox.setSelectedValue(SubscriptionDeliveryType.ALL);
        } else if ((subscriptionDeliveryType = new HashSet<SubscriptionDeliveryType>(subscriptionDeliveryType)).size() > 1) {
            this.subscriptionTypeComBox.setSelectedValue(SubscriptionDeliveryType.ALL);
        } else {
            this.subscriptionTypeComBox.setSelectedValue((SubscriptionDeliveryType)((Enum)subscriptionDeliveryType.iterator().next()));
        }
    }

    public void setLetterDeliveryType(Collection<LetterDeliveryType> letterDeliveryType) {
        if (letterDeliveryType == null || letterDeliveryType.isEmpty()) {
            this.letterDeliveryTypeComboBox.setSelectedValue(LetterDeliveryType.ALL);
        } else if ((letterDeliveryType = new HashSet<LetterDeliveryType>(letterDeliveryType)).size() > 1) {
            this.letterDeliveryTypeComboBox.setSelectedValue(LetterDeliveryType.ALL);
        } else {
            this.letterDeliveryTypeComboBox.setSelectedValue((LetterDeliveryType)((Enum)letterDeliveryType.iterator().next()));
        }
    }

    public void setPreferExclusions(boolean preferExclusions) {
        if (preferExclusions) {
            this.preferExclusion.setSelected(true);
        } else {
            this.preferInclusion.setSelected(true);
        }
    }

    public void setBlockDescriptors(Collection<BlockDescriptor> blockDescriptors) {
        if (this.parcelInclusionExclusionPane != null) {
            this.parcelInclusionExclusionPane.setBlockDescriptors(blockDescriptors);
        }
    }

    public void setRewardEntity(RewardEntity rewardEntity) {
        this.rewardEntity.setElement(rewardEntity);
        Double hourReward = rewardEntity.getHourReward();
        this.hourReward.setText(hourReward == null ? "0" : hourReward.toString());
        Double kmRewardMotor = rewardEntity.getKmRewardMotor();
        this.kmRewardMotor.setText(kmRewardMotor == null ? "0" : kmRewardMotor.toString());
        Double kmRewardFoot = rewardEntity.getKmRewardFoot();
        this.kmRewardFoot.setText(kmRewardFoot == null ? "0" : kmRewardFoot.toString());
        Double kmRewardBike = rewardEntity.getKmRewardBike();
        this.kmRewardBike.setText(kmRewardBike == null ? "0" : kmRewardBike.toString());
        Double nightSurcharge = rewardEntity.getNightSurcharge();
        this.nightSurcharge.setText(nightSurcharge == null ? "0" : nightSurcharge.toString());
        Integer nightSurchargeMinMinutes = rewardEntity.getNightSurchargeMinMinutes();
        this.nightSurchargeMinMinutes.setText(nightSurchargeMinMinutes == null ? "0" : nightSurchargeMinMinutes.toString());
        Double extraCharge = rewardEntity.getExtraCharge();
        this.extraCharge.setText(extraCharge == null ? "0" : extraCharge.toString());
    }

    public void setNight(NightSurchargeTimeWindow nightSurchargeTimeWindow) {
        Date now = new Date();
        Date start = TimeUtil.setTime(now, nightSurchargeTimeWindow.getStartHour(), nightSurchargeTimeWindow.getStartMinute(), 0);
        Date end = TimeUtil.setTime(now, nightSurchargeTimeWindow.getEndHour(), nightSurchargeTimeWindow.getEndMinute(), 0);
        this.nightTimeWindow.setElement(new Tupel<Date, Date>(start, end));
        this.nightWindowStart.setText(FormUtil.dateToString(start, FormUtil.TIMEFORMAT, ""));
        this.nightWindowEnd.setText(FormUtil.dateToString(end, FormUtil.TIMEFORMAT, ""));
    }

    protected boolean isWithAreaClipboardAction() {
        return false;
    }

    private class RouteTypeComboBox
    extends EnumComboBox<RouteVehicleType> {
        private static final long serialVersionUID = -3947538824447102793L;

        public RouteTypeComboBox(boolean withDefault) {
            String[] stringArray;
            List list = AbstractAreaTourCalculationPane.getRouteVehicleTypesToSelect();
            if (withDefault) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.default", new Serializable[0]);
            } else {
                stringArray = new String[]{};
            }
            super(RouteVehicleType.class, false, list, stringArray);
        }

        public boolean isDefaultSelected() {
            return this.getSelectedIndex() == 0;
        }
    }

    private class ReviewListener
    implements ActionListener {
        private ReviewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAreaTourCalculationPane.this.doEnablings();
        }
    }
}

