/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.area.AreaObjectListCellRenderer;
import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelector;
import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.ktde.util.datatypes.Tupel;

public class MultiAreaObjectSelectionPane
extends JPanel
implements MultiAreaObjectSelector {
    private static final long serialVersionUID = -631119926421908358L;
    private ModelEnviroment modelEnviroment;
    private JList selectedAreaObjectList;
    private JList areaObjectToSelectList;
    private List<AreaObjectModel> selectable;
    private JComboBox layerComboBox;
    private JTextField preChooserTextField;
    private AddAction addAction;
    private RemoveAction removeAction;
    private List<Tupel<String, Map<String, String[]>>> sumSettings;
    private List<JTextField> sumFields;

    public MultiAreaObjectSelectionPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        Collection<AreaLayerModel> layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        for (AreaLayerModel areaLayerModel : layers) {
            this.layerComboBox.addItem(areaLayerModel);
        }
        if (!layers.isEmpty()) {
            this.layerComboBox.setSelectedIndex(0);
        }
    }

    private void buildLayout() {
        Component s;
        JPanel superPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JLabel title = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.selectedAreas", new Serializable[0]));
        title.setHorizontalAlignment(0);
        panel.add((Component)title, "North");
        this.selectedAreaObjectList = new JList(new DefaultListModel());
        this.selectedAreaObjectList.setCellRenderer(new AreaObjectListCellRenderer(this.selectedAreaObjectList.getCellRenderer(), true, this.getAttributesToShow()));
        this.selectedAreaObjectList.setSelectionMode(2);
        this.selectedAreaObjectList.getModel().addListDataListener(new SelectedAreaListDataListener());
        panel.add((Component)new JScrollPane(this.selectedAreaObjectList), "Center");
        superPanel.add((Component)panel, "West");
        this.sumSettings = this.getSumSettings();
        panel = new JPanel(new BorderLayout());
        JPanel lowerPanel = new JPanel(new SpringLayout());
        this.addAction = new AddAction();
        JButton add = new JButton(this.addAction);
        lowerPanel.add(add);
        this.removeAction = new RemoveAction();
        JButton remove = new JButton(this.removeAction);
        lowerPanel.add(remove);
        SpringUtilities.makeCompactGrid(lowerPanel, 2, 1, 2, 2, 2, 2);
        panel.add((Component)lowerPanel, "South");
        Action specialChooserAction = this.getSpecialChooserAction();
        if (specialChooserAction != null) {
            JButton graphicalChooser = new JButton(specialChooserAction);
            panel.add((Component)graphicalChooser, "North");
        }
        superPanel.add((Component)panel, "Center");
        panel = new JPanel(new BorderLayout());
        JPanel sPanel = new JPanel(new SpringLayout());
        title = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]));
        sPanel.add(title);
        this.layerComboBox = new JComboBox();
        this.layerComboBox.addActionListener(new ComboBoxActionListener());
        this.layerComboBox.setRenderer(new AbstractStringListCellRenderer(this.layerComboBox.getRenderer()){

            @Override
            protected String getString(Object value) {
                if (value instanceof AreaLayerModel) {
                    AreaLayerModel areaLayerModel = (AreaLayerModel)value;
                    return areaLayerModel.getDisplayname();
                }
                return value == null ? null : value.toString();
            }
        });
        sPanel.add(this.layerComboBox);
        JButton button = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.insertFromClipboard", new Serializable[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                    AreaLayerModel areaLayerModel = (AreaLayerModel)MultiAreaObjectSelectionPane.this.layerComboBox.getSelectedItem();
                    HashSet<String> shortCuts = new HashSet<String>();
                    StringTokenizer st = new StringTokenizer(data);
                    while (st.hasMoreTokens()) {
                        shortCuts.add(st.nextToken());
                    }
                    Collection<AreaObjectModel> areaObjects = MultiAreaObjectSelectionPane.this.modelEnviroment.getAllCaller().getAreaCaller().getAreaObjectByKeysAndLayerIds(shortCuts, Collections.singleton(areaLayerModel.getId()));
                    MultiAreaObjectSelectionPane.this.addSelection(areaObjects);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        sPanel.add(button);
        this.preChooserTextField = new JTextField();
        this.preChooserTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiAreaObjectSelectionPane.this.preChoose();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiAreaObjectSelectionPane.this.preChoose();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultiAreaObjectSelectionPane.this.preChoose();
            }
        });
        sPanel.add(this.preChooserTextField);
        SpringUtilities.makeCompactGrid(sPanel, 4, 1, 2, 2, 2, 2);
        panel.add((Component)sPanel, "North");
        this.areaObjectToSelectList = new JList(new DefaultListModel());
        this.areaObjectToSelectList.setCellRenderer(new AreaObjectListCellRenderer(this.selectedAreaObjectList.getCellRenderer(), false, this.getAttributesToShow()));
        this.areaObjectToSelectList.setSelectionMode(2);
        this.selectable = new LinkedList<AreaObjectModel>();
        panel.add((Component)new JScrollPane(this.areaObjectToSelectList), "Center");
        superPanel.add((Component)panel, "East");
        JPanel sumPanel = null;
        if (this.sumSettings != null && !this.sumSettings.isEmpty()) {
            this.sumFields = new ArrayList<JTextField>(this.sumSettings.size());
            sumPanel = new JPanel(new SpringLayout());
            for (Tupel<String, Map<String, String[]>> tupel : this.sumSettings) {
                sumPanel.add(new JLabel(tupel.getElement1()));
                JTextField field = new JTextField(5);
                field.setEditable(false);
                sumPanel.add(field);
                this.sumFields.add(field);
            }
            SpringUtilities.makeCompactGrid(sumPanel, this.sumSettings.size(), 2, 2, 2, 2, 2);
        }
        if ((s = this.getSouthComponent()) != null || sumPanel != null) {
            JPanel specialPanel = new JPanel(new BorderLayout());
            specialPanel.add((Component)superPanel, "West");
            JPanel specialInnerPanel = new JPanel(new BorderLayout());
            if (s != null) {
                specialInnerPanel.add(s, "North");
            }
            if (sumPanel != null) {
                specialInnerPanel.add((Component)sumPanel, "South");
            }
            specialPanel.add((Component)specialInnerPanel, "Center");
            this.add((Component)specialPanel, "West");
        } else {
            this.add((Component)superPanel, "Center");
        }
    }

    private void preChoose() {
        String text = this.preChooserTextField.getText().toLowerCase();
        DefaultListModel dlm = (DefaultListModel)this.areaObjectToSelectList.getModel();
        Object[] selected = this.areaObjectToSelectList.getSelectedValues();
        int index = 0;
        for (AreaObjectModel areaObjectModel : this.selectable) {
            boolean currentInList;
            boolean matches = areaObjectModel.getShortcut().toLowerCase().startsWith(text) || areaObjectModel.getDisplayname().toLowerCase().startsWith(text);
            AreaObjectModel currentShown = index >= dlm.size() ? null : (AreaObjectModel)dlm.getElementAt(index);
            boolean bl = currentInList = currentShown != null && currentShown.equals(areaObjectModel);
            if (matches) {
                if (currentInList) {
                    ++index;
                    continue;
                }
                dlm.insertElementAt(areaObjectModel, index);
                ++index;
                continue;
            }
            if (!currentInList) continue;
            dlm.removeElementAt(index);
        }
    }

    private List<Tupel<String, Map<String, String[]>>> getSumSettings() {
        String sumName;
        LinkedList<String> sumNames = new LinkedList<String>();
        int i = 1;
        while ((sumName = ModelEnviroment.getProperties().getProperty("offer.area.sum." + i)) != null) {
            sumNames.add(sumName);
            ++i;
        }
        Collection<AreaLayerModel> layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        ArrayList<Tupel<String, Map<String, String[]>>> sums = new ArrayList<Tupel<String, Map<String, String[]>>>(sumNames.size());
        int innerCounter = 1;
        for (String sumName2 : sumNames) {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (AreaLayerModel layer : layers) {
                String attribute;
                String layerName = layer.getDisplayname();
                String propLayerName = layerName.replace(' ', '_');
                LinkedList<String> attributes = new LinkedList<String>();
                i = 1;
                while ((attribute = ModelEnviroment.getProperties().getProperty("offer.area.sum." + innerCounter + "." + propLayerName + "." + i)) != null) {
                    attributes.add(attribute);
                    ++i;
                }
                String[] a = new String[attributes.size()];
                a = attributes.toArray(a);
                map.put(layerName, a);
            }
            sums.add(new Tupel(sumName2, map));
            ++innerCounter;
        }
        return sums;
    }

    private Map<String, String[]> getAttributesToShow() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Collection<AreaLayerModel> layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        for (AreaLayerModel layer : layers) {
            String attribute;
            String layerName = layer.getDisplayname();
            String propLayerName = layerName.replace(' ', '_');
            LinkedList<String> attributes = new LinkedList<String>();
            int i = 1;
            while ((attribute = ModelEnviroment.getProperties().getProperty("offer.area.attributeToShow." + propLayerName + "." + i)) != null) {
                attributes.add(attribute);
                ++i;
            }
            String[] a = new String[attributes.size()];
            a = attributes.toArray(a);
            map.put(layerName, a);
        }
        return map;
    }

    protected Component getSouthComponent() {
        return null;
    }

    protected Action getSpecialChooserAction() {
        return null;
    }

    public AreaLayerModel getSelectedAreaLayer() {
        return (AreaLayerModel)this.layerComboBox.getSelectedItem();
    }

    public int[] getSums() {
        if (this.sumFields != null) {
            int[] sums = new int[this.sumFields.size()];
            int count = 0;
            for (JTextField sumField : this.sumFields) {
                String sum = sumField.getText();
                try {
                    sums[count] = Integer.parseInt(sum);
                }
                catch (NumberFormatException ex) {
                    sums[count] = 0;
                }
                ++count;
            }
            return sums;
        }
        return new int[0];
    }

    public void removeSelection(Set<AreaObjectModel> areaObjectModels) {
        DefaultListModel dlm = (DefaultListModel)this.selectedAreaObjectList.getModel();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            dlm.removeElement(areaObjectModel);
        }
        this.loadAreaObjectsForLayer();
    }

    public void addSelection(Collection<AreaObjectModel> areaObjectModels) {
        HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>(areaObjectModels);
        DefaultListModel dlm = (DefaultListModel)this.selectedAreaObjectList.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            set.remove(dlm.getElementAt(i));
        }
        for (Object e : set) {
            dlm.addElement(e);
        }
        dlm = (DefaultListModel)this.areaObjectToSelectList.getModel();
        for (Object object : areaObjectModels) {
            dlm.removeElement(object);
            this.selectable.remove(object);
        }
    }

    @Override
    public Collection<AreaObjectModel> getSelectedAreaObjects() {
        DefaultListModel dlm = (DefaultListModel)this.selectedAreaObjectList.getModel();
        int size = dlm.size();
        ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(size);
        for (int i = 0; i < size; ++i) {
            list.add((AreaObjectModel)dlm.elementAt(i));
        }
        return list;
    }

    public JList getSelectedAreaObjectList() {
        return this.selectedAreaObjectList;
    }

    @Override
    public void setSelectedAreaObjects(Collection<AreaObjectModel> areaObjectModels) {
        DefaultListModel dlm = (DefaultListModel)this.selectedAreaObjectList.getModel();
        dlm.clear();
        this.selectable.clear();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            dlm.addElement(areaObjectModel);
            this.selectable.add(areaObjectModel);
        }
        this.preChoose();
    }

    private void loadAreaObjectsForLayer() {
        DefaultListModel dlm = (DefaultListModel)this.areaObjectToSelectList.getModel();
        dlm.clear();
        this.selectable.clear();
        AreaLayerModel areaLayerModel = (AreaLayerModel)this.layerComboBox.getSelectedItem();
        if (areaLayerModel != null) {
            List<AreaObjectModel> areaObjectModels = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObjectsByAreaLayer(areaLayerModel, false);
            DefaultListModel dlm2 = (DefaultListModel)this.selectedAreaObjectList.getModel();
            for (AreaObjectModel areaObjectModel : areaObjectModels) {
                if (dlm2.contains(areaObjectModel)) continue;
                dlm.addElement(areaObjectModel);
                this.selectable.add(areaObjectModel);
            }
        }
        this.preChoose();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.layerComboBox.setEnabled(enabled);
        this.addAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected void recalcSums() {
        if (this.sumSettings != null && !this.sumSettings.isEmpty()) {
            Set<AreaObjectModel> toCalculate = this.getAreaObjectModelsToCalculate();
            Integer[] integerValues = new Integer[this.sumSettings.size()];
            Double[] doubleValues = new Double[this.sumSettings.size()];
            for (AreaObjectModel areaObjectModel : toCalculate) {
                AreaLayerModel areaLayer;
                if (areaObjectModel == null || (areaLayer = areaObjectModel.getAreaLayer()) == null) continue;
                String layerName = areaLayer.getDisplayname();
                Iterator<Tupel<String, Map<String, String[]>>> sumIter = this.sumSettings.iterator();
                int counter = 0;
                while (sumIter.hasNext()) {
                    Tupel<String, Map<String, String[]>> tupel = sumIter.next();
                    Map<String, String[]> map = tupel.getElement2();
                    String[] attributes = map.get(layerName);
                    if (attributes != null && attributes.length > 0) {
                        block6: for (AreaAttributeValueModel areaAttributeValueModel : areaObjectModel.iterableAreaAttributeValues()) {
                            AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel = areaAttributeValueModel.getAreaAttributeValueDescriptor();
                            String key = areaAttributeValueDescriptorModel.getKey();
                            for (String attribute : attributes) {
                                if (!attribute.equals(key)) continue;
                                switch (areaAttributeValueDescriptorModel.getAttributeValueType()) {
                                    case INTEGER: {
                                        Integer iValue;
                                        Integer iSetValue = integerValues[counter];
                                        if (iSetValue == null) {
                                            iSetValue = 0;
                                        }
                                        if ((iValue = areaAttributeValueModel.getIntegerValue()) != null) {
                                            iSetValue = iSetValue + iValue;
                                        }
                                        integerValues[counter] = iSetValue;
                                        break;
                                    }
                                    case FLOAT: {
                                        Double dValue;
                                        Double dSetValue = doubleValues[counter];
                                        if (dSetValue == null) {
                                            dSetValue = 0.0;
                                        }
                                        if ((dValue = areaAttributeValueModel.getFloatValue()) != null) {
                                            dSetValue = dSetValue + dValue;
                                        }
                                        doubleValues[counter] = dSetValue;
                                    }
                                }
                                continue block6;
                            }
                        }
                    }
                    ++counter;
                }
            }
            int counter = 0;
            for (JTextField field : this.sumFields) {
                String value = "0";
                Integer i = integerValues[counter];
                if (i != null) {
                    value = i.toString();
                } else {
                    Double d = doubleValues[counter];
                    if (d != null) {
                        value = d.toString();
                    }
                }
                field.setText(value);
                ++counter;
            }
        }
    }

    protected Set<AreaObjectModel> getAreaObjectModelsToCalculate() {
        ListModel model = this.selectedAreaObjectList.getModel();
        HashSet<AreaObjectModel> toCalculate = new HashSet<AreaObjectModel>();
        for (int i = 0; i < model.getSize(); ++i) {
            toCalculate.add((AreaObjectModel)model.getElementAt(i));
        }
        return toCalculate;
    }

    private class SelectedAreaListDataListener
    implements ListDataListener {
        private SelectedAreaListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            MultiAreaObjectSelectionPane.this.recalcSums();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            MultiAreaObjectSelectionPane.this.recalcSums();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            MultiAreaObjectSelectionPane.this.recalcSums();
        }
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiAreaObjectSelectionPane.this.loadAreaObjectsForLayer();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 4906786251997661609L;

        private RemoveAction() {
            super(">");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] areaObjectModels = MultiAreaObjectSelectionPane.this.selectedAreaObjectList.getSelectedValues();
            HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>();
            for (Object object : areaObjectModels) {
                set.add((AreaObjectModel)object);
            }
            MultiAreaObjectSelectionPane.this.removeSelection(set);
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1855595610337609014L;

        private AddAction() {
            super("<");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] areaObjectModels = MultiAreaObjectSelectionPane.this.areaObjectToSelectList.getSelectedValues();
            HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>();
            for (Object object : areaObjectModels) {
                set.add((AreaObjectModel)object);
            }
            MultiAreaObjectSelectionPane.this.addSelection(set);
        }
    }
}

